; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -mtriple i686-unknown-unknown -codegenprepare -S | FileCheck %s

target datalayout = "e-p:8:8"

; The shl has UB (shift count oob). This used to result in undefined behavior
; in codegenprepare when AddressingModeMatcher::matchOperationAddr tried to
; shift a variable by that amount during compilation. Intent with the test
; case is to verify that this compiles without complaints even if opt is built
; with ubsan enabled.
define dso_local void @main(i32 %a, ptr %p) {
; CHECK-LABEL: @main(
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 [[A:%.*]], -1229216766
; CHECK-NEXT:    [[ARRAYIDX926:%.*]] = getelementptr inbounds [3 x ptr], ptr [[P:%.*]], i32 0, i32 [[SHL]]
; CHECK-NEXT:    [[L0:%.*]] = load ptr, ptr [[ARRAYIDX926]], align 1
; CHECK-NEXT:    ret void
;
  %shl = shl i32 %a, -1229216766
  %arrayidx926 = getelementptr inbounds [3 x ptr], ptr %p, i32 0, i32 %shl
  %l0 = load ptr, ptr %arrayidx926, align 1
  ret void
}
