#include <stdio.h>
#include <string.h>
#include <forms.h>
#include "xgod.h"
#include "main.h"

FD_main *a;
FD_file *b;
FD_choice *c;
FD_dia *d;
FD_info *e;
FD_marks *f;

FL_OBJECT *o;

int min_x, min_y, max_x, max_y;
char caption[80];
int newfile = 0;
char fullpath[80];

struct 
{
   int color;
   int symbol;
} s[20][20];


void draw_lines (int, int);

void reset_goban()
{
   register int x,y;
   
   for (x=0;x<=19;x++)
	for (y=0;y<=19;y++)
	  s[x][y].color = s[x][y].symbol =0;
}

char *path (char *str)
{
   fullpath[0] = '\0';
   strcat (fullpath, BITMAPPATH);
   strcat (fullpath, str);
   return (fullpath);
}

char *textpath (char *str)
{
   fullpath[0] = '\0';
   strcat (fullpath, TEXTPATH);
   strcat (fullpath, str);
   return (fullpath);
}

main (int argc, char *argv[])
{
   fl_initialize(&argc, argv, "", 0, 0);
   a = create_form_main();
   b = create_form_file();
   c = create_form_choice();
   d = create_form_dia();
   e = create_form_info();
   f = create_form_marks();
   fl_set_bitmapbutton_file (c->bb[1], path ("g2.xbm"));     
   fl_set_bitmapbutton_file (c->bb[2], path ("g7.xbm"));
   fl_set_bitmapbutton_file (c->bb[3], path ("g3.xbm"));
   fl_set_bitmapbutton_file (c->bb[4], path ("g6.xbm"));
   fl_set_bitmapbutton_file (c->bb[5], path ("g1.xbm"));
   fl_set_bitmapbutton_file (c->bb[6], path ("g8.xbm"));
   fl_set_bitmapbutton_file (c->bb[7], path ("g5.xbm"));
   fl_set_bitmapbutton_file (c->bb[8], path ("g9.xbm"));
   fl_set_bitmapbutton_file (c->bb[9], path ("g4.xbm"));
   fl_set_pixmap_file (a->xpm1, path ("go.xpm"));
   fl_set_bitmapbutton_file (d->mb[1], path ("a.xbm"));
   fl_set_bitmapbutton_file (d->mb[2], path ("b.xbm"));
   fl_set_bitmapbutton_file (d->mb[3], path ("c.xbm"));
   fl_set_bitmapbutton_file (d->mb[4], path ("d.xbm"));
   fl_set_bitmapbutton_file (d->mb[5], path ("e.xbm"));
   fl_set_bitmapbutton_file (d->mb[6], path ("more.xbm"));
   fl_set_bitmapbutton_file (f->b[1], path ("f.xbm"));
   fl_set_bitmapbutton_file (f->b[2], path ("g.xbm"));
   fl_set_bitmapbutton_file (f->b[3], path ("h.xbm"));
   fl_set_bitmapbutton_file (f->b[4], path ("i.xbm"));
   fl_set_bitmapbutton_file (f->b[5], path ("j.xbm"));
   fl_set_bitmapbutton_file (f->b[6], path ("sbtri.xbm"));
   fl_set_bitmapbutton_file (f->b[7], path ("swtri.xbm"));
   fl_set_bitmapbutton_file (f->b[8], path ("sbsq.xbm"));
   fl_set_bitmapbutton_file (f->b[9], path ("swsq.xbm"));
   fl_set_bitmapbutton_file (f->b[10], path ("x.xbm"));
   fl_show_form (a->main, FL_PLACE_FREE, FL_FULLBORDER, "Main menu");
   while ((o=fl_do_forms())!=a->bq)
	;
}

void start (FL_OBJECT *o, long n)
{
   fl_show_form (b->file, FL_PLACE_FREE, FL_FULLBORDER, "File menu");
}

void open_info (FL_OBJECT *o, long n)
{
   fl_show_form (e->info, FL_PLACE_FREE, FL_FULLBORDER, "Info window");
}

void close_file (FL_OBJECT *o, long n)
{
   fl_hide_form (b->file);
}

void fselect (FL_OBJECT *o, long n)
{
   fl_set_input (b->in, fl_show_fselector ("File Name:","/","*.*",""));
}

int get_row (char c)
{
   if (c>='a' && c<='i')
	return (c-96);
   else if (c>='k' && c<'u')
	return (c-97);
   else
	return (0);
} /* transforma caracterul de rind din go.sty in numar */

void get_coord (char *ps)
{
   char r[50];
   
   strcpy (r, ps);
   min_y = get_row (r[0]);
   max_y = get_row (r[2]);
   min_x = r[4] - 48;
   if (r[5]!='-')
	min_x = 10*min_x + r[5] - 48;
   if (r[5]=='-')
	{
	   max_x = r[6] - 48;
	   if (r[7]!='\0')
		max_x = 10*max_x + r[7] - 48;
	}
   else if (r[6]=='-')
	{
	   max_x = r[7] - 48;
	   if (r[8]!='\0')
		max_x = 10*max_x + r[8] - 48;
	}
   if (min_x==1 && min_y==1 && max_x==19 && max_y==19)
	fl_set_button (c->bb[5], 1);
   else if (min_x==1 && min_y==1)
	fl_set_button (c->bb[1], 1);
   else if (min_x==1 && max_y==19)
	fl_set_button (c->bb[7], 1);
   else if (max_x==19 && min_y==1)
	fl_set_button (c->bb[3], 1);
   else if (max_x==19 && max_y==19)
	fl_set_button (c->bb[9], 1);
   else if (min_x==1 && min_y<10)
	fl_set_button (c->bb[4], 1);
   else if (min_x<10 && min_y==1)
	fl_set_button (c->bb[2], 1);
   else if (max_x==19 && min_y<10)
	fl_set_button (c->bb[6], 1);
   else if (min_x<10 && max_y==19)
	fl_set_button (c->bb[8], 1);
}

void get_symbol (char *ps)
{
   int x,y;
   int col;
   /* don't look, this code feels so bad ! */
   
   ps+=5;
   y = get_row (*ps);
   ps+=3;
   x = *ps++ - 48;
   if (*ps!='}')
	x = 10*x + *ps++ - 48; 
   ps+=3;
   if (strncmp (ps, "black", 5)==0)
	col = BLACK;
   else if (strncmp (ps, "white", 5)==0)
	col = WHITE;
   else if (strncmp (ps, "letter", 6)==0)
	col = 0;
   s[x][y].color = col;
   ps+=5;
   if (*ps=='.')
	s[x][y].symbol = 0;
   else if (*ps=='{')
	{
	   if (strcmp (ps, "{\\triangle}")==0)
		{
		   if (col==BLACK)
			s[x][y].symbol = BTRI;
		   else if (col==WHITE)
			s[x][y].symbol = WTRI;
		}
	   else if (strcmp (ps, "{\\square}")==0)
		{
		   if (col==BLACK)
			s[x][y].symbol = BSQ;
		   else if (col==WHITE)
			s[x][y].symbol = WSQ;
		}
	   else
		{
		   ps++;
		   s[x][y].symbol = *ps++ - 48;
		   if (*ps!='}')
			s[x][y].symbol = 10*s[x][y].symbol + *ps - 48;
		}
	}
   else if (*ps=='r')
	{
	   ps+=2;
	   s[x][y].symbol = *ps + 403;
	}
}

void read_go_file (char *s)
{
   FILE *file;
   char r[30];
   int t;

   reset_goban();
   if ((file = fopen (s, "r"))==NULL)
	{
	   fl_show_alert ("", "New file","",0);
	   newfile = 1;
	   return;
	}
   while (fscanf (file, "%s\n", r)!=EOF)
	if (strcmp (r,"\\inidiagram")==0)
	  {
		fscanf (file, "%s\n", r);
		get_coord (r);
 	  }
   else if (strcmp (r, "\\gofontsize{10}")==0)
	fl_set_button (c->b1, 1);
   else if (strcmp (r, "\\gofontsize{15}")==0)
	fl_set_button (c->b2, 1);
   else if (strcmp (r, "\\gofontsize{20}")==0)
	fl_set_button (c->b3, 1);
   else if (strcmp (r, "\\begin{flushleft}")==0)
	fl_set_button (c->b4, 1);
   else if (strcmp (r, "\\begin{center}")==0)
	fl_set_button (c->b5, 1);
   else if (strcmp (r, "\\begin{flushright}")==0)
	fl_set_button (c->b6, 1);
   else if (strncmp (r, "\\pos", 4)==0)
	get_symbol (r);
	   
   fl_set_counter_value (c->cx, max_x - min_x + 1);
   fl_set_counter_value (c->cy, max_y - min_y + 1);
}

void open_choice (FL_OBJECT *o, long n)
{
   char *s;
   
   s = fl_get_input (b->in);
   if (strcmp(s,"")==0)
	fl_show_alert ("Empty file name","","",1);
   else
	{
	   fl_hide_form (b->file);
	   read_go_file (s);
	   fl_show_form (c->choice, FL_PLACE_FREE, FL_FULLBORDER, s);
	}
}

void close_choice (FL_OBJECT *o, long n)
{ 
   fl_hide_form (c->choice);
}

void shape (FL_OBJECT *o, long n)
{
   if (n==1 || n==3 || n==7 || n==9)
	{
	   fl_set_counter_value (c->cx, 10);
	   fl_set_counter_value (c->cy, 10);
	}
   else if (n==2 || n==8)
	{
	   fl_set_counter_value (c->cx, 9);
	   fl_set_counter_value (c->cy, 6);
	}
   else if (n==4 || n==6)
	{
	   fl_set_counter_value (c->cx, 6);
	   fl_set_counter_value (c->cy, 9);
	}
   else if (n==5)
	{
	   fl_set_counter_value (c->cx, 19);
	   fl_set_counter_value (c->cy, 19);
	}
}

void draw_lines (int x, int y)
{
   if (x==1 && y==1)
	fl_set_bitmap_file (d->b[x][y], path ("ss.xbm"));
   else if (x==19 && y==1)
	fl_set_bitmap_file (d->b[x][y], path ("ds.xbm"));
   else if (x==1 && y==19)
	fl_set_bitmap_file (d->b[x][y], path ("sj.xbm"));
   else if (x==19 && y==19)
	fl_set_bitmap_file (d->b[x][y], path ("dj.xbm"));
   else if (x==1)
	fl_set_bitmap_file (d->b[x][y], path ("ls.xbm"));
   else if (x==19)
	fl_set_bitmap_file (d->b[x][y], path ("ld.xbm"));
   else if (y==1)
	fl_set_bitmap_file (d->b[x][y], path ("lu.xbm"));
   else if (y==19)
	fl_set_bitmap_file (d->b[x][y], path ("lj.xbm"));
   else
	fl_set_bitmap_file (d->b[x][y], path ("ml.xbm"));
   s[x][y].color = 0;
   s[x][y].color = 0;
}

void open_dia (FL_OBJECT *o, long n)
{
   int x,y;
   char str[50];

   fl_freeze_form (d->dia);
   max_x = fl_get_counter_value (c->cx);
   max_y = fl_get_counter_value (c->cy);
   if (max_x==0 || max_y ==0)
	{
	   fl_show_alert ("","Zero length or width diagram","",1);
	   return;
	}
   if (fl_get_button (c->bb[1]))
	{
	   min_x = min_y = 1;
	}
   else if (fl_get_button (c->bb[2]))
	{
	   min_x = 10 - max_x/2;
	   min_y = 1;
	   max_x += min_x - 1;
	}
   else if (fl_get_button (c->bb[3]))
	{
	   min_x = 20 - max_x;
	   max_x = 19;
	   min_y = 1;
	}
   else if (fl_get_button (c->bb[4]))
	{
	   min_x = 1;
	   min_y = 10 - max_y/2;
	   max_y += min_y - 1;
	}
   else if (fl_get_button (c->bb[5]))
	{
	   min_x = 10 - max_x/2;
	   max_x += min_x - 1;
	   min_y = 10 - max_y/2;
	   max_y += min_y - 1;
	}
   else if (fl_get_button (c->bb[6]))
	{
	   min_y = 10 - max_y/2;
	   max_y += min_y - 1;
	   min_x = 20 - max_x;
	   max_x = 19;
	}
   else if (fl_get_button (c->bb[7]))
	{
	   min_x = 1;
	   min_y = 20 - max_y;
	   max_y = 19;
	}
   else if (fl_get_button (c->bb[8]))
	{
	   min_x = 10 - max_x/2;
	   max_x += min_x - 1;
	   min_y = 20 - max_y;
	   max_y = 19;
	}
   else if (fl_get_button (c->bb[9]))
	{
	   min_x = 20 - max_x;
	   max_x = 19;
	   min_y = 20 - max_y;
	   max_y = 19;
	}
   else
	{
	   fl_show_alert ("","Please select a shape","",0);
	   return;
	}
		 
   for (x=min_x;x<=max_x;x++)
	for (y=min_y;y<=max_y;y++)
	{
	   if (newfile)
		draw_lines (x,y);
	   else
		{
		   if (s[x][y].color==0)
			{
			   if (s[x][y].symbol==0)
				draw_lines (x, y);
			   else 
				{
				   sprintf (str, "%s%c.xbm", path (""), 
						  s[x][y].symbol - 403);
				   fl_set_bitmap_file (d->b[x][y], str);
				}
			}
		   else if (s[x][y].color==BLACK)
			{
			   if (s[x][y].symbol==0)
				fl_set_bitmap_file (d->b[x][y], path ("black.xbm"));
			   else if (s[x][y].symbol<BTRI)
				{
				   sprintf (str, "%sb%d.xbm", path (""), s[x][y].symbol);
				   fl_set_bitmap_file (d->b[x][y], str);
				}
			   else if (s[x][y].symbol==BTRI)
				fl_set_bitmap_file (d->b[x][y], path ("btri.xbm"));
			   else if (s[x][y].symbol==BSQ)
				fl_set_bitmap_file (d->b[x][y], path ("bsq.xbm"));
			}
		   else if (s[x][y].color==WHITE)
			{
			   if (s[x][y].symbol==0)
				fl_set_bitmap_file (d->b[x][y], path ("white.xbm"));
			   else if (s[x][y].symbol<WTRI)
				{
				   sprintf (str, "%sw%d.xbm", path (""), s[x][y].symbol);
				   fl_set_bitmap_file (d->b[x][y], str);
				}
			   else if (s[x][y].symbol==WTRI)
				fl_set_bitmap_file (d->b[x][y], path ("wtri.xbm"));
			   else if (s[x][y].symbol==WSQ)
				fl_set_bitmap_file (d->b[x][y], path ("wsq.xbm"));
			}
		}
	}
   for (x=1;x<=19;x++)
	for (y=1;y<=19;y++)
	  if (x<min_x || x>max_x || y<min_y || y>max_y)
	{
	   fl_set_bitmap_file (d->b[x][y], path ("empty.xbm"));
	   s[x][y].color = 0;
	   s[x][y].symbol = 0;
	}
   fl_unfreeze_form (d->dia);
   fl_show_form (d->dia, FL_PLACE_FREE, FL_FULLBORDER, fl_get_input (b->in));
}

void close_dia (FL_OBJECT *o, long n)
{
   fl_hide_form (d->dia);
}

void stone (FL_OBJECT *o, long n)
{
   int x, y;
   int erase = 0;
   int num;
   char col;
   char str[10];
   
   erase = fl_get_button (d->ber);
   y = n/20+1;
   x = n-(y-1)*20;
      
   if (x<min_x || x>max_x || y <min_y || y>max_y)
	return;
   
   if (erase)
	{
	   draw_lines (x, y);
	   s[x][y].color = 0;
	   s[x][y].symbol = 0;
	}
   else if (fl_get_button (d->bu)) /*use marks */
	{
	   s[x][y].color = 0;
	   if (fl_get_button (d->mb[1]))
		{
		   fl_set_bitmap_file (d->b[x][y], path ("a.xbm"));
		   s[x][y].symbol = A;
		}
	   else if (fl_get_button (d->mb[2]))
		{
		   fl_set_bitmap_file (d->b[x][y], path ("b.xbm"));
		   s[x][y].symbol = B;
		}
	   else if (fl_get_button (d->mb[3]))
		{
		   fl_set_bitmap_file (d->b[x][y], path ("c.xbm"));
		   s[x][y].symbol = C;
		}
	   else if (fl_get_button (d->mb[4]))
		{
		   fl_set_bitmap_file (d->b[x][y], path ("d.xbm"));
		   s[x][y].symbol = D;
		}
	   else if (fl_get_button (d->mb[5]))
		{
		   fl_set_bitmap_file (d->b[x][y], path ("e.xbm"));
		   s[x][y].symbol = E;
		}
	   else if (fl_get_button (d->mb[6]))
		{
		   if (fl_get_button (f->b[1]))
			{
			   fl_set_bitmap_file (d->b[x][y], path ("f.xbm"));
			   s[x][y].symbol = F;
			}
		   else if (fl_get_button (f->b[2]))
			{
			   fl_set_bitmap_file (d->b[x][y], path ("g.xbm"));
			   s[x][y].symbol = G;
			}
		   else if (fl_get_button (f->b[3]))
			{
			   fl_set_bitmap_file (d->b[x][y], path ("h.xbm"));
			   s[x][y].symbol = H;
			}
		   else if (fl_get_button (f->b[4]))
			{
			   fl_set_bitmap_file (d->b[x][y], path ("i.xbm"));
			   s[x][y].symbol = I;
			}
		   else if (fl_get_button (f->b[5]))
			{
			   fl_set_bitmap_file (d->b[x][y], path ("j.xbm"));
			   s[x][y].symbol = J;
			}
		   else if (fl_get_button (f->b[6]))
			{
			   fl_set_bitmap_file (d->b[x][y], path ("btri.xbm"));
			   s[x][y].symbol = BTRI;
			   s[x][y].color = BLACK;
			}
		   else if (fl_get_button (f->b[7]))
			{
			   fl_set_bitmap_file (d->b[x][y], path ("wtri.xbm"));
			   s[x][y].symbol = WTRI;
			   s[x][y].color = WHITE;
			}
		   else if (fl_get_button (f->b[8]))
			{
			   fl_set_bitmap_file (d->b[x][y], path ("bsq.xbm"));
			   s[x][y].symbol = BSQ;
			   s[x][y].color = BLACK;
			}
		   else if (fl_get_button (f->b[9]))
			{
			   fl_set_bitmap_file (d->b[x][y], path ("wsq.xbm"));
			   s[x][y].symbol = WSQ;
			   s[x][y].color = WHITE;
			}
		   else if (fl_get_button (f->b[10]))
			{
			   fl_set_bitmap_file (d->b[x][y], path ("x.xbm"));
			   s[x][y].symbol = X;
			}
		}
	}
   else if (fl_get_button (d->bnr)) /* numbered moves */
	{
	   num = fl_get_counter_value (d->cn);
	   if (fl_get_button (d->bb))
		{
		   col = 'b';
		   s[x][y].color = BLACK;
		}
	   else if (fl_get_button (d->bw))
		{
		   col = 'w';
		   s[x][y].color = WHITE;
		}
	   sprintf (str,"%c%d.xbm",col,num);
	   fl_set_bitmap_file (d->b[x][y], path (str));
	   s[x][y].symbol = num;
	   
	   if (col=='b')
		{
		   fl_set_button (d->bb, 0);
		   fl_set_button (d->bw, 1);
		}
	   else if (col=='w')
		{
		   fl_set_button (d->bb, 1);
		   fl_set_button (d->bw, 0);
		}
	   increase_no (d->cn, 1); /* parametrii fara importanta */
	}
   else /* just black or white */
	{
	   if (fl_get_button (d->bb))
		{
		   fl_set_bitmap_file (d->b[x][y], path ("black.xbm"));
		   s[x][y].color = BLACK;
		   s[x][y].symbol = 0;
		}
	   else if (fl_get_button (d->bw))
		{
		   fl_set_bitmap_file (d->b[x][y], path ("white.xbm"));
		   s[x][y].color = WHITE;
		   s[x][y].symbol = 0;
		}
	}
}

char make_row (int z)
{
   if (z<1 || z>19)
	return (0);
   else if (z<10)
	return (z+96);
   else if (z>=10)
	return (z+97);
}

void save_dia (FL_OBJECT *o, long n)
{
   FILE *f;
   char *str;
   int x,y;
   
   str = fl_show_input ("Save to file:", fl_get_input (b->in));
   if (!str)
	return;
   if ((f = fopen (str, "r"))!=NULL)
	if (! fl_show_question ("Do you want to overwrite this file ?", 1))
	  return; /* check for overwriting previous file */
   fclose (f);
   f = fopen (str, "w");
   
   fprintf (f, "\%\% -------------------xgod-1.1 Go diagram\n");
   fprintf (f, "\\inidiagram %c-%c:%d-%d \n", 
		  make_row (min_y), make_row (max_y), min_x, max_x);
   if (fl_get_button (c->b1))
	fprintf (f, "\\gofontsize{10}\n");
   else if (fl_get_button (c->b2))
	fprintf (f, "\\gofontsize{15}\n");
   else if (fl_get_button (c->b3))
	fprintf (f, "\\gofontsize{20}\n");
   else
	{
	   fl_show_alert ("","Please select a size","",0);
	   return;
	}		 
   for (y=min_y;y<=max_y;y++)
	for (x=min_x;x<=max_x;x++)
	{
	   if (s[x][y].symbol>=500 && s[x][y].symbol<550)
		fprintf (f, "\\pos{%c}{%d}=\\letter{%c}\n", 
			    make_row (y), x, s[x][y].symbol - 403);
	   else if (s[x][y].symbol==BTRI)
		fprintf (f, "\\pos{%c}{%d}=\\black{\\triangle}\n",
			    make_row (y), x);
	   else if (s[x][y].symbol==WTRI)
		fprintf (f, "\\pos{%c}{%d}=\\white{\\triangle}\n",
			    make_row (y), x);
	   else if (s[x][y].symbol==BSQ)
		fprintf (f, "\\pos{%c}{%d}=\\black{\\square}\n",
			    make_row (y), x);
	   else if (s[x][y].symbol==WSQ)
		fprintf (f, "\\pos{%c}{%d}=\\white{\\square}\n",
			    make_row (y), x);
	   else if (s[x][y].color==BLACK)
		{
		   if (s[x][y].symbol==0)
			fprintf (f, "\\pos{%c}{%d}=\\black.\n", make_row (y), x);
		   else 
			fprintf (f, "\\pos{%c}{%d}=\\black{%d}\n", 
				    make_row (y), x, s[x][y].symbol);
		}
	   else if (s[x][y].color==WHITE)
		{
		   if (s[x][y].symbol==0)
			fprintf (f, "\\pos{%c}{%d}=\\white.\n", make_row (y), x);
		   else 
			fprintf (f, "\\pos{%c}{%d}=\\white{%d}\n", 
				    make_row (y), x, s[x][y].symbol);
		}
	}
   if (fl_get_button (c->b4))
	{
	   fprintf (f, "\\begin{flushleft}\n");
	   fprintf (f, "\\begin{tabular}{c}\n");
	   fprintf (f, "\\showdiagram %c-%c:%d-%d \\\\\n", 
		  make_row (min_y), make_row (max_y), min_x, max_x);
	   fprintf (f, "%s\n", caption);
	   fprintf (f, "\\end{tabular}\n");
	   fprintf (f, "\\end{flushleft}\n");
	}
   else if (fl_get_button (c->b5))
	{
	   fprintf (f, "\\begin{center}\n");
	   fprintf (f, "\\begin{tabular}{c}\n");
	   fprintf (f, "\\showdiagram %c-%c:%d-%d \\\\\n", 
		  make_row (min_y), make_row (max_y), min_x, max_x);
	   fprintf (f, "%s\n", caption);
	   fprintf (f, "\\end{tabular}\n");
	   fprintf (f, "\\end{center}\n");
	}
   else if (fl_get_button (c->b6))
	{
	   fprintf (f, "\\begin{flushright}\n");
	   fprintf (f, "\\begin{tabular}{c}\n");
	   fprintf (f, "\\showdiagram %c-%c:%d-%d \\\\\n", 
		  make_row (min_y), make_row (max_y), min_x, max_x);
	   fprintf (f, "%s\n", caption);
	   fprintf (f, "\\end{tabular}\n");
	   fprintf (f, "\\end{flushright}\n");
	}
   else
	{
	   fl_show_alert ("","Please select an alignment","",0);
	   return;
	}
   fprintf (f, "\%\%-------------------end\n");
   fclose (f);
   fl_show_message ("", "File saved succesfully !", "");
}

void clear_dia (FL_OBJECT *o, long n)
{
   int x, y;

   fl_freeze_form (d->dia);
   for (x=min_x;x<=max_x;x++)
	for (y=min_y;y<=max_y;y++)
	{
	   draw_lines (x,y);
	   s[x][y].color = 0;
	   s[x][y].symbol = 0;
	}
   fl_unfreeze_form (d->dia);
}

void get_caption (FL_OBJECT *o, long n)
{
   char *cap;
   cap = fl_show_input ("Diagram caption:", "Dia. ");
   if (cap)
	strcpy (caption, cap);
}

void increase_no (FL_OBJECT *o, long n)
{
   if (fl_get_button (d->bnr))
	fl_set_counter_value (d->cn, fl_get_counter_value (d->cn)+1);
}

void open_marks (FL_OBJECT *o, long n)
{
   fl_show_form (f->marks, FL_PLACE_FREE, FL_TRANSIENT, "More Marks");
}

void close_info (FL_OBJECT *o, long n)
{
   fl_hide_form (e->info);
}

void show_text (FL_OBJECT *o, long n)
{
   if (fl_get_button (e->bl))
	fl_load_browser (e->br1, textpath ("gpl.txt"));
   else if (fl_get_button (e->bx))
	fl_load_browser (e->br1, textpath ("xgod.txt"));
   else if (fl_get_button (e->bg))
	fl_load_browser (e->br1, textpath ("ntf-go.txt"));
   else if (fl_get_button (e->bc))
	fl_load_browser (e->br1, textpath ("copyright.txt"));
}

void close_marks (FL_OBJECT *o, long n)
{
   fl_hide_form (f->marks);
   fl_set_button (d->mb[6], 0);
}

void unmark (FL_OBJECT *o, long n)
{
   int x,y;
   
   for (x=min_x;x<=max_x;x++)
	for (y=min_y;y<=max_y;y++)
	{
	   if (s[x][y].color==0 && s[x][y].symbol!=0)
		{
		   s[x][y].symbol = 0;
		   draw_lines (x, y);
		}
	   else if (s[x][y].color==BLACK)
		{
		   s[x][y].symbol = 0;
		   fl_set_bitmap_file (d->b[x][y], path ("black.xbm"));
		}
	   else if (s[x][y].color==WHITE)
		{
		   s[x][y].symbol = 0;
		   fl_set_bitmap_file (d->b[x][y], path ("white.xbm"));
		}
	}
}

		
