#include <stdio.h>
#include <forms.h>
#include "load_data.h"
#include "main_window.h"
#include "edit_window.h"
#include "message_window.h"


extern FD_main_window *main_window;
extern FD_edit_window *edit_window;
extern FD_message_window *message_window;

extern char field_name_list[][32];

extern BS_data_list data;

FL_OBJECT *regular_fields[23];

int
filename_ok()
{
  char command[250];
  char message[100];
  int irun;

  char filename[200];

  memmove(filename,
	  fl_get_input(edit_window->edit_filename),
	  strlen(fl_get_input(edit_window->edit_filename))+1);

  irun=strlen(filename)-1;
  while(filename[--irun]!= '/' && irun>0);
  filename[irun+1]=0;

  sprintf(command,
	  "echo test > %sbiborg_test.txt && rm %sbiborg_test.txt\n",
	  filename,filename);

  if(system(command)!=0)
    {
      sprintf(message,"Can not write to %s",filename);
      fl_addto_browser(message_window->messages,message);
      fl_set_focus_object(edit_window->edit_window,
			  edit_window->edit_filename);
      return 0;
    }
  else
      return 1; 
}

void
cb_edit_rectype(FL_OBJECT *ob, long button)
{
  int irun;
  FL_COLOR nesc,optc;

  nesc=FL_BLUE;
  optc=FL_DARKCYAN;

  irun=-1;
  while(irun++ < 22)
    {
      fl_set_object_lcol(regular_fields[irun],FL_BLACK);
    }
  
  fl_set_object_lcol(edit_window->edit_note,optc);

  irun=fl_get_choice(edit_window->edit_rectype);
  switch(irun)
    {
    case 1:
      /*article*/
      fl_set_object_lcol(edit_window->edit_author,nesc);
      fl_set_object_lcol(edit_window->edit_title,nesc);
      fl_set_object_lcol(edit_window->edit_journal,nesc);     
      fl_set_object_lcol(edit_window->edit_year,nesc);
      
      fl_set_object_lcol(edit_window->edit_volume,optc);
      fl_set_object_lcol(edit_window->edit_number,optc);
      fl_set_object_lcol(edit_window->edit_pages,optc);
      fl_set_object_lcol(edit_window->edit_month,optc);
      break;
    case 2:
      /* book */
      fl_set_object_lcol(edit_window->edit_author,nesc);
      fl_set_object_lcol(edit_window->edit_title,nesc);
      fl_set_object_lcol(edit_window->edit_publisher,nesc);     
      fl_set_object_lcol(edit_window->edit_year,nesc);
      
      fl_set_object_lcol(edit_window->edit_editor,optc);
      fl_set_object_lcol(edit_window->edit_volume,optc);
      fl_set_object_lcol(edit_window->edit_number,optc);
      fl_set_object_lcol(edit_window->edit_series,optc);
      fl_set_object_lcol(edit_window->edit_address,optc);
      fl_set_object_lcol(edit_window->edit_edition,optc);
      fl_set_object_lcol(edit_window->edit_month,optc);
    break;
    case 3:
      /* booklet */
     fl_set_object_lcol(edit_window->edit_title,nesc);

     fl_set_object_lcol(edit_window->edit_author,optc);
     fl_set_object_lcol(edit_window->edit_howpublished,optc);
     fl_set_object_lcol(edit_window->edit_address,optc);
     fl_set_object_lcol(edit_window->edit_month,optc);
     fl_set_object_lcol(edit_window->edit_year,optc);
    break;
    case 4:
      /* conference */
     fl_set_object_lcol(edit_window->edit_author,nesc);
     fl_set_object_lcol(edit_window->edit_title,nesc);
     fl_set_object_lcol(edit_window->edit_booktitle,nesc);     
     fl_set_object_lcol(edit_window->edit_year,nesc);

     fl_set_object_lcol(edit_window->edit_editor,optc);
     fl_set_object_lcol(edit_window->edit_volume,optc);
     fl_set_object_lcol(edit_window->edit_number,optc);
     fl_set_object_lcol(edit_window->edit_organization,optc);
     fl_set_object_lcol(edit_window->edit_series,optc);
     fl_set_object_lcol(edit_window->edit_pages,optc);
     fl_set_object_lcol(edit_window->edit_publisher,optc);
     fl_set_object_lcol(edit_window->edit_address,optc);
     fl_set_object_lcol(edit_window->edit_month,optc);
    break;
    case 5:
      /* inbook */
      fl_set_object_lcol(edit_window->edit_author,nesc);
      fl_set_object_lcol(edit_window->edit_title,nesc);
      fl_set_object_lcol(edit_window->edit_chapter,nesc);
      fl_set_object_lcol(edit_window->edit_publisher,nesc);
      fl_set_object_lcol(edit_window->edit_type,nesc);     
      fl_set_object_lcol(edit_window->edit_year,nesc);
      
      fl_set_object_lcol(edit_window->edit_pages,nesc);
      fl_set_object_lcol(edit_window->edit_editor,optc);
      fl_set_object_lcol(edit_window->edit_volume,optc);
      fl_set_object_lcol(edit_window->edit_number,optc);
      fl_set_object_lcol(edit_window->edit_series,optc);
      fl_set_object_lcol(edit_window->edit_address,optc);
      fl_set_object_lcol(edit_window->edit_edition,optc);
      fl_set_object_lcol(edit_window->edit_month,optc);
    break;
    case 6:
      /* incollection */
      fl_set_object_lcol(edit_window->edit_author,nesc);
      fl_set_object_lcol(edit_window->edit_title,nesc);
      fl_set_object_lcol(edit_window->edit_booktitle,nesc);
      fl_set_object_lcol(edit_window->edit_publisher,nesc);     
      fl_set_object_lcol(edit_window->edit_year,nesc);
      
      fl_set_object_lcol(edit_window->edit_editor,optc);
      fl_set_object_lcol(edit_window->edit_volume,optc);
      fl_set_object_lcol(edit_window->edit_number,optc);
      fl_set_object_lcol(edit_window->edit_type,optc);
      fl_set_object_lcol(edit_window->edit_series,optc);
      fl_set_object_lcol(edit_window->edit_edition,optc);
      fl_set_object_lcol(edit_window->edit_chapter,optc);
      fl_set_object_lcol(edit_window->edit_pages,nesc);
      fl_set_object_lcol(edit_window->edit_address,optc);
      fl_set_object_lcol(edit_window->edit_month,optc);
      break;
    case 7:
      /* phdthesis */
      fl_set_object_lcol(edit_window->edit_author,nesc);
      fl_set_object_lcol(edit_window->edit_title,nesc);
      fl_set_object_lcol(edit_window->edit_school,nesc);     
      fl_set_object_lcol(edit_window->edit_year,nesc);
      
      fl_set_object_lcol(edit_window->edit_address,optc);
      fl_set_object_lcol(edit_window->edit_month,optc);
      fl_set_object_lcol(edit_window->edit_type,optc);
    break;
    case 8:
      /* inproceedings */
      fl_set_object_lcol(edit_window->edit_author,nesc);
      fl_set_object_lcol(edit_window->edit_title,nesc);
      fl_set_object_lcol(edit_window->edit_booktitle,nesc);     
      fl_set_object_lcol(edit_window->edit_year,nesc);
      
      fl_set_object_lcol(edit_window->edit_editor,optc);
      fl_set_object_lcol(edit_window->edit_volume,optc);
      fl_set_object_lcol(edit_window->edit_number,optc);
      fl_set_object_lcol(edit_window->edit_organization,optc);
      fl_set_object_lcol(edit_window->edit_series,optc);
      fl_set_object_lcol(edit_window->edit_pages,optc);
      fl_set_object_lcol(edit_window->edit_publisher,optc);
      fl_set_object_lcol(edit_window->edit_address,optc);
      fl_set_object_lcol(edit_window->edit_month,optc);
      break;
    case 9:
      /* manual */
      fl_set_object_lcol(edit_window->edit_title,nesc);
      
      fl_set_object_lcol(edit_window->edit_author,optc);
      fl_set_object_lcol(edit_window->edit_organization,optc);
      fl_set_object_lcol(edit_window->edit_address,optc);
      fl_set_object_lcol(edit_window->edit_edition,optc);
      fl_set_object_lcol(edit_window->edit_month,optc);
      fl_set_object_lcol(edit_window->edit_year,optc);
      break;
    case 10:
      /* masterthesis */
      fl_set_object_lcol(edit_window->edit_author,nesc);
      fl_set_object_lcol(edit_window->edit_title,nesc);
      fl_set_object_lcol(edit_window->edit_school,nesc);     
      fl_set_object_lcol(edit_window->edit_year,nesc);
      
      fl_set_object_lcol(edit_window->edit_address,optc);
      fl_set_object_lcol(edit_window->edit_month,optc);
      fl_set_object_lcol(edit_window->edit_type,optc);
    break;
    case 11:
      /* misc */
     fl_set_object_lcol(edit_window->edit_author,nesc);

     fl_set_object_lcol(edit_window->edit_title,optc);
     fl_set_object_lcol(edit_window->edit_howpublished,optc);     
     fl_set_object_lcol(edit_window->edit_month,optc);
     fl_set_object_lcol(edit_window->edit_year,optc);
    break;
    case 12:
      /* phdthesis */
      fl_set_object_lcol(edit_window->edit_author,nesc);
      fl_set_object_lcol(edit_window->edit_title,nesc);
      fl_set_object_lcol(edit_window->edit_school,nesc);     
      fl_set_object_lcol(edit_window->edit_year,nesc);
      
      fl_set_object_lcol(edit_window->edit_address,optc);
      fl_set_object_lcol(edit_window->edit_month,optc);
      fl_set_object_lcol(edit_window->edit_type,optc);
    break;
    case 13:
      /* proceedings */
      fl_set_object_lcol(edit_window->edit_title,nesc);
      fl_set_object_lcol(edit_window->edit_year,nesc);
      
      fl_set_object_lcol(edit_window->edit_editor,optc);
      fl_set_object_lcol(edit_window->edit_publisher,optc);
      fl_set_object_lcol(edit_window->edit_volume,optc);
      fl_set_object_lcol(edit_window->edit_number,optc);
      fl_set_object_lcol(edit_window->edit_organization,optc);
      fl_set_object_lcol(edit_window->edit_series,optc);
      fl_set_object_lcol(edit_window->edit_pages,optc);
      fl_set_object_lcol(edit_window->edit_address,optc);
      fl_set_object_lcol(edit_window->edit_month,optc);
      break;
    case 14:
      /* techreport */
      fl_set_object_lcol(edit_window->edit_author,nesc);
      fl_set_object_lcol(edit_window->edit_title,nesc);
      fl_set_object_lcol(edit_window->edit_institution,nesc);     
      fl_set_object_lcol(edit_window->edit_year,nesc);
      
      fl_set_object_lcol(edit_window->edit_type,optc);
      fl_set_object_lcol(edit_window->edit_number,optc);
      fl_set_object_lcol(edit_window->edit_address,optc);
      fl_set_object_lcol(edit_window->edit_month,optc);
    break;
    case 15:
      /* unpublished */
     fl_set_object_lcol(edit_window->edit_author,nesc);
     fl_set_object_lcol(edit_window->edit_title,nesc);
     fl_set_object_lcol(edit_window->edit_note,nesc);     

     fl_set_object_lcol(edit_window->edit_month,optc);
     fl_set_object_lcol(edit_window->edit_year,optc);
     break;
    }
}

void
set_regular_fields()
{
  int irun;
  irun=-1;
  while(irun++ < 22)
      fl_set_input(regular_fields[irun],data->field_text[irun]);
}

void
set_pointer_regular_fields()
{
  regular_fields[0]=edit_window->edit_address;
  regular_fields[1]=edit_window->edit_annote;
  regular_fields[2]=edit_window->edit_author;
  regular_fields[3]=edit_window->edit_booktitle;
  regular_fields[4]=edit_window->edit_chapter;
  regular_fields[5]=edit_window->edit_edition;
  regular_fields[6]=edit_window->edit_editor;
  regular_fields[7]=edit_window->edit_howpublished;
  regular_fields[8]=edit_window->edit_institution;
  regular_fields[9]=edit_window->edit_journal;
  regular_fields[10]=edit_window->edit_key;
  regular_fields[11]=edit_window->edit_month;
  regular_fields[12]=edit_window->edit_note;
  regular_fields[13]=edit_window->edit_number;
  regular_fields[14]=edit_window->edit_organization;
  regular_fields[15]=edit_window->edit_pages;
  regular_fields[16]=edit_window->edit_publisher;
  regular_fields[17]=edit_window->edit_school;
  regular_fields[18]=edit_window->edit_series;
  regular_fields[19]=edit_window->edit_title;
  regular_fields[20]=edit_window->edit_type;
  regular_fields[21]=edit_window->edit_volume;
  regular_fields[22]=edit_window->edit_year;

}

void
cb_edit_new(FL_OBJECT *ob, long button)
{

  int irun;
  char dummy[20];

  BS_data_list new_entry;
  
  if(filename_ok())
    {
      new_entry = (BS_data_list) malloc(sizeof(BS_dl_entry));
      
      /* Set file name */
      
      new_entry->file_name=(char *)malloc(strlen(data->file_name)+1);
      memmove(new_entry->file_name,
	      data->file_name,
	      strlen(data->file_name)+1);
      
      /* Set entry type */ 
      sprintf(dummy,"ARTICLE");		  
      new_entry->entry_type=(char *)malloc(strlen(dummy)+1);
      memmove(new_entry->entry_type,dummy,strlen(dummy)+1);
      
      /* search and save keyword */
      sprintf(dummy,"newrecord");
      new_entry->keyword=(char *)malloc(strlen(dummy)+1);
      memmove(new_entry->keyword,dummy,strlen(dummy)+1);
      
      /* Set visible */
      new_entry->visible=1;
      
      /* Set fields  */
      /* besetze field_text vor mit 0-Eintragen */
      
      irun=-1;
      while(++irun < MAXFIELDS)
	{
	  new_entry->field_text[irun]=(char *)malloc(1);
	  memmove(new_entry->field_text[irun],"\0",1);
	}
      
      new_entry->next_entry=data->next_entry;
      data->next_entry=new_entry;
      data=new_entry;
      cb_edit_undo(ob,button);
    }
}

void
cb_edit_delete(FL_OBJECT *ob, long button)
{
  int irun,last_selected_record,last_total_record;
  BS_data_list present_entry;

  last_total_record=last_selected_record=0;
  
  present_entry=data;

  /* one entry back */
  while(data->next_entry!=present_entry)
    data=data->next_entry;

  if(data == data->next_entry)
    last_total_record=last_selected_record=1;
  else
    {
      /* search visible entry */
      data->next_entry=present_entry->next_entry;      
      do
	{
	  data=data->next_entry;
	}while(data->visible==0 && 
	       data->next_entry != present_entry->next_entry);
      if(data->visible == 0)
	last_selected_record=1;
    }

  irun=-1;
  while(++irun < MAXFIELDS)
    free(present_entry->field_text[irun]);
  
  free(present_entry->file_name);
  free(present_entry->entry_type);
  free(present_entry->keyword);
  free(present_entry);

  if(last_selected_record)
    {
      /* deleted last record in selected list */

      if(last_total_record)
	{
	  /* deleted last record in total list */
	  fl_set_menu_item_mode(main_window->edit,1,FL_PUP_GREY);
	  fl_set_menu_item_mode(main_window->edit,2,FL_PUP_GREY);
	  fl_set_menu_item_mode(main_window->edit,3,FL_PUP_GREY);
	  fl_set_menu_item_mode(main_window->edit,4,FL_PUP_GREY);
	  fl_set_menu_item_mode(main_window->edit,5,FL_PUP_GREY);
	  data=0;
	  fl_clear_browser(main_window->list);
	}
      else
	{
	  list_data(0);
	  cb_sortbuttons(ob,button);
	}
      fl_hide_form(edit_window->edit_window);
      fl_activate_form(main_window->main_window);
    }
  else
    cb_edit_undo(ob,button);
}

void
cb_edit_copy(FL_OBJECT *ob, long button)
{
  int irun;
  char keyword[500];

  BS_data_list new_entry;

  if(filename_ok())
    {  
      new_entry = (BS_data_list) malloc(sizeof(BS_dl_entry));
      /* Set file name */
      
      new_entry->file_name=(char *)malloc(strlen(data->file_name)+1);
      memmove(new_entry->file_name,
	      data->file_name,
	      strlen(data->file_name)+1);
      
      /* Set entry type */ 		  
      new_entry->entry_type=(char *)malloc(strlen(data->entry_type)+1);
      memmove(new_entry->entry_type,
	      data->entry_type,
	      strlen(data->entry_type)+1);
      
      /* search and save keyword */
      sprintf(keyword,"copy_of%s",data->keyword);
      new_entry->keyword=(char *)malloc(strlen(keyword)+1);
      memmove(new_entry->keyword,
	      keyword,
	      strlen(keyword)+1);
      
      /* Set visible */
      new_entry->visible=1;
      
      /* Set fields  */
      /* besetze field_text vor mit 0-Eintragen */
      
      irun=-1;
      while(++irun < MAXFIELDS)
	{
	  new_entry->field_text[irun]=
	    (char *)malloc(strlen(data->field_text[irun])+1);
	  memmove(new_entry->field_text[irun],
		  data->field_text[irun],
		  strlen(data->field_text[irun])+1);
	}
      
      new_entry->next_entry=data->next_entry;
      data->next_entry=new_entry;
      data=new_entry;
      cb_edit_undo(ob,button);
    }
}

void
cb_edit_other_fields(FL_OBJECT *ob, long button)
{
  int choice,i,j,pos;
  char dummy[5000];

  choice=fl_get_choice(edit_window->edit_other_fields)+23;
  memmove(dummy,data->field_text[choice-1],strlen(data->field_text[choice-1])+1);
  
  i=pos=0;
  j=1;
  while(i <= strlen(dummy))
    {
      while(++i < j*85 && i < strlen(dummy))
	{
	  if(dummy[i]==' ')
	    {

	      if(pos!=0)
		{
		  dummy[pos]=' ';
		}
	      dummy[i]='\n';
	      pos=i;
	    }
	}
      if(i < j*100 && i == strlen(dummy) && pos != 0) 
	dummy[pos]=' ';
      else
	pos=0;
      j++;
    }
  fl_set_input(edit_window->edit_other_fields_input,dummy);
  fl_set_input_topline(edit_window->edit_other_fields_input,1);

}

void
save_record()
{
  FL_OBJECT *ob;
  int irun=-1;
  
  while(irun++ < 22)
    {
      data->field_text[irun]=(char *)
	realloc(data->field_text[irun],
		strlen(fl_get_input(regular_fields[irun]))+1);
      memmove(data->field_text[irun],
	      fl_get_input(regular_fields[irun]),
	      strlen(fl_get_input(regular_fields[irun]))+1);
    }

  data->entry_type=(char *)
    realloc(data->entry_type,
	    strlen(fl_get_choice_text(edit_window->edit_rectype))+1);
  memmove(data->entry_type,
	  fl_get_choice_text(edit_window->edit_rectype),
	  strlen(fl_get_choice_text(edit_window->edit_rectype))+1);
  
  data->keyword=(char *)
    realloc(data->keyword,
	    strlen(fl_get_input(edit_window->edit_keyword))+1);
  memmove(data->keyword,
	  fl_get_input(edit_window->edit_keyword),
	  strlen(fl_get_input(edit_window->edit_keyword))+1);

  data->file_name=(char *)
    realloc(data->file_name,
	    strlen(fl_get_input(edit_window->edit_filename))+1);
  memmove(data->file_name,
	  fl_get_input(edit_window->edit_filename),
	  strlen(fl_get_input(edit_window->edit_filename))+1);
}

void
cb_edit_previous(FL_OBJECT *ob, long button)
{
  int irun;
  int maxrectypes=fl_get_choice_maxitems(edit_window->edit_rectype);

  BS_data_list present_entry;

  if(filename_ok())
    {
      save_record();
      do
	{
	  present_entry=data;
	  while(data->next_entry != present_entry)
	    data=data->next_entry;
	}while(data->visible == 0);
      cb_edit_undo(ob,button);
    }
}
void
cb_edit_next(FL_OBJECT *ob, long button)
{
  int irun;
  int maxrectypes=fl_get_choice_maxitems(edit_window->edit_rectype);

  if(filename_ok())
    {
      save_record();
      do
	{
	  data=data->next_entry;
	}while(data->visible == 0);

      cb_edit_undo(ob,button);
    }
}

void
cb_edit_done(FL_OBJECT *ob, long button)
{
  int num;
  BS_data_list first_entry;
  
  
  if(filename_ok())
    {
      save_record();

      first_entry=data;
      do{
	data=data->next_entry;
      }while(data != first_entry && data->visible==1);
      while(data != first_entry && data->visible==0)
	data=data->next_entry;
      list_data(1);
      fl_hide_form(edit_window->edit_window);
      fl_activate_form(main_window->main_window);
    }
}

void
cb_edit_undo(FL_OBJECT *ob, long button)
{
  int irun;
  int maxrectypes=fl_get_choice_maxitems(edit_window->edit_rectype);

  irun=0;
  while(++irun <= maxrectypes)
    {
      if(strcmp(data->entry_type,
		fl_get_choice_item_text(edit_window->edit_rectype,irun))
	 ==0)
	{
	  fl_set_choice( edit_window->edit_rectype,irun);
	  irun=maxrectypes;
	}
    }
  set_regular_fields();
  cb_edit_other_fields(ob, 0);

  cb_edit_rectype(ob,button);

  fl_set_input(edit_window->edit_filename,data->file_name);
  fl_set_input(edit_window->edit_keyword,data->keyword);
}

void
cb_do_nothing(FL_OBJECT *ob, long button)
{
  /* Does nothing */
}

edit_records(int argc,char *argv[])
{
  int irun;
  FL_OBJECT *ob;

  char rectype[]=ENTRYTYPES;

  fl_deactivate_form(main_window->main_window);

  /***************************************/

  /* prepare regular fields */

  set_pointer_regular_fields();


  /*******************************/


  /* prepare keyword */

  fl_set_input(edit_window->edit_keyword,data->keyword);


  /*******************************/

  /* prepare non regular field names */

  fl_clear_choice(edit_window->edit_other_fields);

  irun=22;
  while(irun++<MAXFIELDS &&
	strlen(&field_name_list[irun][0])!=0)
    fl_addto_choice(edit_window->edit_other_fields,&field_name_list[irun][0]);
  if(irun==23)
    {
      fl_hide_object(edit_window->edit_other_fields);
      fl_hide_object(edit_window->edit_other_fields_input);
    }
  else
    {
      fl_show_object(edit_window->edit_other_fields);
      fl_show_object(edit_window->edit_other_fields_input);
  }

  /*******************************/

  /* Record types */

  fl_clear_choice(edit_window->edit_rectype);
  memmove(rectype,rectype+1,strlen(rectype));
  strcat(rectype,"@");
  while(strstr(rectype,"@") != 0)
    {
      *strstr(rectype,"@")=0;
      fl_addto_choice(edit_window->edit_rectype,&rectype[0]);
      rectype[strlen(rectype)]='@';
      memmove(rectype,strstr(rectype,"@")+1,strlen(rectype));
    }

  /*******************************/

  cb_edit_undo(ob,0);

  fl_activate_form(edit_window->edit_window);

  fl_show_form(edit_window->edit_window,FL_PLACE_MOUSE,FL_FULLBORDER,"BibOrg Edit");

  return;
}







