%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 						TeX Syntax Highlight
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 			Andre Hentz (andre@lcmi.ufsc.br) 		Apr 14, 1995
%
% This file implements syntax highlight for LaTeX files. It is base on
% LaTex  - A Document Preparation System by Leslie Lamport. There's 
% also a internal version of this that is much faster. 
%	Features:	- \Something is a command
%				- $Something$ is a formula
%				- comments: % Something 
%				- punctuation characters
%				- special characters
%				- special character are recognized inside formulas
%	Bugs:		- \( and \) are not recognized as formula delimeters
%				- it gets confused with formulas that don't fit in one line
%				- it gets confused with line pannings (because of $)
%				- iso-latin characters are accepted in commands 
%					( ... to be continued ... )


variable JMAX_COLORS = 10;
variable JNORMAL_COLOR = 1;
variable JCURSOR_COLOR = 2;
variable JSTATUS_COLOR = 3;
variable JREGION_COLOR = 4;
variable JOP_COLOR = 5;
variable JNUM_COLOR = 6;
variable JSTR_COLOR = 7;
variable JCOM_COLOR = 8;
variable JKEY_COLOR = 9;
variable JDELIM_COLOR = 10;
variable TEXDELIM_COLOR = JOP_COLOR;
variable TEXOP_COLOR = JDELIM_COLOR;

variable str_len;
variable index;
variable str;
variable attr;

define is_command_char(ch)
{
	if ( is_one_of("0123456789.:;,?!`'()[]-/*@#$%&~_^\\{} ", ch) )
		0;
	else
		1;			
}

define tex_highlight_command()
{   
	variable ch;

	index++;
	ch = str[index];
	if (is_one_of("#$%&_{}, @!\"'`+-./:;<=>[]\\^|~()", ch))
	{
		attr = strsub(attr, index, JKEY_COLOR);
		index++;
		attr = strsub(attr, index, JKEY_COLOR);
	}
	else
	{
		attr = strsub(attr, index, JKEY_COLOR);
		while( is_command_char(ch) and (index < str_len))
		{  
			index++;
			ch = str[index];
			attr = strsub(attr, index, JKEY_COLOR);		
		}
	}
}
	
define tex_highlight_formula()
{
	variable ch;

	index++;
	attr = strsub(attr, index, JSTR_COLOR);
	while (index < str_len)
	{
		ch = str[index];

		if ( (ch == '$') ) 
		{
			index++;
			attr = strsub(attr, index, JSTR_COLOR);
			break;
		}	
		if ((ch == '\\') and (index < str_len))
	    	tex_highlight_command(str,attr);
		else 
		{
			index++;
			if ( is_one_of("#$%&~_^\\{}", ch) )
	       		attr = strsub(attr, index, TEXOP_COLOR);	
			else if ( is_one_of(".:;,?!`'()[]-/*@", ch) )
				attr = strsub(attr, index, TEXDELIM_COLOR);
			else 
				attr = strsub(attr, index, JSTR_COLOR);
		}		
	}
}

define tex_highlight_comment()
{
	while(index < str_len)
	{
		index++;
		attr = strsub(attr, index, JCOM_COLOR);
	}
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%						TeX Syntax Highlight						%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
define tex_syntax_highlight ()
{
	variable ch;
	variable color;
	
	=attr; =str;
    str_len = strlen(str);
	index = 0;
		
	while (index < str_len) 
    {	
		ch = str[index];
		if (is_one_of(" abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", ch))
			index++;
		else if (ch == '\\') tex_highlight_command();
		else if (ch == '$')  tex_highlight_formula();
		else if (ch == '%')  tex_highlight_comment();
	    else if (is_one_of(".:;,?!`'()[]-/*@", ch)) 
		{
			index++;
			attr = strsub(attr, index, TEXDELIM_COLOR); 
		}			
		else if (is_one_of("#$%&~_^\\{}|<>", ch)) 
		{
			index++;	
			attr = strsub(attr, index, TEXOP_COLOR);
		}	
		else index++;
	 }
	attr;
}
