/* scasc.c	- Smartcard related functions - ASCII things
 *
 * Copyright 1993-1997, Tim Hudson. All rights reserved.
 *
 * You can pretty much do what you like with this code except pretend that 
 * you wrote it provided that any derivative of this code includes the
 * above comments unchanged. If you put this in a product then attribution
 * is mandatory. See the details in the COPYING file.
 *
 * Tim Hudson
 * tjh@cryptsoft.com
 *
 */

#include "platform.h"

#ifdef USE_STDIO
#include <stdio.h>
#endif /* USE_STDIO */

#include <ctype.h>
#include <stdlib.h>
#include <string.h>

#include "sio.h"
#include "sct0.h"
#include "sc.h"

/* sure this stuff is available in other forms on most systems but I
 * don't want to muck around figuring out what hoops to jump through 
 * when it is this easy to code
 */
static unsigned char hexmap[]="0123456789ABCDEF";

static unsigned char to_hex(unsigned char c)
{
  return (hexmap[c & 0x0f]);
}

static unsigned char from_hex(unsigned char c)
{
  if ((c>='0')&&(c<='9'))
    return(c-'0');
  else if ((c>='A')&&(c<='F'))
    return((c-'A')+10);
  else if ((c>='a')&&(c<='f'))
    return((c-'a')+10);
  else
    return(0);
}

unsigned char SC_ByteToHex(unsigned char c)
{
  return to_hex(c);
}

unsigned char SC_HexToByte(unsigned char c)
{
  return from_hex(c);
}


int SC_BufferToHex(char *inbuf,int inlen,char *outbuf,int maxsize,int flags)
{
  int i;
  int olen;
  unsigned char c,o;

  olen=0;
  for (i=0;i<inlen;i++) {
    /* make sure we always have room */
    if ((olen+4)>maxsize) 
      return(-1);
    c=(inbuf[i] & 0xff);
    o=to_hex((unsigned char)(c>>4));
    outbuf[olen++]=o;
    o=to_hex((unsigned char)(c & 0x0f));
    outbuf[olen++]=o;
    if (flags && (i!=(inlen-1)))
      outbuf[olen++]=' ';
  }
  outbuf[olen]='\0';
  return(olen);
}

int SC_HexToBuffer(char *inbuf,char *outbuf,int maxsize)
{
  unsigned char o;
  char c;
  int state=0;	/* 0=data, 1=waiting on second hex char, 2=done */
  int len,olen;
  int inlen;

  inlen=strlen(inbuf);
  len=0;
  olen=0;
  do {
    if (len==inlen)
      break;

    /* get data from the command stream */
    c=(inbuf[len++] & 0xff);

    switch(state) {
      case 0: 
	/* getting first character of two-byte hex data */
        if ((c=='.')||(c=='\n')) 
	  state=2;
        else {
          /* ignore anything not [0-9A-Fa-f] */
          if (isxdigit(c)) {
	    o=from_hex(c);
	    state=1;
          }
	}
        break;
      case 1: 
	/* getting second character of two-byte hex data */
        if (isxdigit(c)) { 
	  o*=16;
          o+=from_hex(c);
          /* copy the data byte */
          if (olen<maxsize) {
            outbuf[olen++]=(o & 0xff);
          } else {
            olen=-2;
            break;
          }
          state=0;
        } else {
          if ((c=='.')||(c=='\n')) 
	    state=2; 
	  else 
	    state=0; 
          /* copy the data byte */
          if (olen<maxsize) {
            outbuf[olen++]=(o & 0xff);
          } else {
            olen=-2;
            break;
          }
        }
        break;
      default:
        break;
    }
  } while (state!=2);

  return(olen);
}

