/* sc_ck.c	- Smartcard related functions 
 *
 * CARD: Chipknip - Intersector Electronic Purse
 *
 * The card is actually a Bull CC60 or CC1000  (CC=CashCard)
 * and is known as:
 *    Proton, ChipKnip, Cash, Quicklink, Cartao Intelligente, etc
 *
 * 9600 8O2 I
 *
 * Copyright 1993-1997, Tim Hudson. All rights reserved.
 *
 * You can pretty much do what you like with this code except pretend that 
 * you wrote it provided that any derivative of this code includes the
 * above comments unchanged. If you put this in a product then attribution
 * is mandatory. See the details in the COPYING file.
 *
 * Tim Hudson
 * tjh@cryptsoft.com
 *
 */

#include "platform.h"

#ifdef USE_STDIO
#include <stdio.h>
#endif /* USE_STDIO */

#include <ctype.h>
#include <stdlib.h>
#include <string.h>

#include "sio.h"
#include "sct0.h"
#include "sc.h"
#include "scint.h"

/*

# if you want to do things the low-level manual way then the 
# following comments should get you started
#
# otherwise look at the ck_ commands (/!ilist to see the list)
#
# ck_investigate
# ck_trans INDEX
# ck_transactions
#

# read the FAB data
/SelectFile ${EF_FAB}
/ReadBinary 0000 08
/!parse EF_FAB
/vars

# grab the current card balance
/LookupBalance

# read the PURSE data (IEP)
/SelectFile ${EF_PURSE}
/ReadBinary 0000 8C
/!parse EF_IEP
/vars

# now start looking at transactions
/SelectFile ${EF_PURSE}
/ReadFirstRecord 24
/!parse RECORD_TRACE
/vars
# then more of the following until all transactions traces
# have been read from the file (10 more?)
/ReadNextRecord 24
/!parse RECORD_TRACE
/vars

*/

SC_CMD_PCONST chipknip_pconst[]={
{ "EF_FAB", "17FF" },
{ "EF_PURSE", "2901" }
};
#define _N_chipknip_pconst (sizeof(chipknip_pconst)/ \
                                    sizeof(chipknip_pconst[0]))
int N_chipknip_pconst=_N_chipknip_pconst;

SC_CMD_PDATA chipknip_pdata[]={
/* patterns for command output */
/* patterns for command args */

/* patterns for file formats */
/* 17FF */
{ "EF_FAB", "${PUR_ICC_ID:8}" },

{ "EF_IEP", "${IEP_HOST_ID:3}${PUR_ID:5}${PUR_CURCY:2}${_RFU1}${CKSF}${PUR_STATE}${PUR_KV_ID}${_RFU2}${_RFU3}${PUR_BAL_MAX:3}${_RFU4}${PUR_DEB_AMT_PIN:3}${_RFU5}${PUR_DEB_AMT_MAX:3}${_RFU6}${PUR_DATE_EXP:3}${_RFU7}${PUR_DATE_ACT:3}${_RFU8}${PUR_DATE_DEACT:3}${CKSM}${PUR_ID_AC_PUB:64}${PUR_ISO2_TRACK:19}${_RFU8}${PUR_SEC_ID:2}${PUR_KEY_ID:2}${PUR_LOCKS}${_RFU9}${PUR_LOCKS_STAN:2}${APP1:4}${APP2:4}" },

{ "RECORD_TRACE", "${PUR_TX_TYPE}${PUR_TX_ERR}${PUR_BAL:3}${CHECKSUM1}${IEP_TX_AMT_TOT:3}${PUR_CURCY:2}${SAM_ID:4}${SAM_STAN:4}${CHECKSUM2}${PUR_STAN:2}${CHECKSUM3}${GEN_CHECKSUM}${PUR_SAM_GEN_TOT:3}${PUR_TX_LOG_DATE_TIME:2}${_RFU:7}" },

{ "BALANCE", "${PUR_BAL:3}${PUR_CURCY:2}" }

};
#define _N_chipknip_pdata (sizeof(chipknip_pdata)/ \
                                    sizeof(chipknip_pdata[0]))
int N_chipknip_pdata=_N_chipknip_pdata;

SC_CMD_ENT chipknip_cmds[]={
  /* SELECT_EF */
  { 
    "SelectFile", SC_DIR_IN, 0xbc, 0xa4, 
                        NULL, "00", "00", NULL, "${FileID:2}",
			NULL, NULL, NULL,
  },

  /* READ_DATA */
  { "ReadBinary", SC_DIR_OUT, 0xbc, 0xb0, 
                        "${Offset}", NULL, NULL, "${Len}", NULL,
			NULL, NULL, NULL,
  },

  /* READ_RECORD */
  { "ReadRecord", SC_DIR_OUT, 0xe1, 0xb6, 
                        NULL, "${RecordNumber}", "${ReferenceControl}", 
			"${Len}" , NULL,
			NULL, NULL, NULL,
  },

  /* LOOK_UP_BALANCE */
  { "LookupBalance", SC_DIR_OUT, 0xe1, 0xb4,
                        NULL, "00", "01", "05", NULL,
			NULL, NULL, NULL,
			{ 
			{ 5, "balance" }
			}
  },


/* Handy variations on the above commands */

  { "ReadFirstRecord", SC_DIR_OUT, 0xe1, 0xb6, 
                        NULL, "00", "01", 
			"${Len}"
  },

  { "ReadPrevRecord", SC_DIR_OUT, 0xe1, 0xb6, 
                        NULL, "00", "02", 
			"${Len}"
  },

  { "ReadNextRecord", SC_DIR_OUT, 0xe1, 0xb6, 
                        NULL, "00", "03", 
			"${Len}"
  },

};

#define _N_chipknip_cmds (sizeof(chipknip_cmds)/sizeof(chipknip_cmds[0]))
int N_chipknip_cmds=_N_chipknip_cmds;

/* the following table is not right ... and needs some work! */
SC_CMD_ERR_CVT chipknip_errs[]={
{ 0x60,   -1, SC_RSP_OK },
{ 0x61,   -1, SC_RSP_OK },
{ 0x67,   -1, SC_RSP_BADLEN },
{ 0x69, 0x82, SC_RSP_DENIED },
{ 0x6a, 0x82, SC_RSP_NOTFOUND },
{ 0x9f, 0x08, SC_RSP_NOTFOUND },    /* a guess */
{ 0x9f, 0x00, SC_RSP_OK }           /* not sure about this! */
};

#define _N_chipknip_errs (sizeof(chipknip_errs)/sizeof(chipknip_errs[0]))
int N_chipknip_errs=_N_chipknip_errs;

/* ------------------------------------------------------------------------- */

#if 0
/* this is old stuff ... ck_investigate now uses the other commands
 * that provide stuff rather than doing things the "hard" way itself
 */
static char *cmds_investigate[]={
"SelectFile ${EF_FAB}",
"ReadBinary 0000 08",
"!parse EF_FAB",
"!echo PUR_ICC_ID = ${PUR_ICC_ID}",
"LookupBalance",
"!echo PUR_BAL = ${PUR_BAL} PUR_CURCY = ${PUR_CURCY}",
"!clear",
NULL
};

static int ck_investigate(SC_STATE *sc,void *pinternalv,char *args,char *uout)
{
  char rspbuf[SC_MAX_HEX_DATA_LEN];

  uout[0]='\0';

  if (sc->slog)
    SLOG_printf(sc->sout,"ck_investigate called\n");

  if (SC_ExecuteCommands(sc,cmds_investigate,rspbuf,1)!=1)
    goto bad;

  if (sc->slog)
    SLOG_printf(sc->slog,"ck_investigate success\n");
  return(1);

bad: ;
  if (sc->slog)
    SLOG_printf(sc->slog,"ck_investigate failed\n");
  sprintf(uout,"ck_investigate: failed");

  return(0);
}
#endif

static int ck_balance(SC_STATE *sc,void *pinternalv,char *args,char *uout)
{
  char rspbuf[SC_MAX_HEX_DATA_LEN];
  char *p1,*p2;

  uout[0]='\0';
  SC_ExecuteCommand(sc,"LookupBalance",rspbuf,1);
  if (sc->last_rsp.rsp_code==SC_RSP_OK)  {
    p1=SC_GetVar(sc,"PUR_BAL");
    p2=SC_GetVar(sc,"PUR_CURCY");
    if ((p1!=NULL)&&(p2!=NULL))
      sprintf(uout,"%s %s",p1,p2);
  }
  return(1);
}

static char *cmds_id[]={
"SelectFile ${EF_FAB}", "ReadBinary 0000 08", "!parse EF_FAB", NULL
};

static int ck_id(SC_STATE *sc,void *pinternalv,char *args,char *uout)
{
  char rspbuf[SC_MAX_HEX_DATA_LEN];
  char *p1;

  uout[0]='\0';
  if (SC_ExecuteCommands(sc,cmds_id,rspbuf,1)==1) {
    p1=SC_GetVar(sc,"PUR_ICC_ID");
    if (p1!=NULL)
      strcpy(uout,p1);
  }
  return(1);

}

static int ck_purse(SC_STATE *sc,void *pinternalv,char *args,char *uout)
{
  char rspbuf[SC_MAX_HEX_DATA_LEN];

  uout[0]='\0';
  SC_ExecuteCommand(sc,"SelectFile ${EF_PURSE}",rspbuf,1);
  if (sc->last_rsp.rsp_code!=SC_RSP_OK)  {
    sprintf(uout,"ck_purse: EF_PURSE not found");
    goto bad;
  }
  SC_ExecuteCommand(sc,"ReadBinary 0000 8C",rspbuf,1);
  if (sc->last_rsp.rsp_code!=SC_RSP_OK)  {
    sprintf(uout,"ck_purse: unable to read EF_PURSE");
    goto bad;
  }
  SC_ExecuteCommand(sc,"!parse EF_IEP",rspbuf,1);

  return(1);
bad: ;
  SC_ClearVars(sc);
  return(0);
}

static char *cmds_trans_first[]={
"SelectFile ${EF_PURSE}", "ReadFirstRecord 24", "!parse RECORD_TRACE", NULL
};

static char *cmds_trans_next[]={
"ReadNextRecord 24", "!parse RECORD_TRACE", NULL
};

/*
{ "RECORD_TRACE", "${PUR_TX_TYPE}${PUR_TX_ERR}${PUR_BAL:3}${CHECKSUM1}${IEP_TX_AMT_TOT:3}${PUR_CURCY:2}${SAM_ID:4}${SAM_STAN:4}${CHECKSUM2}${PUR_STAN:2}${CHECKSUM3}${GEN_CHECKSUM}${PUR_SAM_GEN_TOT:3}${PUR_TX_LOG_DATE_TIME:2}${_RFU:7}" },
*/

/* ck_trans - select the specified transaction record ... */
static int ck_trans(SC_STATE *sc,void *pinternalv,char *args,char *uout)
{
  char rspbuf[SC_MAX_HEX_DATA_LEN];
  char *p;
  int i;
  int id;

  uout[0]='\0';
  /* args contains the transaction id ... 1 to 11 that is wanted */
  p=args;
  while (isspace(*p))
    p++;
  id=atoi(p);
  if ((id<=0) || (id>11)) {
    sprintf(uout,"INVALID transaction id (1-11 required)");
    goto bad;
  }

  if (SC_ExecuteCommands(sc,cmds_trans_first,rspbuf,1)==1) {
    if (id==1)
      goto done;
  }
  for(i=0;i<10;i++) {
    if (SC_ExecuteCommands(sc,cmds_trans_next,rspbuf,1)==1) {
      if (i==(id-2))
	goto done;
    }
  }
done: ;
  return(1);

bad: ;
  SC_ClearVars(sc);
  return(0);
}

static char *cmd_trans_details="!echo PUR_TX_TYPE ${PUR_TX_TYPE} IEP_TX_AMT_TOT ${IEP_TX_AMT_TOT} PUR_BAL ${PUR_BAL} SAM_ID ${SAM_ID}";

static int ck_transactions(SC_STATE *sc,void *pinternalv,char *args,char *uout)
{
  char rspbuf[SC_MAX_HEX_DATA_LEN];
  int i;

  uout[0]='\0';
  if (SC_ExecuteCommands(sc,cmds_trans_first,rspbuf,1)==1) {
    SC_ExecuteCommand(sc,cmd_trans_details,rspbuf,1);
  } else {
    goto bad;
  }
  for(i=0;i<10;i++) {
    if (SC_ExecuteCommands(sc,cmds_trans_next,rspbuf,1)==1) {
      SC_ExecuteCommand(sc,cmd_trans_details,rspbuf,1);
    } else {
      goto bad;
    }
  }
  /* we are only returning a list so blow away details of 
   * the last item ... as it isn't useful by itself
   */
  SC_ClearVars(sc);
  return(1);

bad: ;
  SC_ClearVars(sc);
  return(0);
}

static char *cmds_investigate[]={
"ck_id", "!echo PUR_ICC_ID ${PUR_ICC_ID}",
"ck_balance", "!echo PUR_BAL ${PUR_BAL} PUR_CURCY ${PUR_CURCY}",
"ck_transactions", 
/* ck_purse needs to have only useful summary information extracted
 * for the investigate command ... the current dumping of all the
 * information is rather more than a quick poke at a card should
 * return for summary stuff
 */
"ck_purse", "vars",
NULL
};

static int ck_investigate(SC_STATE *sc,void *pinternalv,char *args,char *uout)
{
  char rspbuf[SC_MAX_HEX_DATA_LEN];

  uout[0]='\0';
  if (SC_ExecuteCommands(sc,cmds_investigate,rspbuf,1)==1) {
    return(1);
  } else {
    return(0);
  }
}

/* ------------------------------------------------------------------------- */

SC_CMD_INTERNAL chipknip_icmds[]={
{ "ck_investigate", NULL, ck_investigate },
{ "ck_id", NULL, ck_id },
{ "ck_balance", NULL, ck_balance },
{ "ck_purse", NULL, ck_purse },
{ "ck_trans", NULL, ck_trans },
{ "ck_transactions", NULL, ck_transactions }
};
#define _N_chipknip_icmds (sizeof(chipknip_icmds)/sizeof(chipknip_icmds[0]))
int N_chipknip_icmds=_N_chipknip_icmds;

SC_CMD_TABLE chipknip_cmd_table=
{ 
SC_CARD_CRYPTOFLEX, "chipknip", 
	chipknip_cmds, &N_chipknip_cmds,
	chipknip_icmds, &N_chipknip_icmds,
        chipknip_errs, &N_chipknip_errs,
	chipknip_pdata, &N_chipknip_pdata
};

