/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.object;

import com.oracle.truffle.api.object.ImmutableMap;
import com.oracle.truffle.api.object.StrongKeyWeakValueEntry;
import com.oracle.truffle.api.object.TransitionMap;
import com.oracle.truffle.api.object.UnorderedTrieMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

final class TrieTransitionMap<K, V>
extends TransitionMap<K, V>
implements BiFunction<Object, V, Map.Entry<Object, V>> {
    private volatile UnorderedTrieMap<Object, V> map = UnorderedTrieMap.empty();
    private static final AtomicReferenceFieldUpdater<TrieTransitionMap, UnorderedTrieMap> MAP_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TrieTransitionMap.class, UnorderedTrieMap.class, "map");

    TrieTransitionMap() {
    }

    @Override
    public V get(Object key) {
        return this.getValue(this.map.getEntry(key));
    }

    @Override
    protected V putAnyKey(Object key, V value) {
        UnorderedTrieMap<Object, V> oldMap;
        UnorderedTrieMap<Object, V> newMap;
        this.expungeStaleEntries();
        V prevValue = this.getValue(this.map.getEntry(key));
        while ((newMap = (oldMap = this.map).copyAndPut(key, value, this)) != oldMap && !MAP_UPDATER.compareAndSet(this, oldMap, newMap)) {
        }
        return prevValue;
    }

    @Override
    protected V putAnyKeyIfAbsent(Object key, V value) {
        UnorderedTrieMap<Object, V> newMap;
        UnorderedTrieMap<Object, V> oldMap;
        this.expungeStaleEntries();
        do {
            if ((newMap = (oldMap = this.map).copyAndPutIfAbsent(key, value, this)) != oldMap) continue;
            return this.getValue(oldMap.getEntry(key));
        } while (!MAP_UPDATER.compareAndSet(this, oldMap, newMap));
        return null;
    }

    @Override
    public V remove(Object key) {
        UnorderedTrieMap<Object, V> oldMap;
        ImmutableMap newMap;
        this.expungeStaleEntries();
        V prevValue = this.getValue(this.map.getEntry(key));
        while ((newMap = (oldMap = this.map).copyAndRemove(key)) != oldMap && !MAP_UPDATER.compareAndSet(this, oldMap, (UnorderedTrieMap)newMap)) {
        }
        return prevValue;
    }

    @Override
    protected void expungeStaleEntry(StrongKeyWeakValueEntry<Object, V> entry) {
        UnorderedTrieMap<Object, V> oldMap;
        UnorderedTrieMap<Object, V> newMap;
        while ((newMap = (oldMap = this.map).copyAndRemoveEntry(entry)) != oldMap && !MAP_UPDATER.compareAndSet(this, oldMap, newMap)) {
        }
    }

    @Override
    public void forEach(final BiConsumer<? super K, ? super V> consumer) {
        this.expungeStaleEntries();
        this.map.forEachEntry(new Consumer<Map.Entry<Object, V>>(){
            final /* synthetic */ TrieTransitionMap this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(Map.Entry<Object, V> entry) {
                Object key;
                Object value = entry.getValue();
                if (value != null && (key = this.this$0.unwrapKey(entry.getKey())) != null) {
                    consumer.accept(key, value);
                }
            }
        });
    }

    @Override
    public Map.Entry<Object, V> apply(Object k, V v) {
        return new StrongKeyWeakValueEntry<Object, V>(k, v, this.queue);
    }
}

