/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesPreprocess;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.ExternallyRenamedChange;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.versionBrowser.VcsRevisionNumberAware;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ConstantFunction;
import com.intellij.util.NotNullFunction;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryPath;
import org.jetbrains.idea.svn.history.SvnLazyPropertyContentRevision;
import org.jetbrains.idea.svn.history.SvnRepositoryContentRevision;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.info.Info;

public class SvnChangeList
implements CommittedChangeList,
VcsRevisionNumberAware {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.history");
    private final SvnVcs myVcs;
    private final SvnRepositoryLocation myLocation;
    private String myRepositoryRoot;
    private long myRevision;
    private VcsRevisionNumber myRevisionNumber;
    private String myAuthor;
    private Date myDate;
    private String myMessage;
    private final Set<String> myChangedPaths;
    private final Set<String> myAddedPaths;
    private final Set<String> myDeletedPaths;
    private final Set<String> myReplacedPaths;
    private ChangesListCreationHelper myListsHolder;
    private Url myBranchUrl;
    private boolean myCachedInfoLoaded;
    private final TreeMap<String, String> myCopiedAddedPaths;
    private RootUrlInfo myWcRoot;
    private final CommonPathSearcher myCommonPathSearcher;
    private final Set<String> myKnownAsDirectories;

    public SvnChangeList(@NotNull List<? extends CommittedChangeList> lists, @NotNull SvnRepositoryLocation location) {
        if (lists == null) {
            SvnChangeList.$$$reportNull$$$0(0);
        }
        if (location == null) {
            SvnChangeList.$$$reportNull$$$0(1);
        }
        this.myChangedPaths = new HashSet<String>();
        this.myAddedPaths = new HashSet<String>();
        this.myDeletedPaths = new HashSet<String>();
        this.myReplacedPaths = new HashSet<String>();
        this.myCopiedAddedPaths = new TreeMap();
        SvnChangeList sample = (SvnChangeList)lists.get(0);
        this.myVcs = sample.myVcs;
        this.myLocation = location;
        this.setRevision(sample.myRevision);
        this.myAuthor = sample.myAuthor;
        this.myDate = sample.myDate;
        this.myMessage = sample.myMessage;
        this.myRepositoryRoot = sample.myRepositoryRoot;
        this.myCommonPathSearcher = new CommonPathSearcher();
        for (CommittedChangeList committedChangeList : lists) {
            SvnChangeList svnList = (SvnChangeList)committedChangeList;
            this.myChangedPaths.addAll(svnList.myChangedPaths);
            this.myAddedPaths.addAll(svnList.myAddedPaths);
            this.myDeletedPaths.addAll(svnList.myDeletedPaths);
            this.myReplacedPaths.addAll(svnList.myReplacedPaths);
        }
        this.myKnownAsDirectories = new HashSet<String>(0);
    }

    public SvnChangeList(@NotNull SvnVcs vcs, @NotNull SvnRepositoryLocation location, @NotNull LogEntry logEntry, @NotNull Url repositoryRoot) {
        if (vcs == null) {
            SvnChangeList.$$$reportNull$$$0(2);
        }
        if (location == null) {
            SvnChangeList.$$$reportNull$$$0(3);
        }
        if (logEntry == null) {
            SvnChangeList.$$$reportNull$$$0(4);
        }
        if (repositoryRoot == null) {
            SvnChangeList.$$$reportNull$$$0(5);
        }
        this.myChangedPaths = new HashSet<String>();
        this.myAddedPaths = new HashSet<String>();
        this.myDeletedPaths = new HashSet<String>();
        this.myReplacedPaths = new HashSet<String>();
        this.myCopiedAddedPaths = new TreeMap();
        this.myVcs = vcs;
        this.myLocation = location;
        this.setRevision(logEntry.getRevision());
        this.myAuthor = StringUtil.notNullize((String)logEntry.getAuthor());
        this.myDate = logEntry.getDate();
        this.myMessage = StringUtil.notNullize((String)logEntry.getMessage());
        this.myRepositoryRoot = UriUtil.trimTrailingSlashes((String)repositoryRoot.toDecodedString());
        this.myCommonPathSearcher = new CommonPathSearcher();
        this.myKnownAsDirectories = new HashSet<String>(0);
        for (LogEntryPath entry : logEntry.getChangedPaths().values()) {
            String path = entry.getPath();
            if (entry.isDirectory()) {
                this.myKnownAsDirectories.add(path);
            }
            this.myCommonPathSearcher.next(path);
            if (entry.getType() == 'A') {
                if (entry.getCopyPath() != null) {
                    this.myCopiedAddedPaths.put(path, entry.getCopyPath());
                }
                this.myAddedPaths.add(path);
                continue;
            }
            if (entry.getType() == 'D') {
                this.myDeletedPaths.add(path);
                continue;
            }
            if (entry.getType() == 'R') {
                this.myReplacedPaths.add(path);
            }
            this.myChangedPaths.add(path);
        }
    }

    public SvnChangeList(SvnVcs vcs, @NotNull SvnRepositoryLocation location, @NotNull DataInput stream, boolean supportsCopyFromInfo, boolean supportsReplaced) throws IOException {
        if (location == null) {
            SvnChangeList.$$$reportNull$$$0(6);
        }
        if (stream == null) {
            SvnChangeList.$$$reportNull$$$0(7);
        }
        this.myChangedPaths = new HashSet<String>();
        this.myAddedPaths = new HashSet<String>();
        this.myDeletedPaths = new HashSet<String>();
        this.myReplacedPaths = new HashSet<String>();
        this.myCopiedAddedPaths = new TreeMap();
        this.myVcs = vcs;
        this.myLocation = location;
        this.myKnownAsDirectories = new HashSet<String>();
        this.readFromStream(stream, supportsCopyFromInfo, supportsReplaced);
        this.myCommonPathSearcher = new CommonPathSearcher();
        this.myCommonPathSearcher.next(this.myAddedPaths);
        this.myCommonPathSearcher.next(this.myDeletedPaths);
        this.myCommonPathSearcher.next(this.myChangedPaths);
    }

    public Change getByPath(String path) {
        if (this.myListsHolder == null) {
            this.createLists();
        }
        return this.myListsHolder.getByPath(path);
    }

    public String getCommitterName() {
        return this.myAuthor;
    }

    @Nullable
    public Date getCommitDate() {
        return this.myDate;
    }

    @Nullable
    public VcsRevisionNumber getRevisionNumber() {
        return this.myRevisionNumber;
    }

    private void setRevision(long revision) {
        this.myRevision = revision;
        this.myRevisionNumber = new SvnRevisionNumber(Revision.of(revision));
    }

    public Collection<Change> getChanges() {
        if (this.myListsHolder == null) {
            this.createLists();
        }
        return this.myListsHolder.getList();
    }

    private void createLists() {
        this.myListsHolder = new ChangesListCreationHelper();
        HashMap<String, ExternallyRenamedChange> copiedAddedChanges = new HashMap<String, ExternallyRenamedChange>();
        this.correctBeforePaths();
        ArrayList<String> copyDeleted = new ArrayList<String>(this.myDeletedPaths);
        for (String path : this.myAddedPaths) {
            Change addedChange;
            if (this.myCopiedAddedPaths.containsKey(path)) {
                String copyTarget = this.myCopiedAddedPaths.get(path);
                if (copyDeleted.contains(copyTarget)) {
                    addedChange = new ExternallyRenamedChange((ContentRevision)this.myListsHolder.createRevisionLazily(copyTarget, true), (ContentRevision)this.myListsHolder.createRevisionLazily(path, false), copyTarget);
                    addedChange.getMoveRelativePath(this.myVcs.getProject());
                    ((ExternallyRenamedChange)addedChange).setCopied(false);
                    copyDeleted.remove(copyTarget);
                } else {
                    addedChange = new ExternallyRenamedChange(null, (ContentRevision)this.myListsHolder.createRevisionLazily(path, false), copyTarget);
                }
                copiedAddedChanges.put(copyTarget, (ExternallyRenamedChange)addedChange);
            } else {
                addedChange = new Change(null, (ContentRevision)this.myListsHolder.createRevisionLazily(path, false));
            }
            this.myListsHolder.add(path, addedChange);
        }
        for (String path : copyDeleted) {
            Change deletedChange;
            if (copiedAddedChanges.containsKey(path)) {
                ExternallyRenamedChange addedChange = (ExternallyRenamedChange)copiedAddedChanges.get(path);
                FilePath source = addedChange.getAfterRevision().getFile();
                deletedChange = new ExternallyRenamedChange((ContentRevision)this.myListsHolder.createDeletedItemRevision(path, true), null, path);
                ((ExternallyRenamedChange)deletedChange).setCopied(false);
                ((ExternallyRenamedChange)deletedChange).setRenamedOrMovedTarget(source);
            } else {
                deletedChange = new Change((ContentRevision)this.myListsHolder.createDeletedItemRevision(path, true), null);
            }
            this.myListsHolder.add(path, deletedChange);
        }
        for (String path : this.myChangedPaths) {
            boolean moveAndChange = false;
            boolean replaced = this.myReplacedPaths.contains(path);
            for (String addedPath : this.myAddedPaths) {
                String copyFromPath = this.myCopiedAddedPaths.get(addedPath);
                if (copyFromPath == null || !Url.isAncestor(addedPath, path)) continue;
                if (addedPath.length() < path.length()) {
                    String relative = Url.getRelative(addedPath, path);
                    copyFromPath = Url.append(copyFromPath, relative);
                }
                ExternallyRenamedChange renamedChange = new ExternallyRenamedChange((ContentRevision)this.myListsHolder.createRevisionLazily(copyFromPath, true), (ContentRevision)this.myListsHolder.createRevisionLazily(path, false), copyFromPath);
                moveAndChange = true;
                renamedChange.getMoveRelativePath(this.myVcs.getProject());
                renamedChange.setIsReplaced(replaced);
                ExternallyRenamedChange addedChange = (ExternallyRenamedChange)copiedAddedChanges.get(this.myCopiedAddedPaths.get(addedPath));
                renamedChange.setCopied(addedChange != null && addedChange.isCopied());
                this.myListsHolder.add(path, (Change)renamedChange);
                break;
            }
            if (moveAndChange) continue;
            ExternallyRenamedChange renamedChange = new ExternallyRenamedChange((ContentRevision)this.myListsHolder.createRevisionLazily(path, true), (ContentRevision)this.myListsHolder.createRevisionLazily(path, false), null);
            renamedChange.setIsReplaced(replaced);
            renamedChange.setCopied(false);
            this.myListsHolder.add(path, (Change)renamedChange);
        }
    }

    private void correctBeforePaths() {
        this.processDeletedForBeforePaths(this.myDeletedPaths);
        this.processModifiedForBeforePaths(this.myChangedPaths);
        this.processModifiedForBeforePaths(this.myReplacedPaths);
    }

    private void processModifiedForBeforePaths(Set<String> paths) {
        RenameHelper helper = new RenameHelper();
        for (String s : paths) {
            String converted;
            if (s.equals(converted = helper.convertBeforePath(s, this.myCopiedAddedPaths))) continue;
            this.myCopiedAddedPaths.put(s, converted);
        }
    }

    private void processDeletedForBeforePaths(Set<String> paths) {
        RenameHelper helper = new RenameHelper();
        HashSet<String> copy = new HashSet<String>(paths);
        paths.clear();
        for (String s : copy) {
            paths.add(helper.convertBeforePath(s, this.myCopiedAddedPaths));
        }
    }

    @Nullable
    private FilePath getLocalPath(@NotNull String path, NotNullFunction<File, Boolean> detector) {
        if (path == null) {
            SvnChangeList.$$$reportNull$$$0(8);
        }
        if (this.myVcs.getProject().isDefault()) {
            return null;
        }
        Url absoluteUrl = SvnUtil.parseUrl(this.myRepositoryRoot + path, false);
        RootUrlInfo rootForUrl = this.myVcs.getSvnFileUrlMapping().getWcRootForUrl(absoluteUrl);
        FilePath result = null;
        if (rootForUrl != null) {
            String relativePath = SvnUtil.getRelativeUrl(rootForUrl.getUrl(), absoluteUrl);
            File file = new File(rootForUrl.getPath(), relativePath);
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            result = virtualFile != null ? VcsUtil.getFilePath((VirtualFile)virtualFile) : VcsUtil.getFilePath((File)file, (boolean)((Boolean)detector.fun((Object)file)));
        }
        return result;
    }

    private long getRevision(boolean isBeforeRevision) {
        return isBeforeRevision ? this.myRevision - 1L : this.myRevision;
    }

    public SvnRepositoryLocation getLocation() {
        return this.myLocation;
    }

    private void patchChange(Change change, String path) {
        Url wasUrl;
        Url becameUrl;
        try {
            String originUrl;
            wasUrl = becameUrl = SvnUtil.createUrl(Url.append(this.myRepositoryRoot, path), false);
            if (change instanceof ExternallyRenamedChange && change.getBeforeRevision() != null && (originUrl = ((ExternallyRenamedChange)change).getOriginUrl()) != null) {
                wasUrl = SvnUtil.createUrl(Url.append(this.myRepositoryRoot, originUrl), false);
            }
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
            return;
        }
        FilePath filePath = ChangesUtil.getFilePath((Change)change);
        Change additional = new Change((ContentRevision)this.createPropertyRevision(filePath, change.getBeforeRevision(), wasUrl), (ContentRevision)this.createPropertyRevision(filePath, change.getAfterRevision(), becameUrl));
        change.addAdditionalLayerElement("Property", additional);
    }

    @Nullable
    private SvnLazyPropertyContentRevision createPropertyRevision(@NotNull FilePath filePath, @Nullable ContentRevision revision, @NotNull Url url) {
        if (filePath == null) {
            SvnChangeList.$$$reportNull$$$0(9);
        }
        if (url == null) {
            SvnChangeList.$$$reportNull$$$0(10);
        }
        if (revision == null) {
            return null;
        }
        SvnRevisionNumber number = (SvnRevisionNumber)revision.getRevisionNumber();
        Target target = Target.on(url, number.getRevision());
        return new SvnLazyPropertyContentRevision(this.myVcs, filePath, number, target);
    }

    @NotNull
    public String getName() {
        String string = this.myMessage;
        if (string == null) {
            SvnChangeList.$$$reportNull$$$0(11);
        }
        return string;
    }

    public String getComment() {
        return this.myMessage;
    }

    public long getNumber() {
        return this.myRevision;
    }

    public String getBranch() {
        return null;
    }

    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    public Collection<Change> getChangesWithMovedTrees() {
        if (this.myListsHolder == null) {
            this.createLists();
        }
        return this.myListsHolder.getDetailedList();
    }

    public boolean isModifiable() {
        return true;
    }

    public void setDescription(String newMessage) {
        this.myMessage = newMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SvnChangeList that = (SvnChangeList)o;
        if (this.myRevision != that.myRevision) {
            return false;
        }
        if (this.myAuthor != null ? !this.myAuthor.equals(that.myAuthor) : that.myAuthor != null) {
            return false;
        }
        if (this.myDate != null ? !this.myDate.equals(that.myDate) : that.myDate != null) {
            return false;
        }
        return !(this.myMessage != null ? !this.myMessage.equals(that.myMessage) : that.myMessage != null);
    }

    public int hashCode() {
        int result = Long.hashCode(this.myRevision);
        result = 31 * result + (this.myAuthor != null ? this.myAuthor.hashCode() : 0);
        result = 31 * result + (this.myDate != null ? this.myDate.hashCode() : 0);
        result = 31 * result + (this.myMessage != null ? this.myMessage.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.myMessage;
    }

    public void writeToStream(@NotNull DataOutput stream) throws IOException {
        if (stream == null) {
            SvnChangeList.$$$reportNull$$$0(12);
        }
        stream.writeUTF(this.myRepositoryRoot);
        stream.writeLong(this.myRevision);
        stream.writeUTF(this.myAuthor);
        stream.writeLong(this.myDate.getTime());
        SvnChangeList.writeUTFTruncated(stream, this.myMessage);
        SvnChangeList.writeFiles(stream, this.myChangedPaths);
        SvnChangeList.writeFiles(stream, this.myAddedPaths);
        SvnChangeList.writeFiles(stream, this.myDeletedPaths);
        SvnChangeList.writeMap(stream, this.myCopiedAddedPaths);
        SvnChangeList.writeFiles(stream, this.myReplacedPaths);
        stream.writeInt(this.myKnownAsDirectories.size());
        for (String directory : this.myKnownAsDirectories) {
            stream.writeUTF(directory);
        }
    }

    public static void writeUTFTruncated(DataOutput stream, String text) throws IOException {
        if (text.length() > 16383) {
            stream.writeUTF(text.substring(0, 16383));
        } else {
            stream.writeUTF(text);
        }
    }

    private static void writeFiles(DataOutput stream, Set<String> paths) throws IOException {
        stream.writeInt(paths.size());
        for (String s : paths) {
            stream.writeUTF(s);
        }
    }

    private void readFromStream(@NotNull DataInput stream, boolean supportsCopyFromInfo, boolean supportsReplaced) throws IOException {
        if (stream == null) {
            SvnChangeList.$$$reportNull$$$0(13);
        }
        this.myRepositoryRoot = stream.readUTF();
        this.setRevision(stream.readLong());
        this.myAuthor = stream.readUTF();
        this.myDate = new Date(stream.readLong());
        this.myMessage = stream.readUTF();
        SvnChangeList.readFiles(stream, this.myChangedPaths);
        SvnChangeList.readFiles(stream, this.myAddedPaths);
        SvnChangeList.readFiles(stream, this.myDeletedPaths);
        if (supportsCopyFromInfo) {
            SvnChangeList.readMap(stream, this.myCopiedAddedPaths);
        }
        if (supportsReplaced) {
            SvnChangeList.readFiles(stream, this.myReplacedPaths);
        }
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            this.myKnownAsDirectories.add(stream.readUTF());
        }
    }

    private static void writeMap(DataOutput stream, Map<String, String> map) throws IOException {
        stream.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stream.writeUTF(entry.getKey());
            stream.writeUTF(entry.getValue());
        }
    }

    private static void readMap(DataInput stream, Map<String, String> map) throws IOException {
        int count = stream.readInt();
        for (int i = 0; i < count; ++i) {
            map.put(stream.readUTF(), stream.readUTF());
        }
    }

    private static void readFiles(DataInput stream, Set<String> paths) throws IOException {
        int count = stream.readInt();
        for (int i = 0; i < count; ++i) {
            paths.add(stream.readUTF());
        }
    }

    public Url getBranchUrl() {
        this.ensureCacheUpdated();
        return this.myBranchUrl;
    }

    @Nullable
    public VirtualFile getVcsRoot() {
        this.ensureCacheUpdated();
        return this.myWcRoot == null ? null : this.myWcRoot.getRoot();
    }

    @Nullable
    public VirtualFile getRoot() {
        this.ensureCacheUpdated();
        return this.myWcRoot == null ? null : this.myWcRoot.getVirtualFile();
    }

    public RootUrlInfo getWcRootInfo() {
        this.ensureCacheUpdated();
        return this.myWcRoot;
    }

    private void ensureCacheUpdated() {
        if (!this.myCachedInfoLoaded) {
            this.updateCachedInfo();
        }
    }

    private void updateCachedInfo() {
        this.myCachedInfoLoaded = true;
        String commonPath = this.myCommonPathSearcher.getCommon();
        if (commonPath != null) {
            SvnFileUrlMapping urlMapping = this.myVcs.getSvnFileUrlMapping();
            if (urlMapping.isEmpty()) {
                this.myCachedInfoLoaded = false;
                return;
            }
            Url absoluteUrl = SvnUtil.parseUrl(Url.append(this.myRepositoryRoot, commonPath), false);
            this.myWcRoot = urlMapping.getWcRootForUrl(absoluteUrl);
            if (this.myWcRoot != null) {
                this.myBranchUrl = SvnUtil.getBranchForUrl(this.myVcs, this.myWcRoot.getVirtualFile(), absoluteUrl);
            }
        }
    }

    public void forceReloadCachedInfo() {
        this.myCachedInfoLoaded = false;
        this.myBranchUrl = null;
        this.myWcRoot = null;
    }

    @NotNull
    public Set<String> getAffectedPaths() {
        HashSet hashSet = ContainerUtil.newHashSet((Iterable)ContainerUtil.concat((Iterable[])new Iterable[]{this.myAddedPaths, this.myDeletedPaths, this.myChangedPaths}));
        if (hashSet == null) {
            SvnChangeList.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    @Nullable
    public String getWcPath() {
        RootUrlInfo rootInfo = this.getWcRootInfo();
        return rootInfo == null ? null : rootInfo.getIoFile().getAbsolutePath();
    }

    public boolean allPathsUnder(String path) {
        String commonRelative = this.myCommonPathSearcher.getCommon();
        return commonRelative != null && Url.isAncestor(path, Url.append(this.myRepositoryRoot, commonRelative));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logEntry";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryRoot";
                break;
            }
            case 7: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/history/SvnChangeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/history/SvnChangeList";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLocalPath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createPropertyRevision";
                break;
            }
            case 11: 
            case 14: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeToStream";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readFromStream";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 14 -> new IllegalStateException(string);
        };
    }

    private static class CommonPathSearcher {
        private String myCommon;

        private CommonPathSearcher() {
        }

        public void next(Iterable<String> values) {
            for (String value : values) {
                this.next(value);
            }
        }

        public void next(String value) {
            if (value == null) {
                return;
            }
            if (this.myCommon == null) {
                this.myCommon = value;
                return;
            }
            if (value.startsWith(this.myCommon)) {
                return;
            }
            this.myCommon = Url.getCommonAncestor(this.myCommon, value);
        }

        public String getCommon() {
            return this.myCommon;
        }
    }

    private final class ChangesListCreationHelper {
        private final List<Change> myList = new ArrayList<Change>();
        private final Map<String, Change> myPathToChangeMapping;
        private List<Change> myDetailedList;
        private final List<Pair<Integer, Boolean>> myWithoutDirStatus = new ArrayList<Pair<Integer, Boolean>>();

        private ChangesListCreationHelper() {
            this.myPathToChangeMapping = new HashMap<String, Change>();
        }

        public void add(String path, Change change) {
            SvnChangeList.this.patchChange(change, path);
            this.myList.add(change);
            this.myPathToChangeMapping.put(path, change);
        }

        public Change getByPath(String path) {
            return this.myPathToChangeMapping.get(path);
        }

        @Nullable
        private FilePath localDeletedPath(@NotNull Url url, boolean isDir) {
            SvnFileUrlMapping urlMapping;
            File file;
            if (url == null) {
                ChangesListCreationHelper.$$$reportNull$$$0(0);
            }
            if ((file = (urlMapping = SvnChangeList.this.myVcs.getSvnFileUrlMapping()).getLocalPath(url)) != null) {
                return VcsUtil.getFilePath((String)file.getAbsolutePath(), (isDir || file.isDirectory() ? 1 : 0) != 0);
            }
            return null;
        }

        public SvnRepositoryContentRevision createDeletedItemRevision(@NotNull String path, boolean isBeforeRevision) {
            if (path == null) {
                ChangesListCreationHelper.$$$reportNull$$$0(1);
            }
            boolean knownAsDirectory = SvnChangeList.this.myKnownAsDirectories.contains(path);
            Url url = SvnUtil.parseUrl(SvnChangeList.this.myRepositoryRoot + path, false);
            if (!knownAsDirectory) {
                this.myWithoutDirStatus.add((Pair<Integer, Boolean>)Pair.create((Object)this.myList.size(), (Object)isBeforeRevision));
            }
            return SvnRepositoryContentRevision.create(SvnChangeList.this.myVcs, SvnChangeList.this.myRepositoryRoot, path, this.localDeletedPath(url, knownAsDirectory), SvnChangeList.this.getRevision(isBeforeRevision));
        }

        public SvnRepositoryContentRevision createRevisionLazily(String path, boolean isBeforeRevision) {
            boolean knownAsDirectory = SvnChangeList.this.myKnownAsDirectories.contains(path);
            FilePath localPath = SvnChangeList.this.getLocalPath(path, (NotNullFunction<File, Boolean>)((NotNullFunction)file -> {
                if (knownAsDirectory) {
                    return Boolean.TRUE;
                }
                this.myWithoutDirStatus.add((Pair<Integer, Boolean>)new Pair((Object)this.myList.size(), (Object)isBeforeRevision));
                return Boolean.FALSE;
            }));
            long revision = SvnChangeList.this.getRevision(isBeforeRevision);
            return localPath == null ? SvnRepositoryContentRevision.createForRemotePath(SvnChangeList.this.myVcs, SvnChangeList.this.myRepositoryRoot, path, knownAsDirectory, revision) : SvnRepositoryContentRevision.create(SvnChangeList.this.myVcs, SvnChangeList.this.myRepositoryRoot, path, localPath, revision);
        }

        public List<Change> getList() {
            return this.myList;
        }

        public List<Change> getDetailedList() {
            if (this.myDetailedList == null) {
                this.myDetailedList = new ArrayList<Change>(this.myList);
                try {
                    this.doRemoteDetails();
                    this.uploadDeletedRenamedChildren();
                    ContainerUtil.removeDuplicates(this.myDetailedList);
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                }
            }
            return this.myDetailedList;
        }

        private void doRemoteDetails() throws SvnBindException {
            for (Pair<Integer, Boolean> idxData : this.myWithoutDirStatus) {
                Change sourceChange = this.myDetailedList.get((Integer)idxData.first);
                SvnRepositoryContentRevision revision = (SvnRepositoryContentRevision)((Boolean)idxData.second != false ? sourceChange.getBeforeRevision() : sourceChange.getAfterRevision());
                if (revision == null) continue;
                Revision beforeRevision = Revision.of(SvnChangeList.this.getRevision((Boolean)idxData.second));
                Info info = SvnChangeList.this.myVcs.getInfo(revision.getUrl(), beforeRevision, beforeRevision);
                boolean isDirectory = info != null && info.isDirectory();
                Change replacingChange = new Change((ContentRevision)this.createRevision((SvnRepositoryContentRevision)sourceChange.getBeforeRevision(), isDirectory), (ContentRevision)this.createRevision((SvnRepositoryContentRevision)sourceChange.getAfterRevision(), isDirectory));
                replacingChange.setIsReplaced(sourceChange.isIsReplaced());
                this.myDetailedList.set((Integer)idxData.first, replacingChange);
            }
            this.myWithoutDirStatus.clear();
        }

        @Nullable
        private SvnRepositoryContentRevision createRevision(SvnRepositoryContentRevision previousRevision, boolean isDir) {
            return previousRevision == null ? null : SvnRepositoryContentRevision.create(SvnChangeList.this.myVcs, previousRevision.getFullPath(), VcsUtil.getFilePath((String)previousRevision.getFile().getPath(), (boolean)isDir), previousRevision.getRevisionNumber().getRevision().getNumber());
        }

        private void uploadDeletedRenamedChildren() throws VcsException {
            Set<Pair<Boolean, String>> duplicates = this.collectDuplicates();
            List preprocessed = ChangesPreprocess.preprocessChangesRemoveDeletedForDuplicateMoved(this.myDetailedList);
            this.myDetailedList.addAll(this.collectDetails(preprocessed, duplicates));
        }

        private List<Change> collectDetails(@NotNull List<Change> changes, @NotNull Set<Pair<Boolean, String>> duplicates) throws VcsException {
            if (changes == null) {
                ChangesListCreationHelper.$$$reportNull$$$0(2);
            }
            if (duplicates == null) {
                ChangesListCreationHelper.$$$reportNull$$$0(3);
            }
            ArrayList<Change> result = new ArrayList<Change>();
            for (Change change : changes) {
                if (change.getAfterRevision() == null && change.getBeforeRevision().getFile().isDirectory()) {
                    result.addAll(this.getChildrenAsChanges(change.getBeforeRevision(), true, duplicates));
                    continue;
                }
                if (change.getBeforeRevision() == null && change.getAfterRevision().getFile().isDirectory()) {
                    if (!SvnChangeList.this.myCopiedAddedPaths.containsKey(this.getRelativePath(change.getAfterRevision()))) continue;
                    result.addAll(this.getChildrenAsChanges(change.getAfterRevision(), false, duplicates));
                    continue;
                }
                if (!change.isIsReplaced() && !change.isMoved() && !change.isRenamed() || !change.getAfterRevision().getFile().isDirectory()) continue;
                result.addAll(this.getChildrenAsChanges(change.getBeforeRevision(), true, duplicates));
                result.addAll(this.getChildrenAsChanges(change.getAfterRevision(), false, duplicates));
            }
            return result;
        }

        private Set<Pair<Boolean, String>> collectDuplicates() {
            HashSet<Pair<Boolean, String>> result = new HashSet<Pair<Boolean, String>>();
            for (Change change : this.myDetailedList) {
                this.addDuplicate(result, true, change.getBeforeRevision());
                this.addDuplicate(result, false, change.getAfterRevision());
            }
            return result;
        }

        private void addDuplicate(@NotNull Set<Pair<Boolean, String>> duplicates, boolean isBefore, @Nullable ContentRevision revision) {
            if (duplicates == null) {
                ChangesListCreationHelper.$$$reportNull$$$0(4);
            }
            if (revision != null) {
                duplicates.add((Pair<Boolean, String>)Pair.create((Object)isBefore, (Object)this.getRelativePath(revision)));
            }
        }

        @NotNull
        private String getRelativePath(@NotNull ContentRevision revision) {
            if (revision == null) {
                ChangesListCreationHelper.$$$reportNull$$$0(5);
            }
            String string = ((SvnRepositoryContentRevision)revision).getRelativePath(SvnChangeList.this.myRepositoryRoot);
            if (string == null) {
                ChangesListCreationHelper.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        private Collection<Change> getChildrenAsChanges(@NotNull ContentRevision contentRevision, boolean isBefore, @NotNull Set<Pair<Boolean, String>> duplicates) throws VcsException {
            if (contentRevision == null) {
                ChangesListCreationHelper.$$$reportNull$$$0(7);
            }
            if (duplicates == null) {
                ChangesListCreationHelper.$$$reportNull$$$0(8);
            }
            ArrayList<Change> result = new ArrayList<Change>();
            String path = this.getRelativePath(contentRevision);
            Url fullPath = ((SvnRepositoryContentRevision)contentRevision).getUrl();
            Revision revisionNumber = Revision.of(SvnChangeList.this.getRevision(isBefore));
            Target target = Target.on(fullPath, revisionNumber);
            SvnChangeList.this.myVcs.getFactory(target).createBrowseClient().list(target, revisionNumber, Depth.INFINITY, entry -> {
                String childPath = path + "/" + entry.getRelativePath();
                if (!duplicates.contains(Pair.create((Object)isBefore, (Object)childPath))) {
                    SvnRepositoryContentRevision contentRevision1 = this.createRevision(childPath, isBefore, entry.isDirectory());
                    result.add(new Change((ContentRevision)(isBefore ? contentRevision1 : null), (ContentRevision)(isBefore ? null : contentRevision1)));
                }
            });
            ArrayList<Change> arrayList = result;
            if (arrayList == null) {
                ChangesListCreationHelper.$$$reportNull$$$0(9);
            }
            return arrayList;
        }

        private SvnRepositoryContentRevision createRevision(String path, boolean isBeforeRevision, boolean isDir) {
            return SvnRepositoryContentRevision.create(SvnChangeList.this.myVcs, SvnChangeList.this.myRepositoryRoot, path, SvnChangeList.this.getLocalPath(path, (NotNullFunction<File, Boolean>)new ConstantFunction((Object)isDir)), SvnChangeList.this.getRevision(isBeforeRevision));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "duplicates";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/history/SvnChangeList$ChangesListCreationHelper";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentRevision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/history/SvnChangeList$ChangesListCreationHelper";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRelativePath";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenAsChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "localDeletedPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createDeletedItemRevision";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "collectDetails";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addDuplicate";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getRelativePath";
                    break;
                }
                case 6: 
                case 9: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildrenAsChanges";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 9 -> new IllegalStateException(string);
            };
        }
    }

    private static class RenameHelper {
        private RenameHelper() {
        }

        public String convertBeforePath(String path, TreeMap<String, String> after2before) {
            String current = path;
            for (String key : after2before.descendingKeySet()) {
                if (!Url.isAncestor(key, current)) continue;
                String relativePath = Url.getRelative(key, current);
                current = Url.append(after2before.get(key), relativePath);
            }
            return current;
        }
    }
}

