/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.commandInterface.commandLine;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LookupWithIndentsBuilder {
    @NotNull
    private final Map<LookupElementBuilder, Pair<String, Integer>> myMap = new LinkedHashMap<LookupElementBuilder, Pair<String, Integer>>();
    private int myMaxLength;
    private boolean myHasPriority;

    LookupWithIndentsBuilder() {
    }

    void addElement(@NotNull LookupElementBuilder lookupElementBuilder, @Nullable String help, int priority) {
        if (lookupElementBuilder == null) {
            LookupWithIndentsBuilder.$$$reportNull$$$0(0);
        }
        this.addElementInternal(lookupElementBuilder, help, priority);
    }

    void addElement(@NotNull LookupElementBuilder lookupElementBuilder, @Nullable String help) {
        if (lookupElementBuilder == null) {
            LookupWithIndentsBuilder.$$$reportNull$$$0(1);
        }
        this.addElementInternal(lookupElementBuilder, help, null);
    }

    private void addElementInternal(@NotNull LookupElementBuilder lookupElementBuilder, @Nullable String help, @Nullable Integer priority) {
        if (lookupElementBuilder == null) {
            LookupWithIndentsBuilder.$$$reportNull$$$0(2);
        }
        this.myMaxLength = Math.max(this.myMaxLength, lookupElementBuilder.getLookupString().length());
        this.myMap.put(lookupElementBuilder, (Pair<String, Integer>)Pair.create((Object)help, (Object)priority));
        if (priority != null) {
            this.myHasPriority = true;
        }
    }

    LookupElement @NotNull [] getResult() {
        ArrayList<Object> result = new ArrayList<Object>(this.myMap.size());
        for (Map.Entry<LookupElementBuilder, Pair<String, Integer>> entry : this.myMap.entrySet()) {
            LookupElementBuilder elementBuilder = entry.getKey();
            Pair<String, Integer> helpAndPriority = entry.getValue();
            String help = (String)helpAndPriority.first;
            if (!StringUtil.isEmptyOrSpaces((String)help)) {
                int padding = this.myMaxLength - elementBuilder.getLookupString().length();
                elementBuilder = elementBuilder.withTailText(String.format("%s : %s", StringUtil.repeat((String)" ", (int)padding), help));
            }
            if (this.myHasPriority) {
                int priority = helpAndPriority.second == null ? 0 : (Integer)helpAndPriority.second;
                result.add(PrioritizedLookupElement.withPriority((LookupElement)elementBuilder, (double)priority));
                continue;
            }
            result.add(elementBuilder);
        }
        LookupElement[] lookupElementArray = result.toArray(LookupElement.EMPTY_ARRAY);
        if (lookupElementArray == null) {
            LookupWithIndentsBuilder.$$$reportNull$$$0(3);
        }
        return lookupElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElementBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/commandInterface/commandLine/LookupWithIndentsBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/commandInterface/commandLine/LookupWithIndentsBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addElementInternal";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

