/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client.column;

import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.util.MutableInt;
import org.mariadb.jdbc.message.server.ColumnDefinitionPacket;
import org.mariadb.jdbc.plugin.codec.LocalDateTimeCodec;

public class TimestampColumn
extends ColumnDefinitionPacket
implements ColumnDecoder {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public TimestampColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat, false);
    }

    protected TimestampColumn(TimestampColumn prev) {
        super(prev, true);
    }

    @Override
    public TimestampColumn useAliasAsName() {
        return new TimestampColumn(this);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        return Timestamp.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        return 93;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        return this.dataType.name();
    }

    @Override
    public Object getDefaultText(ReadableByteBuf buf, MutableInt length, Context context) throws SQLDataException {
        return this.decodeTimestampText(buf, length, null, context);
    }

    @Override
    public Object getDefaultBinary(ReadableByteBuf buf, MutableInt length, Context context) throws SQLDataException {
        return this.decodeTimestampBinary(buf, length, null, context);
    }

    @Override
    public boolean decodeBooleanText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{this.dataType}));
    }

    @Override
    public boolean decodeBooleanBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{this.dataType}));
    }

    @Override
    public byte decodeByteText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Byte", new Object[]{this.dataType}));
    }

    @Override
    public byte decodeByteBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Byte", new Object[]{this.dataType}));
    }

    @Override
    public String decodeStringText(ReadableByteBuf buf, MutableInt length, Calendar providedCal, Context context) throws SQLDataException {
        if (length.get() == 0) {
            return this.buildZeroDate();
        }
        int initialLength = length.get();
        LocalDateTime ldt = this.parseText(buf, length);
        if (ldt == null) {
            if (initialLength > 0) {
                return this.buildZeroDate();
            }
            return null;
        }
        LocalDateTime modifiedLdt = TimestampColumn.localDateTimeToZoneDateTime(ldt, providedCal, context).toLocalDateTime();
        if (this.decimals > 0) {
            return dateTimeFormatter.format(modifiedLdt) + "." + String.format(Locale.US, "%0" + this.decimals + "d", modifiedLdt.getNano() / 1000);
        }
        return dateTimeFormatter.format(modifiedLdt);
    }

    private String buildZeroDate() {
        StringBuilder zeroValue = new StringBuilder("0000-00-00 00:00:00");
        if (this.decimals > 0) {
            zeroValue.append(".");
            for (int i = 0; i < this.decimals; ++i) {
                zeroValue.append("0");
            }
        }
        return zeroValue.toString();
    }

    @Override
    public String decodeStringBinary(ReadableByteBuf buf, MutableInt length, Calendar providedCal, Context context) throws SQLDataException {
        if (length.get() == 0) {
            return this.buildZeroDate();
        }
        int initialLength = length.get();
        LocalDateTime ldt = this.parseBinary(buf, length);
        if (ldt == null) {
            if (initialLength > 0) {
                return this.buildZeroDate();
            }
            return null;
        }
        LocalDateTime modifiedLdt = TimestampColumn.localDateTimeToZoneDateTime(ldt, providedCal, context).toLocalDateTime();
        if (this.decimals > 0) {
            return dateTimeFormatter.format(modifiedLdt) + "." + String.format(Locale.US, "%0" + this.decimals + "d", modifiedLdt.getNano() / 1000);
        }
        return dateTimeFormatter.format(modifiedLdt);
    }

    @Override
    public short decodeShortText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{this.dataType}));
    }

    @Override
    public short decodeShortBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{this.dataType}));
    }

    @Override
    public int decodeIntText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{this.dataType}));
    }

    @Override
    public int decodeIntBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{this.dataType}));
    }

    @Override
    public long decodeLongText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{this.dataType}));
    }

    @Override
    public long decodeLongBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{this.dataType}));
    }

    @Override
    public float decodeFloatText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{this.dataType}));
    }

    @Override
    public float decodeFloatBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{this.dataType}));
    }

    @Override
    public double decodeDoubleText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{this.dataType}));
    }

    @Override
    public double decodeDoubleBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{this.dataType}));
    }

    @Override
    public Date decodeDateText(ReadableByteBuf buf, MutableInt length, Calendar calParam, Context context) throws SQLDataException {
        LocalDateTime ldt = this.parseText(buf, length);
        if (ldt == null) {
            return null;
        }
        return new Date(TimestampColumn.localDateTimeToInstant(ldt, calParam, context) + (long)(ldt.getNano() / 1000000));
    }

    @Override
    public Date decodeDateBinary(ReadableByteBuf buf, MutableInt length, Calendar calParam, Context context) throws SQLDataException {
        LocalDateTime ldt = this.parseBinary(buf, length);
        if (ldt == null) {
            return null;
        }
        return new Date(TimestampColumn.localDateTimeToInstant(ldt, calParam, context) + (long)(ldt.getNano() / 1000000));
    }

    @Override
    public Time decodeTimeText(ReadableByteBuf buf, MutableInt length, Calendar calParam, Context context) throws SQLDataException {
        LocalDateTime ldt = this.parseText(buf, length);
        if (ldt == null) {
            return null;
        }
        return new Time(TimestampColumn.localDateTimeToInstant(ldt.withYear(1970).withMonth(1).withDayOfMonth(1), calParam, context) + (long)(ldt.getNano() / 1000000));
    }

    @Override
    public Time decodeTimeBinary(ReadableByteBuf buf, MutableInt length, Calendar calParam, Context context) throws SQLDataException {
        LocalDateTime ldt = this.parseBinary(buf, length);
        if (ldt == null) {
            return null;
        }
        return new Time(TimestampColumn.localDateTimeToInstant(ldt.withYear(1970).withMonth(1).withDayOfMonth(1), calParam, context) + (long)(ldt.getNano() / 1000000));
    }

    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, MutableInt length, Calendar calParam, Context context) throws SQLDataException {
        LocalDateTime ldt = this.parseText(buf, length);
        if (ldt == null) {
            return null;
        }
        Timestamp res = new Timestamp(TimestampColumn.localDateTimeToInstant(ldt, calParam, context));
        res.setNanos(ldt.getNano());
        return res;
    }

    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, MutableInt length, Calendar calParam, Context context) throws SQLDataException {
        LocalDateTime ldt = this.parseBinary(buf, length);
        if (ldt == null) {
            return null;
        }
        Timestamp res = new Timestamp(TimestampColumn.localDateTimeToInstant(ldt, calParam, context));
        res.setNanos(ldt.getNano());
        return res;
    }

    private LocalDateTime parseText(ReadableByteBuf buf, MutableInt length) {
        int[] parts = LocalDateTimeCodec.parseTimestamp(buf.readAscii(length.get()));
        if (parts == null) {
            length.set(-1);
            return null;
        }
        return LocalDateTime.of(parts[0], parts[1], parts[2], parts[3], parts[4], parts[5]).plusNanos(parts[6]);
    }

    private LocalDateTime parseBinary(ReadableByteBuf buf, MutableInt length) {
        if (length.get() == 0) {
            length.set(-1);
            return null;
        }
        int year = buf.readUnsignedShort();
        byte month = buf.readByte();
        byte dayOfMonth = buf.readByte();
        byte hour = 0;
        byte minutes = 0;
        byte seconds = 0;
        long microseconds = 0L;
        if (length.get() > 4) {
            hour = buf.readByte();
            minutes = buf.readByte();
            seconds = buf.readByte();
            if (length.get() > 7) {
                microseconds = buf.readUnsignedInt();
            }
        }
        if (year == 0 && month == 0 && dayOfMonth == 0 && hour == 0 && minutes == 0 && seconds == 0 && microseconds == 0L) {
            length.set(-1);
            return null;
        }
        return LocalDateTime.of(year, month, (int)dayOfMonth, (int)hour, (int)minutes, (int)seconds).plusNanos(microseconds * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long localDateTimeToInstant(LocalDateTime ldt, Calendar calParam, Context context) {
        if (calParam == null) {
            Calendar cal = context.getDefaultCalendar();
            cal.set(ldt.getYear(), ldt.getMonthValue() - 1, ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
            cal.set(14, 0);
            return cal.getTimeInMillis();
        }
        Calendar calendar = calParam;
        synchronized (calendar) {
            calParam.clear();
            calParam.set(ldt.getYear(), ldt.getMonthValue() - 1, ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
            return calParam.getTimeInMillis();
        }
    }

    public static ZonedDateTime localDateTimeToZoneDateTime(LocalDateTime ldt, Calendar calParam, Context context) {
        if (calParam == null) {
            if (context.getConf().preserveInstants()) {
                return ldt.atZone(context.getConnectionTimeZone().toZoneId()).withZoneSameInstant(TimeZone.getDefault().toZoneId());
            }
            return ldt.atZone(TimeZone.getDefault().toZoneId());
        }
        return ldt.atZone(calParam.getTimeZone().toZoneId());
    }
}

