/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.registry.json;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.cumulative.CumulativeCounter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionCounter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionTimer;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.internal.DefaultGauge;
import io.micrometer.core.instrument.internal.DefaultMeter;
import io.micrometer.core.instrument.noop.NoopLongTaskTimer;
import io.quarkus.micrometer.runtime.registry.json.JsonDistributionSummary;
import io.quarkus.micrometer.runtime.registry.json.JsonExporter;
import io.quarkus.micrometer.runtime.registry.json.JsonTimer;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public class JsonMeterRegistry
extends MeterRegistry {
    private final JsonExporter jsonExporter = new JsonExporter();
    private final Integer bufferLength;
    private final Duration expiry;

    public JsonMeterRegistry(Clock clock, Integer bufferLength, Duration expiry) {
        super(clock);
        this.bufferLength = bufferLength;
        this.expiry = expiry;
    }

    protected <T> Gauge newGauge(Meter.Id id, T obj, ToDoubleFunction<T> valueFunction) {
        return new DefaultGauge(id, obj, valueFunction);
    }

    protected Counter newCounter(Meter.Id id) {
        return new CumulativeCounter(id);
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        distributionStatisticConfig = DistributionStatisticConfig.builder().percentilesHistogram(Boolean.valueOf(false)).percentiles(new double[0]).build().merge(distributionStatisticConfig);
        return new JsonTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit());
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        return new JsonDistributionSummary(id, this.clock, distributionStatisticConfig, scale, false);
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return new DefaultMeter(id, type, measurements);
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        return new CumulativeFunctionTimer(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        return new CumulativeFunctionCounter(id, obj, countFunction);
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        return new NoopLongTaskTimer(id);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().percentiles(new double[]{0.5, 0.75, 0.95, 0.98, 0.99, 0.999}).percentilePrecision(Integer.valueOf(3)).percentilesHistogram(Boolean.valueOf(false)).minimumExpectedValue(Double.valueOf(Double.MIN_VALUE)).maximumExpectedValue(Double.valueOf(Double.POSITIVE_INFINITY)).bufferLength(this.bufferLength).expiry(this.expiry).build();
    }

    public String scrape() {
        return this.jsonExporter.exportEverything(this).toString();
    }
}

