/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc.internal;

import com.google.auto.value.AutoValue;
import io.opentelemetry.instrumentation.jdbc.internal.AutoValue_DbRequest;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcData;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcUtils;
import io.opentelemetry.instrumentation.jdbc.internal.dbinfo.DbInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import javax.annotation.Nullable;

@AutoValue
public abstract class DbRequest {
    @Nullable
    public static DbRequest create(PreparedStatement statement) {
        return DbRequest.create(statement, (String)JdbcData.preparedStatement.get((Object)statement));
    }

    @Nullable
    public static DbRequest create(Statement statement, String dbStatementString) {
        Connection connection = JdbcUtils.connectionFromStatement(statement);
        if (connection == null) {
            return null;
        }
        return DbRequest.create(JdbcUtils.extractDbInfo(connection), dbStatementString);
    }

    public static DbRequest create(DbInfo dbInfo, String queryText) {
        return new AutoValue_DbRequest(dbInfo, queryText);
    }

    public abstract DbInfo getDbInfo();

    public abstract String getQueryText();
}

