/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BinaryArithmeticOperator {
    ADD{

        @Override
        public String toLoggableText(String lhs, String rhs) {
            return BinaryArithmeticOperator.standardToLoggableText(lhs, this, rhs);
        }

        @Override
        public char getOperatorSqlText() {
            return '+';
        }
    }
    ,
    SUBTRACT{

        @Override
        public String toLoggableText(String lhs, String rhs) {
            return BinaryArithmeticOperator.standardToLoggableText(lhs, this, rhs);
        }

        @Override
        public char getOperatorSqlText() {
            return '-';
        }
    }
    ,
    MULTIPLY{

        @Override
        public String toLoggableText(String lhs, String rhs) {
            return BinaryArithmeticOperator.standardToLoggableText(lhs, this, rhs);
        }

        @Override
        public char getOperatorSqlText() {
            return '*';
        }
    }
    ,
    DIVIDE{

        @Override
        public String toLoggableText(String lhs, String rhs) {
            return BinaryArithmeticOperator.standardToLoggableText(lhs, this, rhs);
        }

        @Override
        public char getOperatorSqlText() {
            return '/';
        }
    }
    ,
    QUOT{

        @Override
        public String toLoggableText(String lhs, String rhs) {
            return BinaryArithmeticOperator.standardToLoggableText(lhs, this, rhs);
        }

        @Override
        public char getOperatorSqlText() {
            return '/';
        }
    }
    ,
    MODULO{

        @Override
        public String toLoggableText(String lhs, String rhs) {
            return "mod(" + lhs + "," + rhs + ")";
        }

        @Override
        public char getOperatorSqlText() {
            return '%';
        }
    }
    ,
    DIVIDE_PORTABLE{

        @Override
        public String toLoggableText(String lhs, String rhs) {
            return BinaryArithmeticOperator.standardToLoggableText(lhs, this, rhs);
        }

        @Override
        public char getOperatorSqlText() {
            return '/';
        }
    };


    public abstract String toLoggableText(String var1, String var2);

    public abstract char getOperatorSqlText();

    public String getOperatorSqlTextString() {
        return Character.toString(this.getOperatorSqlText());
    }

    private static String standardToLoggableText(String lhs, BinaryArithmeticOperator operator, String rhs) {
        return BinaryArithmeticOperator.standardToLoggableText(lhs, operator.getOperatorSqlText(), rhs);
    }

    private static String standardToLoggableText(String lhs, char operator, String rhs) {
        return "(" + lhs + operator + rhs + ")";
    }
}

