/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.LABColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.HSLColorImpl;
import io.sf.carte.doc.style.css.property.HSLColorValue;
import io.sf.carte.doc.style.css.property.LABColorImpl;
import io.sf.carte.doc.style.css.property.LABColorValue;
import io.sf.carte.doc.style.css.property.LCHColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.RGBColorValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Locale;
import org.w3c.dom.DOMException;

public abstract class ColorValue
extends TypedValue
implements CSSColorValue {
    private static final long serialVersionUID = 1L;
    static final NumberValue opaqueAlpha;
    private boolean systemDefault = false;
    boolean commaSyntax = true;

    ColorValue() {
        super(CSSValue.Type.COLOR);
    }

    ColorValue(CSSValue.Type type) {
        super(type);
    }

    ColorValue(ColorValue colorValue) {
        super(colorValue);
        this.systemDefault = colorValue.systemDefault;
        this.commaSyntax = colorValue.commaSyntax;
    }

    public void setSystemDefault() {
        this.systemDefault = true;
    }

    @Override
    public boolean isSystemDefault() {
        return this.systemDefault;
    }

    @Override
    public void setCssText(String string) throws DOMException {
        this.checkModifiableProperty();
        ValueFactory valueFactory = new ValueFactory();
        StyleValue styleValue = valueFactory.parseProperty(string);
        if (styleValue.getCssValueType() == CSSValue.CssType.TYPED) {
            CSSValue.Type type = styleValue.getPrimitiveType();
            if (type == CSSValue.Type.IDENT) {
                String string2 = ((CSSTypedValue)((Object)styleValue)).getStringValue().toLowerCase(Locale.ROOT);
                String string3 = ColorIdentifiers.getInstance().getColor(string2);
                if (string3 != null) {
                    styleValue = valueFactory.parseProperty(string3);
                } else if ("transparent".equals(string2)) {
                    styleValue = valueFactory.parseProperty("rgba(0,0,0,0)");
                } else {
                    this.failSetCssText();
                }
                type = styleValue.getPrimitiveType();
            }
            if (type != CSSValue.Type.COLOR || ((ColorValue)styleValue).getColorModel() != this.getColorModel() || !((ColorValue)styleValue).getColor().getColorSpace().equals(this.getColor().getColorSpace()) || this.getClass() != styleValue.getClass()) {
                this.failSetCssText();
            }
            this.set(styleValue);
        } else {
            this.failSetCssText();
        }
    }

    private void failSetCssText() {
        throw new DOMException(13, "This value can only be set to a color in the original color space and the " + (Object)((Object)this.getColorModel()) + " color model, using the same syntax.");
    }

    void set(StyleValue styleValue) {
        ColorValue colorValue = (ColorValue)styleValue;
        this.systemDefault = colorValue.systemDefault;
        this.commaSyntax = colorValue.commaSyntax;
    }

    @Override
    public String getCssText() {
        return this.getColor().toString();
    }

    @Override
    public String getMinifiedCssText(String string) {
        return this.getColor().toMinifiedString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)this.getColor().toString());
    }

    @Override
    public float deltaE2000(CSSColorValue cSSColorValue) {
        LABColor lABColor;
        LABColor lABColor2;
        if (!this.hasConvertibleComponents() || !((ColorValue)cSSColorValue).hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot compute delta.");
        }
        switch (cSSColorValue.getColorModel()) {
            case LCH: 
            case LAB: 
            case XYZ: {
                return cSSColorValue.deltaE2000(this);
            }
            case RGB: {
                RGBColor rGBColor = (RGBColor)cSSColorValue.getColor();
                LABColorImpl lABColorImpl = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                rGBColor.toLABColor(lABColorImpl);
                lABColor2 = lABColorImpl;
                RGBAColor rGBAColor = this.toRGBColor(false);
                RGBColorValue rGBColorValue = new RGBColorValue();
                rGBColorValue.setComponent(0, (StyleValue)((Object)rGBAColor.getAlpha()));
                rGBColorValue.setComponent(1, (StyleValue)((Object)rGBAColor.getRed()));
                rGBColorValue.setComponent(2, (StyleValue)((Object)rGBAColor.getGreen()));
                rGBColorValue.setComponent(3, (StyleValue)((Object)rGBAColor.getBlue()));
                lABColor = rGBColorValue.toLABColorValue().getColor();
                break;
            }
            default: {
                RGBAColor rGBAColor = this.toRGBColor(false);
                RGBAColor rGBAColor2 = cSSColorValue.toRGBColor(false);
                RGBColorValue rGBColorValue = new RGBColorValue();
                RGBColorValue rGBColorValue2 = new RGBColorValue();
                rGBColorValue.setComponent(0, (StyleValue)((Object)rGBAColor.getAlpha()));
                rGBColorValue.setComponent(1, (StyleValue)((Object)rGBAColor.getRed()));
                rGBColorValue.setComponent(2, (StyleValue)((Object)rGBAColor.getGreen()));
                rGBColorValue.setComponent(3, (StyleValue)((Object)rGBAColor.getBlue()));
                rGBColorValue2.setComponent(0, (StyleValue)((Object)rGBAColor2.getAlpha()));
                rGBColorValue2.setComponent(1, (StyleValue)((Object)rGBAColor2.getRed()));
                rGBColorValue2.setComponent(2, (StyleValue)((Object)rGBAColor2.getGreen()));
                rGBColorValue2.setComponent(3, (StyleValue)((Object)rGBAColor2.getBlue()));
                lABColor = rGBColorValue.toLABColorValue().getColor();
                lABColor2 = rGBColorValue2.toLABColorValue().getColor();
            }
        }
        return ColorUtil.deltaE2000Lab(((CSSTypedValue)lABColor.getLightness()).getFloatValue((short)0), ((CSSTypedValue)lABColor.getA()).getFloatValue((short)0), ((CSSTypedValue)lABColor.getB()).getFloatValue((short)0), ((CSSTypedValue)lABColor2.getLightness()).getFloatValue((short)0), ((CSSTypedValue)lABColor2.getA()).getFloatValue((short)0), ((CSSTypedValue)lABColor2.getB()).getFloatValue((short)0));
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax cSSValueSyntax) {
        return cSSValueSyntax.getCategory() == CSSValueSyntax.Category.color ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
    }

    @Override
    public void setComponent(int n, StyleValue styleValue) {
    }

    @Override
    public abstract PrimitiveValue getComponent(int var1);

    @Override
    public int getComponentCount() {
        return this.getColor().getLength();
    }

    abstract boolean hasConvertibleComponents();

    @Override
    public abstract ColorValue clone();

    public HSLColorValue toHSLColorValue() throws DOMException {
        RGBColor rGBColor = (RGBColor)this.toRGBColor(false);
        HSLColorValue hSLColorValue = new HSLColorValue();
        rGBColor.toHSLColor(hSLColorValue.getHSLColorImpl());
        return hSLColorValue;
    }

    @Override
    public LABColorValue toLABColorValue() throws DOMException {
        RGBColor rGBColor = (RGBColor)this.toRGBColor(false);
        LABColorValue lABColorValue = new LABColorValue();
        rGBColor.toLABColor(lABColorValue.getLABColorImpl());
        return lABColorValue;
    }

    @Override
    public LCHColorValue toLCHColorValue() throws DOMException {
        return this.toLABColorValue().toLCHColorValue();
    }

    static {
        NumberValue numberValue = new NumberValue();
        numberValue.setFloatValue((short)0, 1.0f);
        opaqueAlpha = numberValue.immutable();
    }

    class CSSRGBColor
    extends RGBColor {
        private static final long serialVersionUID = 2L;

        CSSRGBColor() {
        }

        CSSRGBColor(CSSRGBColor cSSRGBColor) {
            super(cSSRGBColor);
        }

        @Override
        public String toString() {
            return this.toString(false);
        }

        @Override
        public String toMinifiedString() {
            return this.toString(true);
        }

        String toString(boolean bl) {
            StringBuilder stringBuilder;
            float f = this.componentByte(this.getRed());
            float f2 = this.componentByte(this.getGreen());
            float f3 = this.componentByte(this.getBlue());
            boolean bl2 = this.isNonOpaque();
            if (bl2 || !this.isInteger(f) || !this.isInteger(f2) || !this.isInteger(f3) || f > 255.0f || f2 > 255.0f || f3 > 255.0f) {
                if (bl) {
                    if (ColorValue.this.commaSyntax) {
                        return this.minifiedOldFunctionalString(bl2);
                    }
                    return this.minifiedFunctionalString(bl2);
                }
                if (ColorValue.this.commaSyntax) {
                    return this.oldFunctionalString(bl2);
                }
                return this.functionalString(bl2);
            }
            int n = Math.round(f);
            int n2 = Math.round(f2);
            int n3 = Math.round(f3);
            String string = Integer.toHexString(n);
            String string2 = Integer.toHexString(n2);
            String string3 = Integer.toHexString(n3);
            if (n != 0 && this.notSameChar(string) || n2 != 0 && this.notSameChar(string2) || n3 != 0 && this.notSameChar(string3)) {
                stringBuilder = new StringBuilder(7);
                stringBuilder.append('#');
                if (string.length() == 1) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(string);
                if (string2.length() == 1) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(string2);
                if (string3.length() == 1) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(string3);
            } else {
                stringBuilder = new StringBuilder(4);
                stringBuilder.append('#');
                stringBuilder.append(string.charAt(0));
                stringBuilder.append(string2.charAt(0));
                stringBuilder.append(string3.charAt(0));
            }
            return stringBuilder.toString();
        }

        private float componentByte(PrimitiveValue primitiveValue) {
            TypedValue typedValue;
            CSSValue.Type type = primitiveValue.getPrimitiveType();
            float f = type == CSSValue.Type.NUMERIC ? ((typedValue = (TypedValue)primitiveValue).getUnitType() == 2 ? typedValue.getFloatValue((short)2) * 2.55f : typedValue.getFloatValue((short)0)) : 256.0f;
            return f;
        }

        private boolean isInteger(float f) {
            return (double)Math.abs(f - (float)Math.rint(f)) < 3.0E-4;
        }

        private String minifiedFunctionalString(boolean bl) {
            StringBuilder stringBuilder = new StringBuilder(21);
            stringBuilder.append("rgb(");
            this.appendComponentMinifiedCssText(stringBuilder, this.getRed()).append(' ');
            this.appendComponentMinifiedCssText(stringBuilder, this.getGreen()).append(' ');
            this.appendComponentMinifiedCssText(stringBuilder, this.getBlue());
            if (bl) {
                stringBuilder.append('/');
                this.appendAlphaChannelMinified(stringBuilder);
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }

        private String functionalString(boolean bl) {
            StringBuilder stringBuilder = new StringBuilder(23);
            stringBuilder.append("rgb(");
            this.appendComponentCssText(stringBuilder, this.getRed()).append(' ');
            this.appendComponentCssText(stringBuilder, this.getGreen()).append(' ');
            this.appendComponentCssText(stringBuilder, this.getBlue());
            if (bl) {
                stringBuilder.append(" / ");
                this.appendAlphaChannel(stringBuilder);
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }

        private boolean notSameChar(String string) {
            return string.length() == 1 || string.charAt(0) != string.charAt(1);
        }

        @Override
        HSLColorImpl createHSLColor() {
            return new MyHSLColorImpl();
        }

        @Override
        public CSSRGBColor clone() {
            return new CSSRGBColor(this);
        }
    }

    class MyHSLColorImpl
    extends HSLColorImpl {
        private static final long serialVersionUID = 1L;

        MyHSLColorImpl() {
        }

        @Override
        public String toString() {
            return this.toString(ColorValue.this.commaSyntax);
        }
    }
}

