/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.themes.ITheme;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.editors.EditorUtils;

public abstract class AbstractPresentation
implements IResultSetPresentation,
ISelectionProvider {
    public static final String RESULT_SET_PRESENTATION_CONTEXT_MENU = "org.jkiss.dbeaver.ui.controls.resultset.conext.menu";
    public static final String DATA_VALUE_CONTROLLER = "org.jkiss.dbeaver.resultset.value-controller";
    private static final String RESULTS_CONTROL_CONTEXT_ID = "org.jkiss.dbeaver.ui.context.resultset.focused";
    private static final String PRESENTATION_CONTROL_ID = "org.jkiss.dbeaver.ui.resultset.presentation";
    private static final StructuredSelection EMPTY_SELECTION = new StructuredSelection();
    protected IResultSetController controller;
    private final List<ISelectionChangedListener> selectionChangedListenerList = new ArrayList<ISelectionChangedListener>();

    @Override
    @NotNull
    public IResultSetController getController() {
        return this.controller;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void applyChanges() {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    @Override
    public void createPresentation(@NotNull IResultSetController controller, @NotNull Composite parent) {
        this.controller = controller;
    }

    protected void applyCurrentThemeSettings() {
        this.applyThemeSettings(UIUtils.getCurrentTheme());
    }

    @Override
    public void dispose() {
    }

    protected void applyThemeSettings(ITheme currentTheme) {
    }

    @Override
    public void fillMenu(@NotNull IMenuManager menu) {
    }

    @Override
    public void scrollToRow(@NotNull IResultSetPresentation.RowPosition position) {
        ResultSetRow currentRow = this.controller.getCurrentRow();
        ResultSetModel model = this.controller.getModel();
        switch (position) {
            case FIRST: {
                if (model.getRowCount() <= 0) break;
                this.controller.setCurrentRow(model.getRow(0));
                break;
            }
            case PREVIOUS: {
                if (currentRow == null || currentRow.getVisualNumber() <= 0) break;
                this.controller.setCurrentRow(model.getRow(currentRow.getVisualNumber() - 1));
                break;
            }
            case NEXT: {
                if (currentRow == null || currentRow.getVisualNumber() >= model.getRowCount() - 1) break;
                this.controller.setCurrentRow(model.getRow(currentRow.getVisualNumber() + 1));
                break;
            }
            case LAST: {
                if (currentRow == null) break;
                this.controller.setCurrentRow(model.getRow(model.getRowCount() - 1));
                break;
            }
            case CURRENT: {
                if (currentRow == null) break;
                this.controller.setCurrentRow(model.getRow(currentRow.getVisualNumber()));
            }
        }
        if (this.controller.isRecordMode()) {
            this.refreshData(true, false, false);
        } else {
            this.getControl().redraw();
        }
        this.controller.updateStatusMessage();
        this.controller.updateEditControls();
    }

    @Override
    public void setCurrentAttribute(@NotNull DBDAttributeBinding attribute) {
    }

    @Override
    @Nullable
    public DBDAttributeBinding getFocusAttribute() {
        return this.getCurrentAttribute();
    }

    @Override
    public void showAttribute(@NotNull DBDAttributeBinding attribute) {
    }

    @Override
    @Nullable
    public int[] getCurrentRowIndexes() {
        return null;
    }

    @Override
    public Point getCursorLocation() {
        return null;
    }

    @Override
    public void printResultSet() {
    }

    @Override
    public void rejectChanges() {
    }

    @Override
    @NotNull
    public String getFontId() {
        return "org.jkiss.dbeaver.sql.resultset.font";
    }

    protected void registerContextMenu() {
        MenuManager menuMgr = new MenuManager(null, RESULT_SET_PRESENTATION_CONTEXT_MENU);
        Menu menu = menuMgr.createContextMenu(this.getControl());
        menuMgr.addMenuListener(manager -> this.controller.fillContextMenu(manager, this.getCurrentAttribute(), this.controller.getCurrentRow(), null, IResultSetController.ContextMenuLocation.UNKNOWN));
        menuMgr.setRemoveAllWhenShown(true);
        this.getControl().setMenu(menu);
        IWorkbenchPartSite site = this.controller.getSite();
        if (site instanceof IEditorSite) {
            ((IEditorSite)site).registerContextMenu(this.getClass().getSimpleName() + "_menu", menuMgr, (ISelectionProvider)this, false);
        } else {
            site.registerContextMenu(menuMgr, (ISelectionProvider)this);
        }
    }

    protected void trackPresentationControl() {
        Control control = this.getControl();
        IWorkbenchPartSite site = this.controller.getSite();
        UIUtils.addFocusTracker((IServiceLocator)site, (String)PRESENTATION_CONTROL_ID, (Control)control);
        EditorUtils.trackControlContext((IWorkbenchSite)site, (Control)control, (String)RESULTS_CONTROL_CONTEXT_ID);
        control.addMouseWheelListener(e -> {
            boolean shift;
            boolean bl = shift = (e.stateMask & SWT.MOD2) != 0;
            if (shift) {
                this.performHorizontalScroll(e.count);
            }
        });
        this.controller.getDecorator().registerDragAndDrop(this);
    }

    protected void performHorizontalScroll(int scrollCount) {
    }

    protected void activateTextKeyBindings(final @NotNull IResultSetController controller, Control control) {
        final IContextService contextService = (IContextService)controller.getSite().getService(IContextService.class);
        control.addFocusListener(new FocusListener(){
            IContextActivation activation;

            public void focusGained(FocusEvent e) {
                controller.updateEditControls();
                if (this.activation == null) {
                    this.activation = contextService.activateContext("org.eclipse.ui.textEditorScope");
                }
            }

            public void focusLost(FocusEvent e) {
                controller.updateEditControls();
                if (this.activation != null) {
                    contextService.deactivateContext(this.activation);
                    this.activation = null;
                }
            }
        });
    }

    protected void fireSelectionChanged(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener listener : this.selectionChangedListenerList) {
            listener.selectionChanged(event);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListenerList.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListenerList.remove(listener);
    }

    public ISelection getSelection() {
        return EMPTY_SELECTION;
    }

    public void setSelection(ISelection selection) {
    }

    public void setSelection(@NotNull ISelection selection, boolean reflect) {
        this.setSelection(selection);
    }
}

