/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.gis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cugos.wkg.Coordinate;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.decomposition.lu.LUDecompositionAlt_DDRM;
import org.ejml.dense.row.decomposition.lu.LUDecompositionBase_DDRM;
import org.ejml.dense.row.linsol.lu.LinearSolverLu_DDRM;
import org.jkiss.code.NotNull;

public class CircularArc {
    private static final int DEFAULT_SEGMENTS_QUADRANT = 12;
    private static final int MAXIMUM_SEGMENTS_QUADRANT = 10000;
    private static final double HALF_PI = 1.5707963267948966;
    private static final double DOUBLE_PI = Math.PI * 2;
    private final Coordinate[] controlPoints;
    private double radius = Double.NaN;
    private double centerX;
    private double centerY;

    public CircularArc(@NotNull Coordinate[] controlPoints) {
        if (controlPoints.length != 3) {
            throw new IllegalArgumentException("Invalid control point array, it must be made of of 3 control points, start, mid and end");
        }
        this.controlPoints = controlPoints;
    }

    public CircularArc(@NotNull Coordinate start, @NotNull Coordinate mid, @NotNull Coordinate end) {
        this(new Coordinate[]{start, mid, end});
    }

    @NotNull
    public List<Coordinate> linearize(double tolerance) {
        this.initializeCenterRadius();
        if (this.radius != Double.POSITIVE_INFINITY && this.radius != 0.0) {
            return this.linearize(tolerance, new ArrayList<Coordinate>());
        }
        return List.of(this.controlPoints);
    }

    @NotNull
    private List<Coordinate> linearize(double tolerance, @NotNull List<Coordinate> array) {
        boolean clockwise;
        this.initializeCenterRadius();
        double sx = this.controlPoints[0].getX();
        double sy = this.controlPoints[0].getY();
        double mx = this.controlPoints[1].getX();
        double my = this.controlPoints[1].getY();
        double ex = this.controlPoints[2].getX();
        double ey = this.controlPoints[2].getY();
        double sa = Math.atan2(sy - this.centerY, sx - this.centerX);
        double ma = Math.atan2(my - this.centerY, mx - this.centerX);
        double ea = Math.atan2(ey - this.centerY, ex - this.centerX);
        boolean bl = clockwise = sa > ma && ma > ea || sa > ma && sa < ea || ma > ea && sa < ea;
        if (clockwise) {
            double tx = sx;
            double ty = sy;
            double ta = sa;
            sx = ex;
            ex = tx;
            sy = ey;
            ey = ty;
            sa = ea;
            ea = ta;
        }
        if (ma < sa) {
            ma += Math.PI * 2;
            ea += Math.PI * 2;
        } else if (ea < sa) {
            ea += Math.PI * 2;
        }
        double step = 1.5707963267948966 / (double)this.computeSegmentsPerQuadrant(tolerance);
        double angle = (Math.floor(sa / step) + 1.0) * step;
        if (angle <= ea) {
            int start = array.size();
            array.add(Coordinate.create2D((double)sx, (double)sy));
            if (angle > ma) {
                array.add(Coordinate.create2D((double)mx, (double)my));
                if (CircularArc.equals(angle, ma)) {
                    angle += step;
                }
            }
            double end = ea - 1.0E-12;
            while (angle < end) {
                double cx = this.centerX + this.radius * Math.cos(angle);
                double cy = this.centerY + this.radius * Math.sin(angle);
                array.add(Coordinate.create2D((double)cx, (double)cy));
                double next = angle + step;
                if (angle < ma && next > ma && !CircularArc.equals(angle, ma) && !CircularArc.equals(next, ma)) {
                    array.add(Coordinate.create2D((double)mx, (double)my));
                }
                angle = next;
            }
            array.add(Coordinate.create2D((double)ex, (double)ey));
            if (clockwise) {
                Collections.reverse(array.subList(start, array.size()));
            }
        } else {
            array.addAll(List.of(this.controlPoints));
        }
        return array;
    }

    /*
     * Unable to fully structure code
     */
    private int computeSegmentsPerQuadrant(double tolerance) {
        block5: {
            block6: {
                block4: {
                    if (tolerance < 0.0) {
                        throw new IllegalArgumentException("The tolerance must be a positive number, zero to use the default number of segments per quadrant (12), or Double.MAX_VALUE to use the max number of segments per quadrant (10000)");
                    }
                    if (tolerance != 0.0) break block4;
                    segmentsPerQuadrant = 12;
                    break block5;
                }
                if (tolerance != 1.7976931348623157E308) break block6;
                segmentsPerQuadrant = 10000;
                break block5;
            }
            segmentsPerQuadrant = 2;
            chordDistance = this.computeChordCircleDistance(segmentsPerQuadrant);
            if (!(chordDistance >= tolerance)) ** GOTO lbl19
            while (chordDistance > tolerance && segmentsPerQuadrant < 10000) {
                chordDistance = this.computeChordCircleDistance(segmentsPerQuadrant *= 2);
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                chordDistance = this.computeChordCircleDistance(segmentsPerQuadrant /= 2);
lbl19:
                // 2 sources

                ** while (chordDistance < tolerance && segmentsPerQuadrant > 1)
            }
lbl20:
            // 1 sources

            if (chordDistance > tolerance) {
                segmentsPerQuadrant *= 2;
            }
        }
        return segmentsPerQuadrant;
    }

    private double computeChordCircleDistance(int segmentsPerQuadrant) {
        double halfChordLength = this.radius * Math.sin(1.5707963267948966 / (double)segmentsPerQuadrant);
        double apothem = Math.sqrt(this.radius * this.radius - halfChordLength * halfChordLength);
        return this.radius - apothem;
    }

    private void initializeCenterRadius() {
        double re;
        double rm;
        double rs;
        if (!Double.isNaN(this.radius)) {
            return;
        }
        double sx = this.controlPoints[0].getX();
        double sy = this.controlPoints[0].getY();
        double mx = this.controlPoints[1].getX();
        double my = this.controlPoints[1].getY();
        double ex = this.controlPoints[2].getX();
        double ey = this.controlPoints[2].getY();
        if (CircularArc.equals(sx, ex) && CircularArc.equals(sy, ey)) {
            this.centerX = sx + (mx - sx) / 2.0;
            this.centerY = sy + (my - sy) / 2.0;
        } else {
            double sqs;
            DMatrixRMaj b;
            DMatrixRMaj A;
            double dx12 = sx - mx;
            double dy12 = sy - my;
            rs = sx - ex;
            double dy13 = sy - ey;
            double dx23 = mx - ex;
            rm = my - ey;
            double sqs1 = dx12 * dx12 + dy12 * dy12;
            double sqs2 = rs * rs + dy13 * dy13;
            re = dx23 * dx23 + rm * rm;
            if (sqs1 <= re && sqs2 <= re) {
                A = new DMatrixRMaj(2, 2, true, new double[]{dx12, dy12, rs, dy13});
                b = new DMatrixRMaj(2, 1, true, new double[]{0.5 * (dx12 * (sx + mx) + dy12 * (sy + my)), 0.5 * (rs * (sx + ex) + dy13 * (sy + ey))});
                sqs = sqs1 + sqs2;
            } else if (sqs1 <= sqs2 && re <= sqs2) {
                A = new DMatrixRMaj(2, 2, true, new double[]{dx12, dy12, dx23, rm});
                b = new DMatrixRMaj(2, 1, true, new double[]{0.5 * (dx12 * (sx + mx) + dy12 * (sy + my)), 0.5 * (dx23 * (mx + ex) + rm * (my + ey))});
                sqs = sqs1 + re;
            } else {
                A = new DMatrixRMaj(2, 2, true, new double[]{rs, dy13, dx23, rm});
                b = new DMatrixRMaj(2, 1, true, new double[]{0.5 * (rs * (sx + ex) + dy13 * (sy + ey)), 0.5 * (dx23 * (mx + ex) + rm * (my + ey))});
                sqs = sqs2 + re;
            }
            LUDecompositionAlt_DDRM lu = new LUDecompositionAlt_DDRM();
            LinearSolverLu_DDRM solver = new LinearSolverLu_DDRM((LUDecompositionBase_DDRM)lu);
            if (!solver.setA(A)) {
                this.radius = Double.POSITIVE_INFINITY;
                return;
            }
            double R = 2.0 * Math.abs(lu.computeDeterminant().getReal()) / sqs;
            double k = (1.0 + Math.sqrt(1.0 - R * R)) / R;
            if (k > 20000.0) {
                this.radius = Double.POSITIVE_INFINITY;
                return;
            }
            DMatrixRMaj x = new DMatrixRMaj(2, 1);
            solver.solve(b, x);
            this.centerX = x.get(0);
            this.centerY = x.get(1);
        }
        rs = Math.sqrt(Math.pow(this.centerX - sx, 2.0) + Math.pow(this.centerY - sy, 2.0));
        rm = Math.sqrt(Math.pow(this.centerX - mx, 2.0) + Math.pow(this.centerY - my, 2.0));
        re = Math.sqrt(Math.pow(this.centerX - ex, 2.0) + Math.pow(this.centerY - ey, 2.0));
        this.radius = Math.min(Math.max(rs, rm), re);
    }

    private static boolean equals(double a, double b) {
        return Math.abs(a - b) < 1.0E-12;
    }
}

