﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudtrail/CloudTrail_EXPORTS.h>
#include <aws/cloudtrail/model/QueryStatus.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CloudTrail {
namespace Model {
class CancelQueryResult {
 public:
  AWS_CLOUDTRAIL_API CancelQueryResult() = default;
  AWS_CLOUDTRAIL_API CancelQueryResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CLOUDTRAIL_API CancelQueryResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ID of the canceled query.</p>
   */
  inline const Aws::String& GetQueryId() const { return m_queryId; }
  template <typename QueryIdT = Aws::String>
  void SetQueryId(QueryIdT&& value) {
    m_queryIdHasBeenSet = true;
    m_queryId = std::forward<QueryIdT>(value);
  }
  template <typename QueryIdT = Aws::String>
  CancelQueryResult& WithQueryId(QueryIdT&& value) {
    SetQueryId(std::forward<QueryIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Shows the status of a query after a <code>CancelQuery</code> request.
   * Typically, the values shown are either <code>RUNNING</code> or
   * <code>CANCELLED</code>.</p>
   */
  inline QueryStatus GetQueryStatus() const { return m_queryStatus; }
  inline void SetQueryStatus(QueryStatus value) {
    m_queryStatusHasBeenSet = true;
    m_queryStatus = value;
  }
  inline CancelQueryResult& WithQueryStatus(QueryStatus value) {
    SetQueryStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The account ID of the event data store owner. </p>
   */
  inline const Aws::String& GetEventDataStoreOwnerAccountId() const { return m_eventDataStoreOwnerAccountId; }
  template <typename EventDataStoreOwnerAccountIdT = Aws::String>
  void SetEventDataStoreOwnerAccountId(EventDataStoreOwnerAccountIdT&& value) {
    m_eventDataStoreOwnerAccountIdHasBeenSet = true;
    m_eventDataStoreOwnerAccountId = std::forward<EventDataStoreOwnerAccountIdT>(value);
  }
  template <typename EventDataStoreOwnerAccountIdT = Aws::String>
  CancelQueryResult& WithEventDataStoreOwnerAccountId(EventDataStoreOwnerAccountIdT&& value) {
    SetEventDataStoreOwnerAccountId(std::forward<EventDataStoreOwnerAccountIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CancelQueryResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_queryId;

  QueryStatus m_queryStatus{QueryStatus::NOT_SET};

  Aws::String m_eventDataStoreOwnerAccountId;

  Aws::String m_requestId;
  bool m_queryIdHasBeenSet = false;
  bool m_queryStatusHasBeenSet = false;
  bool m_eventDataStoreOwnerAccountIdHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudTrail
}  // namespace Aws
