﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/forecast/ForecastService_EXPORTS.h>
#include <aws/forecast/model/DataDestination.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ForecastService {
namespace Model {
class DescribeExplainabilityExportResult {
 public:
  AWS_FORECASTSERVICE_API DescribeExplainabilityExportResult() = default;
  AWS_FORECASTSERVICE_API DescribeExplainabilityExportResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_FORECASTSERVICE_API DescribeExplainabilityExportResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the Explainability export.</p>
   */
  inline const Aws::String& GetExplainabilityExportArn() const { return m_explainabilityExportArn; }
  template <typename ExplainabilityExportArnT = Aws::String>
  void SetExplainabilityExportArn(ExplainabilityExportArnT&& value) {
    m_explainabilityExportArnHasBeenSet = true;
    m_explainabilityExportArn = std::forward<ExplainabilityExportArnT>(value);
  }
  template <typename ExplainabilityExportArnT = Aws::String>
  DescribeExplainabilityExportResult& WithExplainabilityExportArn(ExplainabilityExportArnT&& value) {
    SetExplainabilityExportArn(std::forward<ExplainabilityExportArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the Explainability export.</p>
   */
  inline const Aws::String& GetExplainabilityExportName() const { return m_explainabilityExportName; }
  template <typename ExplainabilityExportNameT = Aws::String>
  void SetExplainabilityExportName(ExplainabilityExportNameT&& value) {
    m_explainabilityExportNameHasBeenSet = true;
    m_explainabilityExportName = std::forward<ExplainabilityExportNameT>(value);
  }
  template <typename ExplainabilityExportNameT = Aws::String>
  DescribeExplainabilityExportResult& WithExplainabilityExportName(ExplainabilityExportNameT&& value) {
    SetExplainabilityExportName(std::forward<ExplainabilityExportNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the Explainability export.</p>
   */
  inline const Aws::String& GetExplainabilityArn() const { return m_explainabilityArn; }
  template <typename ExplainabilityArnT = Aws::String>
  void SetExplainabilityArn(ExplainabilityArnT&& value) {
    m_explainabilityArnHasBeenSet = true;
    m_explainabilityArn = std::forward<ExplainabilityArnT>(value);
  }
  template <typename ExplainabilityArnT = Aws::String>
  DescribeExplainabilityExportResult& WithExplainabilityArn(ExplainabilityArnT&& value) {
    SetExplainabilityArn(std::forward<ExplainabilityArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const DataDestination& GetDestination() const { return m_destination; }
  template <typename DestinationT = DataDestination>
  void SetDestination(DestinationT&& value) {
    m_destinationHasBeenSet = true;
    m_destination = std::forward<DestinationT>(value);
  }
  template <typename DestinationT = DataDestination>
  DescribeExplainabilityExportResult& WithDestination(DestinationT&& value) {
    SetDestination(std::forward<DestinationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Information about any errors that occurred during the export.</p>
   */
  inline const Aws::String& GetMessage() const { return m_message; }
  template <typename MessageT = Aws::String>
  void SetMessage(MessageT&& value) {
    m_messageHasBeenSet = true;
    m_message = std::forward<MessageT>(value);
  }
  template <typename MessageT = Aws::String>
  DescribeExplainabilityExportResult& WithMessage(MessageT&& value) {
    SetMessage(std::forward<MessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the Explainability export. States include: </p> <ul> <li> <p>
   * <code>ACTIVE</code> </p> </li> <li> <p> <code>CREATE_PENDING</code>,
   * <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li> <li> <p>
   * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li> <li> <p>
   * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
   * <code>DELETE_FAILED</code> </p> </li> </ul>
   */
  inline const Aws::String& GetStatus() const { return m_status; }
  template <typename StatusT = Aws::String>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = Aws::String>
  DescribeExplainabilityExportResult& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the Explainability export was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  DescribeExplainabilityExportResult& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The last time the resource was modified. The timestamp depends on the status
   * of the job:</p> <ul> <li> <p> <code>CREATE_PENDING</code> - The
   * <code>CreationTime</code>.</p> </li> <li> <p> <code>CREATE_IN_PROGRESS</code> -
   * The current timestamp.</p> </li> <li> <p> <code>CREATE_STOPPING</code> - The
   * current timestamp.</p> </li> <li> <p> <code>CREATE_STOPPED</code> - When the job
   * stopped.</p> </li> <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> -
   * When the job finished or failed.</p> </li> </ul>
   */
  inline const Aws::Utils::DateTime& GetLastModificationTime() const { return m_lastModificationTime; }
  template <typename LastModificationTimeT = Aws::Utils::DateTime>
  void SetLastModificationTime(LastModificationTimeT&& value) {
    m_lastModificationTimeHasBeenSet = true;
    m_lastModificationTime = std::forward<LastModificationTimeT>(value);
  }
  template <typename LastModificationTimeT = Aws::Utils::DateTime>
  DescribeExplainabilityExportResult& WithLastModificationTime(LastModificationTimeT&& value) {
    SetLastModificationTime(std::forward<LastModificationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The format of the exported data, CSV or PARQUET.</p>
   */
  inline const Aws::String& GetFormat() const { return m_format; }
  template <typename FormatT = Aws::String>
  void SetFormat(FormatT&& value) {
    m_formatHasBeenSet = true;
    m_format = std::forward<FormatT>(value);
  }
  template <typename FormatT = Aws::String>
  DescribeExplainabilityExportResult& WithFormat(FormatT&& value) {
    SetFormat(std::forward<FormatT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeExplainabilityExportResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_explainabilityExportArn;
  bool m_explainabilityExportArnHasBeenSet = false;

  Aws::String m_explainabilityExportName;
  bool m_explainabilityExportNameHasBeenSet = false;

  Aws::String m_explainabilityArn;
  bool m_explainabilityArnHasBeenSet = false;

  DataDestination m_destination;
  bool m_destinationHasBeenSet = false;

  Aws::String m_message;
  bool m_messageHasBeenSet = false;

  Aws::String m_status;
  bool m_statusHasBeenSet = false;

  Aws::Utils::DateTime m_creationTime{};
  bool m_creationTimeHasBeenSet = false;

  Aws::Utils::DateTime m_lastModificationTime{};
  bool m_lastModificationTimeHasBeenSet = false;

  Aws::String m_format;
  bool m_formatHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ForecastService
}  // namespace Aws
