/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.Objects;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.utils.LineLocation;

public class ErrorUml {
    private final String error;
    private final ErrorUmlType errorType;
    private final LineLocation lineLocation;
    private final int score;
    private final UmlDiagramType diagramType;

    public ErrorUml(ErrorUmlType type, String error, int score, LineLocation lineLocation, UmlDiagramType diagramType) {
        this.score = score;
        this.error = Objects.requireNonNull(error);
        this.errorType = Objects.requireNonNull(type);
        this.lineLocation = lineLocation;
        this.diagramType = diagramType;
    }

    public int score() {
        return this.score;
    }

    public boolean equals(Object obj) {
        ErrorUml this2 = (ErrorUml)obj;
        return this.errorType == this2.errorType && this.getPosition() == this2.getPosition() && this.error.equals(this2.error);
    }

    public int hashCode() {
        return this.error.hashCode() + this.errorType.hashCode() + this.getPosition();
    }

    public String toString() {
        return this.errorType.toString() + " " + this.getPosition() + " " + this.error;
    }

    public final String getError() {
        if (this.diagramType != null) {
            return this.error + " (Assumed diagram type: " + this.diagramType.humanReadableName() + ")";
        }
        return this.error;
    }

    public final int getPosition() {
        return this.lineLocation.getPosition();
    }

    public final LineLocation getLineLocation() {
        return this.lineLocation;
    }
}

