/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.filter;

import io.netty.handler.codec.http.HttpRequest;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.http.netty4.Netty4HttpChannel;
import org.opensearch.security.filter.NettyRequest;
import org.opensearch.security.filter.SecurityRequestChannel;
import org.opensearch.security.filter.SecurityResponse;

public class NettyRequestChannel
extends NettyRequest
implements SecurityRequestChannel {
    private final Logger log = LogManager.getLogger(NettyRequestChannel.class);
    private AtomicBoolean hasCompleted = new AtomicBoolean(false);
    private final AtomicReference<SecurityResponse> responseRef = new AtomicReference<Object>(null);

    NettyRequestChannel(HttpRequest request, Netty4HttpChannel channel) {
        super(request, channel);
    }

    @Override
    public void queueForSending(SecurityResponse response) {
        if (this.underlyingChannel == null) {
            throw new UnsupportedOperationException("Channel was not defined");
        }
        if (this.hasCompleted.get()) {
            throw new UnsupportedOperationException("This channel has already completed");
        }
        if (this.getQueuedResponse().isPresent()) {
            throw new UnsupportedOperationException("Another response was already queued");
        }
        this.responseRef.set(response);
    }

    @Override
    public Optional<SecurityResponse> getQueuedResponse() {
        return Optional.ofNullable(this.responseRef.get());
    }
}

