/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.segments;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.segments.ShardsSegment;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IndexSegment
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, IndexSegment> {
    @Nonnull
    private final Map<String, List<ShardsSegment>> shards;
    public static final JsonpDeserializer<IndexSegment> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexSegment::setupIndexSegmentDeserializer);

    private IndexSegment(Builder builder) {
        this.shards = ApiTypeHelper.unmodifiableRequired(builder.shards, (Object)this, "shards");
    }

    public static IndexSegment of(Function<Builder, ObjectBuilder<IndexSegment>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, List<ShardsSegment>> shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("shards");
        generator.writeStartObject();
        for (Map.Entry<String, List<ShardsSegment>> item0 : this.shards.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.writeStartArray();
            if (item0.getValue() != null) {
                for (ShardsSegment item1 : item0.getValue()) {
                    item1.serialize(generator, mapper);
                }
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIndexSegmentDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::shards, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(ShardsSegment._DESERIALIZER)), "shards");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.shards.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSegment other = (IndexSegment)o;
        return this.shards.equals(other.shards);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IndexSegment> {
        private Map<String, List<ShardsSegment>> shards;

        public Builder() {
        }

        private Builder(IndexSegment o) {
            this.shards = Builder._mapCopy(o.shards);
        }

        private Builder(Builder o) {
            this.shards = Builder._mapCopy(o.shards);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder shards(Map<String, List<ShardsSegment>> map) {
            this.shards = Builder._mapPutAll(this.shards, map);
            return this;
        }

        @Nonnull
        public final Builder shards(String key, List<ShardsSegment> value) {
            this.shards = Builder._mapPut(this.shards, key, value);
            return this;
        }

        @Override
        @Nonnull
        public IndexSegment build() {
            this._checkSingleUse();
            return new IndexSegment(this);
        }
    }
}

