/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.grpc.proto.request.search.query;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.knn.index.query.KNNQueryBuilder;
import org.opensearch.knn.index.query.request.MethodParameter;
import org.opensearch.protobufs.KnnQuery;
import org.opensearch.protobufs.KnnQueryRescore;
import org.opensearch.protobufs.ObjectMap;
import org.opensearch.protobufs.QueryContainer;
import org.opensearch.protobufs.RescoreContext;
import org.opensearch.transport.grpc.proto.request.search.query.QueryBuilderProtoConverterRegistry;

public final class KNNQueryBuilderProtoUtils {
    private static QueryBuilderProtoConverterRegistry REGISTRY = new QueryBuilderProtoConverterRegistry();

    static void setRegistry(QueryBuilderProtoConverterRegistry registry) {
        REGISTRY = registry;
    }

    static QueryBuilderProtoConverterRegistry getRegistry() {
        return REGISTRY;
    }

    public static QueryBuilder fromProto(KnnQuery knnQueryProto) {
        KNNQueryBuilder.Builder builder = KNNQueryBuilder.builder();
        builder.fieldName(knnQueryProto.getField());
        builder.vector(KNNQueryBuilderProtoUtils.convertVector(knnQueryProto.getVectorList()));
        if (knnQueryProto.getK() > 0) {
            builder.k(knnQueryProto.getK());
        } else if (knnQueryProto.hasMaxDistance()) {
            builder.maxDistance(Float.valueOf(knnQueryProto.getMaxDistance()));
        } else if (knnQueryProto.hasMinScore()) {
            builder.minScore(Float.valueOf(knnQueryProto.getMinScore()));
        }
        if (knnQueryProto.hasMethodParameters()) {
            Map<String, ?> methodParameters = KNNQueryBuilderProtoUtils.convertMethodParameters(knnQueryProto.getMethodParameters());
            builder.methodParameters(methodParameters);
        }
        if (knnQueryProto.hasFilter()) {
            QueryContainer filterQueryContainer = knnQueryProto.getFilter();
            builder.filter(REGISTRY.fromProto(filterQueryContainer));
        }
        if (knnQueryProto.hasRescore()) {
            org.opensearch.knn.index.query.rescore.RescoreContext rescoreContext = KNNQueryBuilderProtoUtils.convertRescoreContext(knnQueryProto.getRescore());
            builder.rescoreContext(rescoreContext);
        }
        if (knnQueryProto.hasBoost()) {
            builder.boost(knnQueryProto.getBoost());
        }
        if (knnQueryProto.hasUnderscoreName()) {
            builder.queryName(knnQueryProto.getUnderscoreName());
        }
        if (knnQueryProto.hasExpandNestedDocs()) {
            builder.expandNested(knnQueryProto.getExpandNestedDocs());
        }
        return builder.build();
    }

    private static float[] convertVector(List<Float> vectorList) {
        float[] vector = new float[vectorList.size()];
        for (int i = 0; i < vectorList.size(); ++i) {
            vector[i] = vectorList.get(i).floatValue();
        }
        return vector;
    }

    private static Map<String, ?> convertMethodParameters(ObjectMap objectMap) {
        HashMap<String, Object> rawMethodParameters = new HashMap<String, Object>();
        for (Map.Entry entry : objectMap.getFieldsMap().entrySet()) {
            String key = (String)entry.getKey();
            Object value = KNNQueryBuilderProtoUtils.convertObjectMapValue((ObjectMap.Value)entry.getValue());
            if (value == null) continue;
            rawMethodParameters.put(key, value);
        }
        HashMap processedMethodParameters = new HashMap();
        for (Map.Entry entry : rawMethodParameters.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            MethodParameter parameter = MethodParameter.enumOf(name);
            if (parameter == null) {
                throw new IllegalArgumentException("unknown method parameter found [" + name + "]");
            }
            try {
                Object parsedValue = parameter.parse(value);
                processedMethodParameters.put(name, parsedValue);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error parsing method parameter [" + name + "]: " + exception.getMessage());
            }
        }
        return processedMethodParameters.isEmpty() ? null : processedMethodParameters;
    }

    private static Object convertObjectMapValue(ObjectMap.Value value) {
        switch (value.getValueCase()) {
            case INT32: {
                return value.getInt32();
            }
            case INT64: {
                return value.getInt64();
            }
            case FLOAT: {
                return Float.valueOf(value.getFloat());
            }
            case DOUBLE: {
                return value.getDouble();
            }
            case STRING: {
                return value.getString();
            }
            case BOOL: {
                return value.getBool();
            }
        }
        return null;
    }

    private static org.opensearch.knn.index.query.rescore.RescoreContext convertRescoreContext(KnnQueryRescore rescoreProto) {
        switch (rescoreProto.getKnnQueryRescoreCase()) {
            case ENABLE: {
                return rescoreProto.getEnable() ? org.opensearch.knn.index.query.rescore.RescoreContext.getDefault() : org.opensearch.knn.index.query.rescore.RescoreContext.EXPLICITLY_DISABLED_RESCORE_CONTEXT;
            }
            case CONTEXT: {
                RescoreContext contextProto = rescoreProto.getContext();
                return contextProto.hasOversampleFactor() ? org.opensearch.knn.index.query.rescore.RescoreContext.builder().oversampleFactor(contextProto.getOversampleFactor()).build() : org.opensearch.knn.index.query.rescore.RescoreContext.getDefault();
            }
        }
        return org.opensearch.knn.index.query.rescore.RescoreContext.getDefault();
    }

    @Generated
    private KNNQueryBuilderProtoUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

