/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.ThreadPoolDispatcherKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.opensearch.action.admin.indices.resolve.ResolveIndexAction;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.alerting.action.GetRemoteIndexesRequest;
import org.opensearch.alerting.action.GetRemoteIndexesResponse;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.transport.SecureTransportAction;
import org.opensearch.alerting.transport.TransportGetRemoteIndexesActionKt;
import org.opensearch.alerting.util.CrossClusterMonitorUtils;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.cluster.health.ClusterIndexHealth;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B7\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J&\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00022\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030)H\u0014J$\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\b2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.H\u0082@\u00a2\u0006\u0002\u00100J$\u00101\u001a\u0002022\u0006\u0010,\u001a\u00020\b2\f\u00103\u001a\b\u0012\u0004\u0012\u00020/0.H\u0082@\u00a2\u0006\u0002\u00100J\u001c\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020/0.H\u0082@\u00a2\u0006\u0002\u00107R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001e\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00068"}, d2={"Lorg/opensearch/alerting/transport/TransportGetRemoteIndexesAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/alerting/action/GetRemoteIndexesRequest;", "Lorg/opensearch/alerting/action/GetRemoteIndexesResponse;", "Lorg/opensearch/alerting/transport/SecureTransportAction;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/transport/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/transport/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/core/xcontent/NamedXContentRegistry;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;)V", "getClient", "()Lorg/opensearch/transport/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "getFilterByEnabled", "()Ljava/lang/Boolean;", "setFilterByEnabled", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "remoteMonitoringEnabled", "getTransportService", "()Lorg/opensearch/transport/TransportService;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "getHealthStatuses", "Lorg/opensearch/action/admin/cluster/health/ClusterHealthResponse;", "targetClient", "parsedIndexesNames", "", "", "(Lorg/opensearch/transport/client/Client;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getIndexMappings", "Lorg/opensearch/action/admin/indices/mapping/get/GetMappingsResponse;", "parsedIndexNames", "getRemoteClusters", "Lorg/opensearch/action/admin/indices/resolve/ResolveIndexAction$Response;", "parsedIndexes", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nTransportGetRemoteIndexesAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportGetRemoteIndexesAction.kt\norg/opensearch/alerting/transport/TransportGetRemoteIndexesAction\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,202:1\n37#2,2:203\n37#2,2:205\n37#2,2:207\n*S KotlinDebug\n*F\n+ 1 TransportGetRemoteIndexesAction.kt\norg/opensearch/alerting/transport/TransportGetRemoteIndexesAction\n*L\n177#1:203,2\n187#1:205,2\n196#1:207,2\n*E\n"})
public final class TransportGetRemoteIndexesAction
extends HandledTransportAction<GetRemoteIndexesRequest, GetRemoteIndexesResponse>
implements SecureTransportAction {
    @NotNull
    private final TransportService transportService;
    @NotNull
    private final Client client;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private final ClusterService clusterService;
    private volatile Boolean filterByEnabled;
    private volatile Boolean remoteMonitoringEnabled;

    @Inject
    public TransportGetRemoteIndexesAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull NamedXContentRegistry xContentRegistry, @NotNull ClusterService clusterService, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super("cluster:admin/opensearch/alerting/remote/indexes/get", transportService, actionFilters, GetRemoteIndexesRequest::new);
        this.transportService = transportService;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.filterByEnabled = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(settings);
        this.remoteMonitoringEnabled = (Boolean)AlertingSettings.Companion.getCROSS_CLUSTER_MONITORING_ENABLED().get(settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getCROSS_CLUSTER_MONITORING_ENABLED(), arg_0 -> TransportGetRemoteIndexesAction._init_$lambda$0(this, arg_0));
        this.listenFilterBySettingChange(this.clusterService);
    }

    @NotNull
    public final TransportService getTransportService() {
        return this.transportService;
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    public Boolean getFilterByEnabled() {
        return this.filterByEnabled;
    }

    public void setFilterByEnabled(Boolean bl) {
        this.filterByEnabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull GetRemoteIndexesRequest request, @NotNull ActionListener<GetRemoteIndexesResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        TransportGetRemoteIndexesActionKt.access$getLog$p().debug("Remote monitoring enabled: {}", (Object)this.remoteMonitoringEnabled);
        if (!this.remoteMonitoringEnabled.booleanValue()) {
            actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Remote monitoring is not enabled.", RestStatus.FORBIDDEN, new Object[0])));
            return;
        }
        User user = this.readUserFromThreadContext(this.client);
        if (!this.validateUserBackendRoles(user, actionListener)) {
            return;
        }
        if (!request.isValid()) {
            actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Indexes includes an invalid pattern.", RestStatus.BAD_REQUEST, new Object[0])));
            return;
        }
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            Job job = BuildersKt.launch$default((CoroutineScope)TransportGetRemoteIndexesActionKt.access$getScope$p(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, this, request, actionListener, null){
                int label;
                final /* synthetic */ ThreadContext.StoredContext $it;
                final /* synthetic */ TransportGetRemoteIndexesAction this$0;
                final /* synthetic */ GetRemoteIndexesRequest $request;
                final /* synthetic */ ActionListener<GetRemoteIndexesResponse> $actionListener;
                {
                    this.$it = $it;
                    this.this$0 = $receiver;
                    this.$request = $request;
                    this.$actionListener = $actionListener;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ExecutorCoroutineDispatcher singleThreadContext = ThreadPoolDispatcherKt.newSingleThreadContext((String)"GetRemoteIndexesActionThread");
                            this.label = 1;
                            Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)singleThreadContext), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$it, this.this$0, this.$request, this.$actionListener, null){
                                Object L$0;
                                Object L$1;
                                Object L$2;
                                Object L$3;
                                Object L$4;
                                Object L$5;
                                Object L$6;
                                Object L$7;
                                Object L$8;
                                Object L$9;
                                Object L$10;
                                long J$0;
                                int label;
                                final /* synthetic */ ThreadContext.StoredContext $it;
                                final /* synthetic */ TransportGetRemoteIndexesAction this$0;
                                final /* synthetic */ GetRemoteIndexesRequest $request;
                                final /* synthetic */ ActionListener<GetRemoteIndexesResponse> $actionListener;
                                {
                                    this.$it = $it;
                                    this.this$0 = $receiver;
                                    this.$request = $request;
                                    this.$actionListener = $actionListener;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 * Could not resolve type clashes
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    var32_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            this.$it.restore();
                                            clusterIndexesList = new ArrayList<E>();
                                            resolveIndexResponse = null;
                                            this.L$0 = clusterIndexesList;
                                            this.label = 1;
                                            v0 = TransportGetRemoteIndexesAction.access$getRemoteClusters(this.this$0, this.$request.getIndexes(), (Continuation)this);
                                            ** if (v0 != var32_2) goto lbl15
lbl14:
                                            // 1 sources

                                            return var32_2;
lbl15:
                                            // 1 sources

                                            ** GOTO lbl23
                                        }
                                        case 1: {
                                            resolveIndexResponse = null;
                                            clusterIndexesList = (List)this.L$0;
                                            try {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl23:
                                                // 2 sources

                                                resolveIndexResponse = (ResolveIndexAction.Response)v0;
                                            }
                                            catch (Exception e) {
                                                TransportGetRemoteIndexesActionKt.access$getLog$p().error("Failed to retrieve indexes for request " + this.$request, (Throwable)e);
                                                this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(e));
                                            }
                                            resolvedIndexes = new ArrayList<E>();
                                            if (resolveIndexResponse != null) {
                                                v1 = resolveIndexResponse.getIndices();
                                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getIndices(...)");
                                                $this$forEach$iv = v1;
                                                $i$f$forEach = false;
                                                for (E element$iv : $this$forEach$iv) {
                                                    it = (ResolveIndexAction.ResolvedIndex)element$iv /* !! */ ;
                                                    $i$a$-forEach-TransportGetRemoteIndexesAction$doExecute$1$1$1$1 = false;
                                                    v2 = it.getName();
                                                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getName(...)");
                                                    resolvedIndexes.add(v2);
                                                }
                                                $this$forEach$iv = resolveIndexResponse.getAliases();
                                                Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"getAliases(...)");
                                                $i$f$forEach = false;
                                                for (E element$iv : $this$forEach$iv) {
                                                    it = (ResolveIndexAction.ResolvedAlias)element$iv /* !! */ ;
                                                    $i$a$-forEach-TransportGetRemoteIndexesAction$doExecute$1$1$1$2 = false;
                                                    v3 = it.getName();
                                                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getName(...)");
                                                    resolvedIndexes.add(v3);
                                                }
                                            }
                                            clusterIndexesMap = CrossClusterMonitorUtils.Companion.separateClusterIndexes((List<String>)resolvedIndexes, this.this$0.getClusterService());
                                            $i$f$forEach = clusterIndexesMap;
                                            var7_10 = this.this$0;
                                            var8_11 = this.$request;
                                            var9_12 = this.$actionListener;
                                            $i$f$forEach = false;
                                            var11_14 = $this$forEach$iv.entrySet().iterator();
lbl60:
                                            // 2 sources

                                            while (var11_14.hasNext()) {
                                                var13_16 = element$iv = var11_14.next();
                                                $i$a$-forEach-TransportGetRemoteIndexesAction$doExecute$1$1$1$3 = false;
                                                clusterName = (String)var13_16.getKey();
                                                indexes = (List)var13_16.getValue();
                                                targetClient = CrossClusterMonitorUtils.Companion.getClientForCluster(clusterName, var7_10.getClient(), var7_10.getClusterService());
                                                startTime = Instant.now();
                                                clusterHealthResponse = new Ref.ObjectRef();
                                                var20_23 = clusterHealthResponse;
                                                this.L$0 = clusterIndexesList;
                                                this.L$1 = var7_10;
                                                this.L$2 = var8_11;
                                                this.L$3 = var9_12;
                                                this.L$4 = var11_14;
                                                this.L$5 = clusterName;
                                                this.L$6 = indexes;
                                                this.L$7 = targetClient;
                                                this.L$8 = startTime;
                                                this.L$9 = clusterHealthResponse;
                                                this.L$10 = var20_23;
                                                this.label = 2;
                                                v4 = TransportGetRemoteIndexesAction.access$getHealthStatuses(var7_10, targetClient, indexes, (Continuation)this);
                                                ** if (v4 != var32_2) goto lbl86
lbl85:
                                                // 1 sources

                                                return var32_2;
lbl86:
                                                // 1 sources

                                                ** GOTO lbl106
                                            }
                                            break;
                                        }
                                        case 2: {
                                            $i$f$forEach = false;
                                            $i$a$-forEach-TransportGetRemoteIndexesAction$doExecute$1$1$1$3 = false;
                                            var20_23 = (Ref.ObjectRef)this.L$10;
                                            clusterHealthResponse = (Ref.ObjectRef)this.L$9;
                                            startTime = (Instant)this.L$8;
                                            targetClient = (Client)this.L$7;
                                            indexes = (List)this.L$6;
                                            clusterName = (String)this.L$5;
                                            var11_14 = (Iterator)this.L$4;
                                            var9_12 = (ActionListener)this.L$3;
                                            var8_11 = (GetRemoteIndexesRequest)this.L$2;
                                            var7_10 = (TransportGetRemoteIndexesAction)this.L$1;
                                            clusterIndexesList = (List)this.L$0;
                                            try {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v4 = $result;
lbl106:
                                                // 2 sources

                                                var20_23.element = v4;
                                            }
                                            catch (Exception e) {
                                                TransportGetRemoteIndexesActionKt.access$getLog$p().error("Failed to retrieve health statuses for request " + var8_11, (Throwable)e);
                                                var9_12.onFailure((Exception)AlertingException.Companion.wrap(e));
                                            }
                                            endTime = Instant.now();
                                            latency = Duration.between(startTime, endTime).toMillis();
                                            mappingsResponse = new Ref.ObjectRef();
                                            if (!var8_11.getIncludeMappings()) ** GOTO lbl158
                                            var20_23 = mappingsResponse;
                                            this.L$0 = clusterIndexesList;
                                            this.L$1 = var7_10;
                                            this.L$2 = var8_11;
                                            this.L$3 = var9_12;
                                            this.L$4 = var11_14;
                                            this.L$5 = clusterName;
                                            this.L$6 = indexes;
                                            this.L$7 = clusterHealthResponse;
                                            this.L$8 = var20_23;
                                            this.L$9 = mappingsResponse;
                                            this.L$10 = null;
                                            this.J$0 = latency;
                                            this.label = 3;
                                            v5 = TransportGetRemoteIndexesAction.access$getIndexMappings(var7_10, targetClient, indexes, (Continuation)this);
                                            ** if (v5 != var32_2) goto lbl134
lbl133:
                                            // 1 sources

                                            return var32_2;
lbl134:
                                            // 1 sources

                                            ** GOTO lbl153
                                        }
                                        case 3: {
                                            $i$f$forEach = false;
                                            $i$a$-forEach-TransportGetRemoteIndexesAction$doExecute$1$1$1$3 = false;
                                            latency = this.J$0;
                                            mappingsResponse = (Ref.ObjectRef)this.L$9;
                                            var20_23 = (Ref.ObjectRef)this.L$8;
                                            clusterHealthResponse = (Ref.ObjectRef)this.L$7;
                                            indexes = (List)this.L$6;
                                            clusterName = (String)this.L$5;
                                            var11_14 = (Iterator<Map.Entry<K, V>>)this.L$4;
                                            var9_12 = (ActionListener<GetRemoteIndexesResponse>)this.L$3;
                                            var8_11 = (GetRemoteIndexesRequest)this.L$2;
                                            var7_10 = (TransportGetRemoteIndexesAction)this.L$1;
                                            clusterIndexesList = (List)this.L$0;
                                            try {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v5 = $result;
lbl153:
                                                // 2 sources

                                                var20_23.element = v5;
                                            }
                                            catch (Exception e) {
                                                TransportGetRemoteIndexesActionKt.access$getLog$p().error("Failed to retrieve mappings for request " + var8_11, (Throwable)e);
                                                var9_12.onFailure((Exception)AlertingException.Companion.wrap(e));
                                            }
lbl158:
                                            // 3 sources

                                            clusterIndexList = new ArrayList<E>();
                                            if (clusterHealthResponse.element != null) {
                                                $this$forEach$iv = indexes;
                                                $i$f$forEach = false;
                                                for (T element$iv : $this$forEach$iv) {
                                                    it = (String)element$iv;
                                                    $i$a$-forEach-TransportGetRemoteIndexesAction$doExecute$1$1$1$3$1 = false;
                                                    v6 = (ClusterIndexHealth)((ClusterHealthResponse)clusterHealthResponse.element).getIndices().get(it);
                                                    clusterIndexList.add(new GetRemoteIndexesResponse.ClusterIndexes.ClusterIndex(it, (ClusterHealthStatus)(v6 != null ? v6.getStatus() : null), (v7 = (GetMappingsResponse)mappingsResponse.element) != null && (v7 = v7.getMappings()) != null ? (MappingMetadata)v7.get(it) : null));
                                                }
                                            }
                                            v8 = (ClusterHealthResponse)clusterHealthResponse.element;
                                            clusterIndexesList.add(new GetRemoteIndexesResponse.ClusterIndexes(clusterName, (ClusterHealthStatus)(v8 != null ? v8.getStatus() : null), Intrinsics.areEqual((Object)clusterName, (Object)var7_10.getClusterService().getClusterName().value()), clusterIndexList, latency));
                                            ** GOTO lbl60
                                        }
                                    }
                                    this.$actionListener.onResponse((Object)new GetRemoteIndexesResponse(clusterIndexesList));
                                    return Unit.INSTANCE;
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final Object getRemoteClusters(List<String> parsedIndexes, Continuation<? super ResolveIndexAction.Response> $completion) {
        Collection $this$toTypedArray$iv = parsedIndexes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ResolveIndexAction.Request resolveRequest = new ResolveIndexAction.Request(thisCollection$iv.toArray(new String[0]), ResolveIndexAction.Request.DEFAULT_INDICES_OPTIONS);
        return OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (Function2)((Function2)new Function2<Client, ActionListener<ResolveIndexAction.Response>, Unit>(resolveRequest){
            final /* synthetic */ ResolveIndexAction.Request $resolveRequest;
            {
                this.$resolveRequest = $resolveRequest;
                super(2);
            }

            public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<ResolveIndexAction.Response> it) {
                Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                $this$suspendUntil.admin().indices().resolveIndex(this.$resolveRequest, it);
            }
        }), $completion);
    }

    private final Object getHealthStatuses(Client targetClient, List<String> parsedIndexesNames, Continuation<? super ClusterHealthResponse> $completion) {
        Collection $this$toTypedArray$iv = parsedIndexesNames;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        ClusterHealthRequest clusterHealthRequest = new ClusterHealthRequest().indices(Arrays.copyOf(stringArray, stringArray.length)).indicesOptions(IndicesOptions.lenientExpandHidden());
        return OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)targetClient), (Function2)((Function2)new Function2<Client, ActionListener<ClusterHealthResponse>, Unit>(clusterHealthRequest){
            final /* synthetic */ ClusterHealthRequest $clusterHealthRequest;
            {
                this.$clusterHealthRequest = $clusterHealthRequest;
                super(2);
            }

            public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<ClusterHealthResponse> it) {
                Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                $this$suspendUntil.admin().cluster().health(this.$clusterHealthRequest, it);
            }
        }), $completion);
    }

    private final Object getIndexMappings(Client targetClient, List<String> parsedIndexNames, Continuation<? super GetMappingsResponse> $completion) {
        Collection $this$toTypedArray$iv = parsedIndexNames;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        GetMappingsRequest getMappingsRequest = (GetMappingsRequest)new GetMappingsRequest().indices(Arrays.copyOf(stringArray, stringArray.length));
        return OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)targetClient), (Function2)((Function2)new Function2<Client, ActionListener<GetMappingsResponse>, Unit>(getMappingsRequest){
            final /* synthetic */ GetMappingsRequest $getMappingsRequest;
            {
                this.$getMappingsRequest = $getMappingsRequest;
                super(2);
            }

            public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<GetMappingsResponse> it) {
                Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                $this$suspendUntil.admin().indices().getMappings(this.$getMappingsRequest, it);
            }
        }), $completion);
    }

    @Override
    public void listenFilterBySettingChange(@NotNull ClusterService clusterService) {
        SecureTransportAction.DefaultImpls.listenFilterBySettingChange(this, clusterService);
    }

    @Override
    @Nullable
    public User readUserFromThreadContext(@NotNull Client client) {
        return SecureTransportAction.DefaultImpls.readUserFromThreadContext(this, client);
    }

    @Override
    public boolean doFilterForUser(@Nullable User user) {
        return SecureTransportAction.DefaultImpls.doFilterForUser(this, user);
    }

    @Override
    public boolean isAdmin(@Nullable User user) {
        return SecureTransportAction.DefaultImpls.isAdmin(this, user);
    }

    @Override
    public <T> boolean validateUserBackendRoles(@Nullable User user, @NotNull ActionListener<T> actionListener) {
        return SecureTransportAction.DefaultImpls.validateUserBackendRoles(this, user, actionListener);
    }

    @Override
    public <T> boolean checkUserPermissionsWithResource(@Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
        return SecureTransportAction.DefaultImpls.checkUserPermissionsWithResource(this, requesterUser, resourceUser, actionListener, resourceType, resourceId);
    }

    private static final void _init_$lambda$0(TransportGetRemoteIndexesAction this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.remoteMonitoringEnabled = it;
    }

    public static final /* synthetic */ Object access$getRemoteClusters(TransportGetRemoteIndexesAction $this, List parsedIndexes, Continuation $completion) {
        return $this.getRemoteClusters(parsedIndexes, (Continuation<? super ResolveIndexAction.Response>)$completion);
    }

    public static final /* synthetic */ Object access$getHealthStatuses(TransportGetRemoteIndexesAction $this, Client targetClient, List parsedIndexesNames, Continuation $completion) {
        return $this.getHealthStatuses(targetClient, parsedIndexesNames, (Continuation<? super ClusterHealthResponse>)$completion);
    }

    public static final /* synthetic */ Object access$getIndexMappings(TransportGetRemoteIndexesAction $this, Client targetClient, List parsedIndexNames, Continuation $completion) {
        return $this.getIndexMappings(targetClient, parsedIndexNames, (Continuation<? super GetMappingsResponse>)$completion);
    }
}

