/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.netbeans.modules.tomcat5.util.LogSupport;
import org.netbeans.modules.tomcat5.util.UnsupportedLoggerException;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class LogViewer
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(LogViewer.class.getName());
    private volatile boolean stop = false;
    private final TomcatManager tomcatManager;
    private InputOutput inOut;
    private OutputWriter writer;
    private OutputWriter errorWriter;
    private File directory;
    private String prefix;
    private String suffix;
    private boolean isTimestamped;
    private boolean takeFocus;
    private ContextLogSupport logSupport;
    private String catalinaWorkDir;
    private String webAppContext;
    private boolean isStarted;
    private List<LogViewerStopListener> stopListeners = Collections.synchronizedList(new LinkedList());
    private String displayName;

    public LogViewer(TomcatManager tomcatManager, String webAppContext, String className, String directory, String prefix, String suffix, boolean isTimestamped, boolean takeFocus) throws UnsupportedLoggerException {
        super("LogViewer - Thread");
        this.tomcatManager = tomcatManager;
        this.catalinaWorkDir = tomcatManager.getCatalinaWork();
        if (className != null && !"org.apache.catalina.logger.FileLogger".equals(className)) {
            throw new UnsupportedLoggerException(className);
        }
        if (directory != null) {
            this.directory = new File(directory);
            if (!this.directory.isAbsolute()) {
                this.directory = new File(tomcatManager.getTomcatProperties().getCatalinaDir(), directory);
            }
        } else {
            this.directory = new File(tomcatManager.getTomcatProperties().getCatalinaDir(), "logs");
        }
        this.prefix = prefix != null ? prefix : "catalina.";
        this.suffix = suffix != null ? suffix : ".log";
        this.isTimestamped = isTimestamped;
        this.takeFocus = takeFocus;
        this.webAppContext = webAppContext;
        this.logSupport = new ContextLogSupport(this.catalinaWorkDir, webAppContext);
        this.setDaemon(true);
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LogViewer logViewer = this;
        synchronized (logViewer) {
            this.stop = true;
            this.notify();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LogViewer) {
            LogViewer anotherLogViewer = (LogViewer)obj;
            if (this.catalinaWorkDir.equals(anotherLogViewer.catalinaWorkDir) && (this.webAppContext != null && this.webAppContext.equals(anotherLogViewer.webAppContext) || this.webAppContext == anotherLogViewer.webAppContext) && this.directory.equals(anotherLogViewer.directory) && this.prefix.equals(anotherLogViewer.prefix) && this.suffix.equals(anotherLogViewer.suffix) && this.isTimestamped) {
                return true;
            }
        }
        return false;
    }

    public boolean isOpen() {
        InputOutput io = this.inOut;
        return io != null && !this.stop && (!this.isStarted || !io.isClosed());
    }

    public void takeFocus() {
        InputOutput io = this.inOut;
        if (io != null) {
            io.select();
        }
    }

    private File getLogFile(String timestamp) throws IOException {
        File f = new File(this.directory, this.prefix + timestamp + this.suffix);
        try {
            FileUtil.createData((File)f);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
        return f;
    }

    private String getTimestamp() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(new Date());
    }

    private void processLine(String line) {
        LogSupport.LineInfo lineInfo = this.logSupport.analyzeLine(line);
        if (lineInfo.isError()) {
            if (lineInfo.isAccessible()) {
                try {
                    this.errorWriter.println(line, (OutputListener)this.logSupport.getLink(lineInfo.message(), lineInfo.path(), lineInfo.line()));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                this.errorWriter.println(line);
            }
        } else {
            if (line.contains("java.lang.LinkageError: JAXB 2.0 API")) {
                File jaxwsApi = InstalledFileLocator.getDefault().locate("modules/ext/jaxws22/api/jakarta.xml.ws-api.jar", null, false);
                File jaxbApi = InstalledFileLocator.getDefault().locate("modules/ext/jaxb/api/jaxb-api.jar", null, false);
                File endoresedDir = this.tomcatManager.getTomcatProperties().getJavaEndorsedDir();
                if (jaxwsApi != null && jaxbApi != null) {
                    this.writer.println(NbBundle.getMessage(LogViewer.class, (String)"MSG_WSSERVLET11", (Object)jaxwsApi.getParent(), (Object)jaxbApi.getParent(), (Object)endoresedDir));
                } else {
                    this.writer.println(NbBundle.getMessage(LogViewer.class, (String)"MSG_WSSERVLET11_NOJAR", (Object)endoresedDir));
                }
            }
            this.writer.println(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block32: {
            String timestamp;
            if (this.displayName == null) {
                this.displayName = this.prefix;
                int trailingDot = this.displayName.lastIndexOf(".");
                if (trailingDot > -1) {
                    this.displayName = this.displayName.substring(0, trailingDot);
                }
            }
            this.inOut = IOProvider.getDefault().getIO(this.displayName, false);
            try {
                this.inOut.getOut().reset();
            }
            catch (IOException e) {
                Logger.getLogger(LogViewer.class.getName()).log(Level.INFO, null, e);
            }
            this.inOut.select();
            this.writer = this.inOut.getOut();
            this.errorWriter = this.inOut.getErr();
            this.isStarted = true;
            String oldTimestamp = timestamp = this.getTimestamp();
            try {
                File logFile = this.getLogFile(timestamp);
                BufferedReader reader = null;
                if (logFile != null && logFile.isFile()) {
                    reader = new BufferedReader(new FileReader(logFile));
                }
                block17: while (true) {
                    while (!this.stop && !this.inOut.isClosed()) {
                        block31: {
                            Process process = this.tomcatManager.getTomcatProcess();
                            try {
                                if (process == null) break block31;
                                process.exitValue();
                                break block32;
                            }
                            catch (IllegalThreadStateException illegalThreadStateException) {
                                // empty catch block
                            }
                        }
                        if (!(timestamp = this.getTimestamp()).equals(oldTimestamp)) {
                            oldTimestamp = timestamp;
                            if (reader != null) {
                                reader.close();
                            }
                            if ((logFile = this.getLogFile(timestamp)) != null && logFile.isFile()) {
                                reader = new BufferedReader(new FileReader(logFile));
                            }
                        }
                        if (reader != null) {
                            int count = 0;
                            boolean updated = false;
                            while (reader.ready() && count++ < 1024) {
                                this.processLine(reader.readLine());
                                updated = true;
                            }
                            if (updated) {
                                this.writer.flush();
                                this.errorWriter.flush();
                                if (this.takeFocus) {
                                    this.inOut.select();
                                }
                            }
                        }
                        try {
                            LogViewer logViewer = this;
                            synchronized (logViewer) {
                                if (!this.stop && !this.inOut.isClosed()) {
                                    this.wait(100L);
                                }
                                continue block17;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    break block32;
                    {
                        continue block17;
                        break;
                    }
                    break;
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                this.writer.close();
                this.errorWriter.close();
            }
        }
        this.fireLogViewerStopListener();
        this.logSupport.detachAnnotation();
    }

    public void addLogViewerStopListener(LogViewerStopListener listener) {
        this.stopListeners.add(listener);
    }

    public void removeAllLogViewerStopListener() {
        this.stopListeners.removeAll(this.stopListeners);
    }

    private void fireLogViewerStopListener() {
        Iterator<LogViewerStopListener> i = this.stopListeners.iterator();
        while (i.hasNext()) {
            i.next().callOnStop();
        }
    }

    static class ContextLogSupport
    extends LogSupport {
        private final String CATALINA_WORK_DIR;
        private String context = null;
        private String prevMessage = null;
        private static final String STANDARD_CONTEXT = "StandardContext[";
        private static final int STANDARD_CONTEXT_LENGTH = "StandardContext[".length();
        private GlobalPathRegistry globalPathReg = GlobalPathRegistry.getDefault();

        public ContextLogSupport(String catalinaWork, String webAppContext) {
            this.CATALINA_WORK_DIR = catalinaWork;
            this.context = webAppContext;
        }

        public LogSupport.LineInfo analyzeLine(String logLine) {
            String path = null;
            int line = -1;
            String message = null;
            boolean error = false;
            boolean accessible = false;
            logLine = logLine.trim();
            int lineLenght = logLine.length();
            if (logLine.startsWith("/")) {
                error = true;
                int colonIdx = logLine.indexOf(":");
                if (colonIdx > -1) {
                    int nextColonIdx;
                    path = logLine.substring(0, colonIdx);
                    accessible = true;
                    if (lineLenght > colonIdx && (nextColonIdx = logLine.indexOf(":", colonIdx + 1)) > -1) {
                        String lineNum = logLine.substring(colonIdx + 1, nextColonIdx);
                        try {
                            line = Integer.valueOf(lineNum);
                        }
                        catch (NumberFormatException nfe) {
                            Logger.getLogger(LogViewer.class.getName()).log(Level.INFO, null, nfe);
                        }
                        if (lineLenght > nextColonIdx) {
                            message = logLine.substring(nextColonIdx + 1, lineLenght);
                        }
                    }
                }
            } else if (lineLenght > 3 && Character.isLetter(logLine.charAt(0)) && logLine.charAt(1) == ':' && logLine.charAt(2) == '\\') {
                error = true;
                int secondColonIdx = logLine.indexOf(":", 2);
                if (secondColonIdx > -1) {
                    int thirdColonIdx;
                    path = logLine.substring(0, secondColonIdx);
                    accessible = true;
                    if (lineLenght > secondColonIdx && (thirdColonIdx = logLine.indexOf(":", secondColonIdx + 1)) > -1) {
                        String lineNum = logLine.substring(secondColonIdx + 1, thirdColonIdx);
                        try {
                            line = Integer.valueOf(lineNum);
                        }
                        catch (NumberFormatException nfe) {
                            Logger.getLogger(LogViewer.class.getName()).log(Level.INFO, null, nfe);
                        }
                        if (lineLenght > thirdColonIdx) {
                            message = logLine.substring(thirdColonIdx + 1, lineLenght);
                        }
                    }
                }
            } else if (logLine.startsWith("at ") && lineLenght > 3) {
                String classWithMethod;
                int lastDotIdx;
                error = true;
                int parenthIdx = logLine.indexOf("(");
                if (parenthIdx > -1 && (lastDotIdx = (classWithMethod = logLine.substring(3, parenthIdx)).lastIndexOf(".")) > -1) {
                    int firstDolarIdx;
                    int lastParenthIdx = logLine.lastIndexOf(")");
                    int lastColonIdx = logLine.lastIndexOf(":");
                    if (lastParenthIdx > -1 && lastColonIdx > -1) {
                        String lineNum = logLine.substring(lastColonIdx + 1, lastParenthIdx);
                        try {
                            line = Integer.valueOf(lineNum);
                        }
                        catch (NumberFormatException nfe) {
                            Logger.getLogger(LogViewer.class.getName()).log(Level.INFO, null, nfe);
                        }
                        message = this.prevMessage;
                    }
                    String className = classWithMethod.substring(0, (firstDolarIdx = classWithMethod.indexOf("$")) > -1 ? firstDolarIdx : lastDotIdx);
                    path = className.replace('.', '/') + ".java";
                    boolean bl = accessible = this.globalPathReg.findResource(path) != null;
                    if (className.startsWith("org.apache.jsp.") && this.context != null && this.context != null) {
                        String contextPath = this.context.equals("/") ? "/_" : this.context;
                        path = this.CATALINA_WORK_DIR + contextPath + "/" + path;
                        accessible = new File(path).exists();
                    }
                }
            } else {
                this.prevMessage = logLine;
                int stdContextIdx = logLine.indexOf(STANDARD_CONTEXT);
                int lBracketIdx = -1;
                if (stdContextIdx > -1) {
                    lBracketIdx = stdContextIdx + STANDARD_CONTEXT_LENGTH;
                }
                int rBracketIdx = logLine.indexOf("]");
                if (lBracketIdx > -1 && rBracketIdx > -1 && rBracketIdx > lBracketIdx) {
                    this.context = logLine.substring(lBracketIdx, rBracketIdx);
                }
            }
            return new LogSupport.LineInfo(path, line, message, error, accessible);
        }
    }

    public static interface LogViewerStopListener
    extends EventListener {
        public void callOnStop();
    }
}

