/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Transparency;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.MultiResolutionImage;
import java.awt.image.RGBImageFilter;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openide.util.CachedHiDPIIcon;
import org.openide.util.FilteredIcon;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.util.spi.SVGLoader;

public final class ImageUtilities {
    public static final String PROPERTY_URL = "url";
    private static final Logger LOGGER = Logger.getLogger(ImageUtilities.class.getName());
    static final String TOOLTIP_SEPAR = "<br>";
    private static final ActiveRef<String> NO_ICON = new ActiveRef<Object>(null, null, null);
    private static final Map<String, ActiveRef<String>> cache = new HashMap<String, ActiveRef<String>>(128);
    private static final Map<String, ActiveRef<String>> localizedCache = new HashMap<String, ActiveRef<String>>(128);
    private static final Map<CompositeImageKey, ActiveRef<CompositeImageKey>> compositeCache = new HashMap<CompositeImageKey, ActiveRef<CompositeImageKey>>(128);
    private static final Map<ToolTipImageKey, ActiveRef<ToolTipImageKey>> imageToolTipCache = new HashMap<ToolTipImageKey, ActiveRef<ToolTipImageKey>>(128);
    private static RGBImageFilter imageIconFilter = null;
    private static final Set<String> extraInitialSlashes = new HashSet<String>();
    private static final CachedLookupLoader<ClassLoader> classLoaderLoader = new CachedLookupLoader<ClassLoader>(ClassLoader.class);
    private static final CachedLookupLoader<SVGLoader> svgLoaderLoader = new CachedLookupLoader<SVGLoader>(SVGLoader.class);
    private static final Component component = new Component(){};
    private static final MediaTracker tracker = new MediaTracker(component);
    private static int mediaTrackerID;
    private static ImageReader PNG_READER;
    private static final String DARK_LAF_SUFFIX = "_dark";
    private static volatile Component dummyIconComponentLabel;
    private static volatile Component dummyIconComponentButton;

    private ImageUtilities() {
    }

    public static final Image loadImage(String resourceID) {
        return ImageUtilities.loadImage(resourceID, false);
    }

    public static final Image loadImage(String resource, boolean localized) {
        return ImageUtilities.loadImageInternal(resource, localized);
    }

    public static final Image loadImage(URI uri) {
        Parameters.notNull((CharSequence)"icon", (Object)uri);
        String scheme = uri.getScheme();
        if (scheme.equals("nbresloc")) {
            return ImageUtilities.loadImage(uri.getPath().substring(1), true);
        }
        if (scheme.equals("nbres")) {
            return ImageUtilities.loadImage(uri.getPath().substring(1), false);
        }
        if (!(scheme.equals("file") || scheme.equals("jar") && uri.toString().startsWith("jar:file:") || scheme.equals("file"))) {
            LOGGER.log(Level.WARNING, "loadImage(URI) called with unusual URI: {0}", uri);
        }
        try {
            return Toolkit.getDefaultToolkit().createImage(uri.toURL());
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.WARNING, "Malformed URL passed to loadImage(URI)", e);
            return null;
        }
    }

    public static final ImageIcon icon2ImageIcon(Icon icon) {
        ImageIcon imageIcon;
        if (icon == null) {
            LOGGER.log(Level.WARNING, "Passing null to icon2ImageIcon is not permitted", new NullPointerException());
            return null;
        }
        if (icon instanceof ImageIcon) {
            ImageIcon imageIcon2 = (ImageIcon)icon;
            return imageIcon2;
        }
        if (icon instanceof ToolTipImage) {
            ToolTipImage tti = (ToolTipImage)icon;
            return tti.asImageIcon();
        }
        Image image = ImageUtilities.icon2Image(icon);
        if (image instanceof ToolTipImage) {
            ToolTipImage tti = (ToolTipImage)image;
            imageIcon = tti.asImageIcon();
        } else {
            imageIcon = ImageUtilities.assignToolTipToImageInternal(image, "").asImageIcon();
        }
        return imageIcon;
    }

    private static ToolTipImage loadImageInternal(String resource, boolean localized) {
        if (resource == null) {
            return null;
        }
        ToolTipImage image = null;
        if (ImageUtilities.isDarkLaF()) {
            image = ImageUtilities.getIcon(ImageUtilities.addDarkSuffix(resource), localized);
        }
        if (null == image) {
            image = ImageUtilities.getIcon(resource, localized);
            RGBImageFilter imageFilter = ImageUtilities.getImageIconFilter();
            if (null != image && null != imageFilter) {
                image = ImageUtilities.icon2ToolTipImage(FilteredIcon.create(imageFilter, image), image.url);
            }
        }
        return image;
    }

    public static final ImageIcon loadImageIcon(String resource, boolean localized) {
        ToolTipImage image = ImageUtilities.loadImageInternal(resource, localized);
        if (image == null) {
            return null;
        }
        return image.asImageIcon();
    }

    public static final Icon loadIcon(String resource, boolean localized) {
        ToolTipImage image = ImageUtilities.loadImageInternal(resource, localized);
        if (image == null) {
            return null;
        }
        return image.asImageIconIfRequiredForRetina();
    }

    public static final Icon loadIcon(String resource) {
        return ImageUtilities.loadIcon(resource, false);
    }

    private static boolean isDarkLaF() {
        return UIManager.getBoolean("nb.dark.theme");
    }

    private static String addDarkSuffix(String resourceName) {
        int dotIndex = resourceName.lastIndexOf(46);
        if (dotIndex > 0) {
            return resourceName.substring(0, dotIndex) + DARK_LAF_SUFFIX + resourceName.substring(dotIndex);
        }
        return resourceName + DARK_LAF_SUFFIX;
    }

    private static RGBImageFilter getImageIconFilter() {
        Object obj;
        if (null == imageIconFilter && (obj = UIManager.get("nb.imageicon.filter")) instanceof RGBImageFilter) {
            RGBImageFilter filter;
            imageIconFilter = filter = (RGBImageFilter)obj;
        }
        return imageIconFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Image mergeImages(Image image1, Image image2, int x, int y) {
        if (image1 == null || image2 == null) {
            throw new NullPointerException();
        }
        CompositeImageKey k = new CompositeImageKey(image1, image2, x, y);
        Map<CompositeImageKey, ActiveRef<CompositeImageKey>> map = compositeCache;
        synchronized (map) {
            ToolTipImage cached;
            ActiveRef<CompositeImageKey> r = compositeCache.get(k);
            if (r != null && (cached = (ToolTipImage)r.get()) != null) {
                return cached;
            }
            cached = ImageUtilities.doMergeImages(image1, image2, x, y);
            compositeCache.put(k, new ActiveRef<CompositeImageKey>(cached, compositeCache, k));
            return cached;
        }
    }

    public static final Icon mergeIcons(Icon icon1, Icon icon2, int x, int y) {
        if (icon1 == null || icon2 == null) {
            throw new NullPointerException();
        }
        return ImageUtilities.image2Icon(ImageUtilities.mergeImages(ImageUtilities.icon2Image(icon1), ImageUtilities.icon2Image(icon2), x, y));
    }

    public static final Icon image2Icon(Image image) {
        ToolTipImage tti;
        ToolTipImage ret = image instanceof ToolTipImage ? (tti = (ToolTipImage)image) : ImageUtilities.assignToolTipToImageInternal(image, "");
        return ret.asImageIconIfRequiredForRetina();
    }

    public static final Image icon2Image(Icon icon) {
        ImageIcon imageIcon;
        Image ret;
        if (icon == null) {
            LOGGER.log(Level.WARNING, null, new NullPointerException());
            return ImageUtilities.loadImage("org/openide/nodes/defaultNode.png", true);
        }
        if (icon instanceof ToolTipImage) {
            ToolTipImage tti = (ToolTipImage)icon;
            return tti;
        }
        if (icon instanceof IconImageIcon) {
            IconImageIcon iconImageIcon = (IconImageIcon)icon;
            return ImageUtilities.icon2Image(iconImageIcon.getDelegateIcon());
        }
        if (icon instanceof ImageIcon && (ret = (imageIcon = (ImageIcon)icon).getImage()) != null) {
            return ret;
        }
        return ImageUtilities.icon2ToolTipImage(icon, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ToolTipImage icon2ToolTipImage(Icon icon, URL url) {
        Parameters.notNull((CharSequence)"icon", (Object)icon);
        if (icon instanceof ToolTipImage) {
            ToolTipImage tti = (ToolTipImage)icon;
            return tti;
        }
        ToolTipImage image = new ToolTipImage(icon, "", url, 2);
        Graphics g = image.getGraphics();
        try {
            icon.paintIcon(dummyIconComponentLabel, g, 0, 0);
        }
        catch (ClassCastException ex) {
            icon.paintIcon(dummyIconComponentButton, g, 0, 0);
        }
        finally {
            g.dispose();
        }
        return image;
    }

    public static final Image assignToolTipToImage(Image image, String text) {
        return ImageUtilities.assignToolTipToImageInternal(image, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ToolTipImage assignToolTipToImageInternal(Image image, String text) {
        Parameters.notNull((CharSequence)"image", (Object)image);
        Parameters.notNull((CharSequence)"text", (Object)text);
        ToolTipImageKey key = new ToolTipImageKey(image, text);
        Map<ToolTipImageKey, ActiveRef<ToolTipImageKey>> map = imageToolTipCache;
        synchronized (map) {
            ToolTipImage cached;
            ActiveRef<ToolTipImageKey> r = imageToolTipCache.get(key);
            if (r != null && (cached = (ToolTipImage)r.get()) != null) {
                return cached;
            }
            cached = ToolTipImage.createNew(text, image, null);
            imageToolTipCache.put(key, new ActiveRef<ToolTipImageKey>(cached, imageToolTipCache, key));
            return cached;
        }
    }

    public static final String getImageToolTip(Image image) {
        String string;
        if (image instanceof ToolTipImage) {
            ToolTipImage toolTipImage = (ToolTipImage)image;
            string = toolTipImage.toolTipText;
        } else {
            string = "";
        }
        return string;
    }

    public static final Image addToolTipToImage(Image image, String text) {
        if (image instanceof ToolTipImage) {
            ToolTipImage tti = (ToolTipImage)image;
            StringBuilder str = new StringBuilder(tti.toolTipText);
            if (str.length() > 0 && text.length() > 0) {
                str.append(TOOLTIP_SEPAR);
            }
            str.append(text);
            return ImageUtilities.assignToolTipToImage(image, str.toString());
        }
        return ImageUtilities.assignToolTipToImage(image, text);
    }

    public static Icon createDisabledIcon(Icon icon) {
        Parameters.notNull((CharSequence)"icon", (Object)icon);
        return FilteredIcon.create(ImageUtilities.isDarkLaF() ? DisabledButtonFilter.INSTANCE_DARK : DisabledButtonFilter.INSTANCE_LIGHT, icon);
    }

    public static Image createDisabledImage(Image image) {
        Parameters.notNull((CharSequence)"image", (Object)image);
        return ImageUtilities.icon2Image(ImageUtilities.createDisabledIcon(ImageUtilities.image2Icon(image)));
    }

    public static URL findImageBaseURL(Image image) {
        URL url;
        Object object = image.getProperty(PROPERTY_URL, null);
        return object instanceof URL ? (url = (URL)object) : null;
    }

    private static SVGLoader getSVGLoader() {
        return svgLoaderLoader.getLoader();
    }

    static ClassLoader getClassLoader() {
        return classLoaderLoader.getLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ToolTipImage getIcon(String resource, boolean localized) {
        if (localized) {
            if (resource == null) {
                return null;
            }
            Map<String, ActiveRef<String>> map = localizedCache;
            synchronized (map) {
                String ext;
                String base;
                ActiveRef<String> ref = localizedCache.get(resource);
                ToolTipImage img = null;
                if (ref == NO_ICON) {
                    return null;
                }
                if (ref != null) {
                    img = (ToolTipImage)ref.get();
                }
                if (img != null) {
                    return img;
                }
                ClassLoader loader = ImageUtilities.getClassLoader();
                int idx = (resource = new String(resource).intern()).lastIndexOf(46);
                if (idx != -1 && idx > resource.lastIndexOf(47)) {
                    base = resource.substring(0, idx);
                    ext = resource.substring(idx);
                } else {
                    base = resource;
                    ext = "";
                }
                URL baseurl = loader != null ? loader.getResource(resource) : ImageUtilities.class.getClassLoader().getResource(resource);
                Iterator it = NbBundle.getLocalizingSuffixes();
                while (it.hasNext()) {
                    String suffix = (String)it.next();
                    ToolTipImage i = suffix.isEmpty() ? ImageUtilities.getIcon(resource, loader, false) : ImageUtilities.getIcon(base + suffix + ext, loader, true);
                    if (i == null) continue;
                    localizedCache.put(resource, new ActiveRef<String>(i, localizedCache, resource));
                    return i;
                }
                localizedCache.put(resource, NO_ICON);
                return null;
            }
        }
        return ImageUtilities.getIcon(resource, ImageUtilities.getClassLoader(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ToolTipImage getIcon(String name, ClassLoader loader, boolean localizedQuery) {
        if (name == null) {
            return null;
        }
        ActiveRef<String> ref = cache.get(name);
        ToolTipImage img = null;
        if (ref == NO_ICON) {
            return null;
        }
        if (ref != null) {
            img = (ToolTipImage)ref.get();
        }
        if (img != null) {
            return img;
        }
        Map<String, ActiveRef<String>> map = cache;
        synchronized (map) {
            URL svgURL;
            String n;
            boolean warn;
            ref = cache.get(name);
            if (ref == NO_ICON) {
                return null;
            }
            if (ref != null) {
                img = (ToolTipImage)ref.get();
            }
            if (img != null) {
                return img;
            }
            if (name.startsWith("/")) {
                warn = true;
                n = name.substring(1);
            } else {
                warn = false;
                n = name;
            }
            SVGLoader svgLoader = null;
            ClassLoader useClassLoader = loader != null ? loader : ImageUtilities.class.getClassLoader();
            URL url = null;
            if ((n.endsWith(".png") || n.endsWith(".gif") || n.endsWith(".svg")) && (svgURL = useClassLoader.getResource(n.substring(0, n.length() - 4) + ".svg")) != null) {
                svgLoader = ImageUtilities.getSVGLoader();
                if (svgLoader != null) {
                    url = svgURL;
                } else {
                    LOGGER.log(Level.INFO, "No SVG loader available for loading {0}", svgURL);
                }
            }
            if (url == null && !n.endsWith(".svg")) {
                url = useClassLoader.getResource(n);
            }
            BufferedImage result = null;
            if (url != null) {
                if (svgLoader != null) {
                    try {
                        result = ImageUtilities.icon2ToolTipImage(svgLoader.loadIcon(url), url);
                    }
                    catch (IOException ioe) {
                        LOGGER.log(Level.INFO, "Failed to load SVG image " + String.valueOf(url), ioe);
                    }
                } else if (name.endsWith(".png")) {
                    try (ImageInputStream stream = ImageIO.createImageInputStream(url.openStream());){
                        ImageReadParam param = PNG_READER.getDefaultReadParam();
                        PNG_READER.setInput(stream, true, true);
                        result = PNG_READER.read(0, param);
                    }
                    catch (IOException ioe) {
                        LOGGER.log(Level.INFO, "Image " + name + " is not PNG", ioe);
                    }
                }
                if (result == null) {
                    try {
                        result = ImageIO.read(url);
                    }
                    catch (IOException ioe) {
                        LOGGER.log(Level.WARNING, "Cannot load " + name + " image", ioe);
                    }
                }
            }
            if (result != null) {
                BufferedImage tti;
                if (warn && extraInitialSlashes.add(name)) {
                    LOGGER.warning("Initial slashes in Utilities.loadImage deprecated (cf. #20072): " + name);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "loading icon {0} = {1}", new Object[]{n, result});
                }
                name = new String(name).intern();
                BufferedImage toolTipImage = result instanceof ToolTipImage ? (tti = result) : ToolTipImage.createNew("", result, url);
                cache.put(name, new ActiveRef<String>((ToolTipImage)toolTipImage, cache, name));
                return toolTipImage;
            }
            if (!localizedQuery) {
                cache.put(name, NO_ICON);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureLoaded(Image image) {
        if ((Toolkit.getDefaultToolkit().checkImage(image, -1, -1, null) & 0x30) != 0) {
            return;
        }
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            int id = ++mediaTrackerID;
            tracker.addImage(image, id);
            try {
                tracker.waitForID(id, 0L);
            }
            catch (InterruptedException e) {
                System.out.println("INTERRUPTED while loading Image");
            }
            tracker.removeImage(image, id);
        }
    }

    private static ToolTipImage doMergeImages(Image image1, Image image2, int x, int y) {
        Transparency trans2;
        Transparency trans1;
        ImageUtilities.ensureLoaded(image1);
        ImageUtilities.ensureLoaded(image2);
        int w = Math.max(1, Math.max(image1.getWidth(null), x + image2.getWidth(null)));
        int h = Math.max(1, Math.max(image1.getHeight(null), y + image2.getHeight(null)));
        boolean bitmask = image1 instanceof Transparency && (trans1 = (Transparency)((Object)image1)).getTransparency() != 3 && image2 instanceof Transparency && (trans2 = (Transparency)((Object)image2)).getTransparency() != 3;
        StringBuilder str = new StringBuilder(image1 instanceof ToolTipImage ? ((ToolTipImage)image1).toolTipText : "");
        if (image2 instanceof ToolTipImage) {
            ToolTipImage toolTipImage = (ToolTipImage)image2;
            String toolTip = toolTipImage.toolTipText;
            if (str.length() > 0 && toolTip.length() > 0) {
                str.append(TOOLTIP_SEPAR);
            }
            str.append(toolTip);
        }
        Object firstUrl = image1.getProperty(PROPERTY_URL, null);
        ColorModel model = ImageUtilities.colorModel(bitmask ? 2 : 3);
        MergedIcon delegateIcon = new MergedIcon(ImageUtilities.image2Icon(image1), ImageUtilities.image2Icon(image2), x, y);
        ToolTipImage buffImage = new ToolTipImage(str.toString(), delegateIcon, model, model.createCompatibleWritableRaster(w, h), model.isAlphaPremultiplied(), null, firstUrl instanceof URL ? (URL)firstUrl : null);
        Graphics2D g = buffImage.createGraphics();
        g.drawImage(image1, 0, 0, null);
        g.drawImage(image2, x, y, null);
        g.dispose();
        return buffImage;
    }

    static final BufferedImage createBufferedImage(int width, int height) {
        if (Utilities.isMac()) {
            return new BufferedImage(width, height, 3);
        }
        ColorModel model = ImageUtilities.colorModel(3);
        BufferedImage buffImage = new BufferedImage(model, model.createCompatibleWritableRaster(width, height), model.isAlphaPremultiplied(), null);
        return buffImage;
    }

    private static ColorModel colorModel(int transparency) {
        ColorModel model;
        try {
            model = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(transparency);
        }
        catch (ArrayIndexOutOfBoundsException aioobE) {
            model = ColorModel.getRGBdefault();
        }
        catch (HeadlessException he) {
            model = ColorModel.getRGBdefault();
        }
        return model;
    }

    static {
        if (EventQueue.isDispatchThread()) {
            dummyIconComponentLabel = new JLabel();
            dummyIconComponentButton = new JCheckBox();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dummyIconComponentLabel = new JLabel();
                    dummyIconComponentButton = new JCheckBox();
                }
            });
        }
        ImageIO.setUseCache(false);
        PNG_READER = ImageIO.getImageReadersByMIMEType("image/png").next();
    }

    private static class ToolTipImage
    extends BufferedImage
    implements Icon,
    MultiResolutionImage {
        final String toolTipText;
        final Icon delegateIcon;
        final URL url;
        ImageIcon imageIconVersion;
        volatile BufferedImage doubleSizeVariant;

        public static ToolTipImage createNew(String toolTipText, Image image, URL url) {
            Transparency trans;
            ImageUtilities.ensureLoaded(image);
            boolean bitmask = image instanceof Transparency && (trans = (Transparency)((Object)image)).getTransparency() != 3;
            ColorModel model = ImageUtilities.colorModel(bitmask ? 2 : 3);
            int w = Math.max(1, image.getWidth(null));
            int h = Math.max(1, image.getHeight(null));
            if (url == null) {
                URL u;
                Object value = image.getProperty(ImageUtilities.PROPERTY_URL, null);
                url = value instanceof URL ? (u = (URL)value) : null;
            }
            Icon icon = image instanceof ToolTipImage ? ((ToolTipImage)image).getDelegateIcon() : null;
            ToolTipImage newImage = new ToolTipImage(toolTipText, icon, model, model.createCompatibleWritableRaster(w, h), model.isAlphaPremultiplied(), null, url);
            Graphics2D g = newImage.createGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            return newImage;
        }

        public ToolTipImage(String toolTipText, Icon delegateIcon, ColorModel cm, WritableRaster raster, boolean isRasterPremultiplied, Hashtable<?, ?> properties, URL url) {
            super(cm, raster, isRasterPremultiplied, properties);
            this.toolTipText = toolTipText;
            this.delegateIcon = delegateIcon;
            this.url = url;
        }

        public synchronized ImageIcon asImageIcon() {
            if (this.imageIconVersion == null) {
                this.imageIconVersion = new IconImageIcon(this);
            }
            return this.imageIconVersion;
        }

        public Icon asImageIconIfRequiredForRetina() {
            return this.delegateIcon != null ? this.asImageIcon() : this;
        }

        public ToolTipImage(Icon delegateIcon, String toolTipText, URL url, int imageType) {
            super(Math.max(1, delegateIcon.getIconWidth()), Math.max(1, delegateIcon.getIconHeight()), imageType);
            this.delegateIcon = delegateIcon;
            this.toolTipText = toolTipText;
            this.url = url;
        }

        public Icon getDelegateIcon() {
            return this.delegateIcon;
        }

        @Override
        public int getIconHeight() {
            return super.getHeight();
        }

        @Override
        public int getIconWidth() {
            return super.getWidth();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.delegateIcon != null) {
                this.delegateIcon.paintIcon(c, g, x, y);
            } else {
                Graphics2D g2 = (Graphics2D)g.create();
                try {
                    AffineTransform tx = g2.getTransform();
                    int txType = tx.getType();
                    double scale = txType == 2 || txType == 3 ? tx.getScaleX() : 1.0;
                    if (scale != 1.0) {
                        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                        g2.setTransform(new AffineTransform(scale, 0.0, 0.0, scale, (double)((int)tx.getTranslateX()), (double)((int)tx.getTranslateY())));
                    }
                    g2.drawImage((Image)this, x, y, null);
                }
                finally {
                    g2.dispose();
                }
            }
        }

        @Override
        public Object getProperty(String name, ImageObserver observer) {
            if (ImageUtilities.PROPERTY_URL.equals(name)) {
                if (this.url != null) {
                    return this.url;
                }
                if (!(this.delegateIcon instanceof ImageIcon)) {
                    return null;
                }
                Image image = ((ImageIcon)this.delegateIcon).getImage();
                if (image == this || image == null) {
                    return null;
                }
                return image.getProperty(name, observer);
            }
            return super.getProperty(name, observer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Image getDoubleSizeVariant() {
            if (this.delegateIcon == null) {
                return null;
            }
            BufferedImage ret = this.doubleSizeVariant;
            if (ret == null) {
                int SCALE = 2;
                ColorModel model = this.getColorModel();
                int w = this.delegateIcon.getIconWidth() * SCALE;
                int h = this.delegateIcon.getIconHeight() * SCALE;
                ret = new BufferedImage(model, model.createCompatibleWritableRaster(w, h), model.isAlphaPremultiplied(), null);
                Graphics2D g = ret.createGraphics();
                try {
                    g.transform(AffineTransform.getScaleInstance(SCALE, SCALE));
                    this.delegateIcon.paintIcon(dummyIconComponentLabel, g, 0, 0);
                }
                finally {
                    g.dispose();
                }
                this.doubleSizeVariant = ret;
            }
            return ret;
        }

        @Override
        public Image getResolutionVariant(double destImageWidth, double destImageHeight) {
            if (destImageWidth <= (double)this.getWidth(null) && destImageHeight <= (double)this.getHeight(null)) {
                return this;
            }
            Image ds = this.getDoubleSizeVariant();
            return ds != null ? ds : this;
        }

        @Override
        public List<Image> getResolutionVariants() {
            Image ds = this.getDoubleSizeVariant();
            return ds == null ? List.of(this) : List.of(this, ds);
        }
    }

    private record CompositeImageKey(Image baseImage, Image overlayImage, int x, int y) {
        @Override
        public boolean equals(Object other) {
            boolean bl;
            if (other instanceof CompositeImageKey) {
                CompositeImageKey key = (CompositeImageKey)other;
                bl = this.x == key.x && this.y == key.y && this.baseImage == key.baseImage && this.overlayImage == key.overlayImage;
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public int hashCode() {
            int hash = (this.x << 3 ^ this.y) << 4;
            return hash ^ System.identityHashCode(this.baseImage) ^ System.identityHashCode(this.overlayImage);
        }

        @Override
        public String toString() {
            return "Composite key for " + String.valueOf(this.baseImage) + " + " + String.valueOf(this.overlayImage) + " at [" + this.x + ", " + this.y + "]";
        }
    }

    private static final class ActiveRef<T>
    extends SoftReference<ToolTipImage>
    implements Runnable {
        private final Map<T, ActiveRef<T>> holder;
        private final T key;

        public ActiveRef(ToolTipImage o, Map<T, ActiveRef<T>> holder, T key) {
            super(o, Utilities.activeReferenceQueue());
            this.holder = holder;
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<T, ActiveRef<T>> map = this.holder;
            synchronized (map) {
                this.holder.remove(this.key);
            }
        }
    }

    private static final class IconImageIcon
    extends ImageIcon {
        private volatile Icon delegate;

        IconImageIcon(ToolTipImage delegate) {
            super(delegate);
            Parameters.notNull((CharSequence)"delegate", (Object)delegate);
            this.delegate = delegate;
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            this.delegate.paintIcon(c, g, x, y);
        }

        public Icon getDelegateIcon() {
            return this.delegate;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(new ImageIcon(this.getImage()));
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.delegate = (ImageIcon)in.readObject();
        }

        private void readObjectNoData() throws ObjectStreamException {
            this.delegate = new ImageIcon(new BufferedImage(1, 1, 6));
        }
    }

    private record ToolTipImageKey(Image image, String str) {
        @Override
        public boolean equals(Object other) {
            boolean bl;
            if (other instanceof ToolTipImageKey) {
                ToolTipImageKey key = (ToolTipImageKey)other;
                bl = this.str.equals(key.str) && this.image == key.image;
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.image) ^ this.str.hashCode();
        }

        @Override
        public String toString() {
            return "ImageStringKey for " + String.valueOf(this.image) + " + " + this.str;
        }
    }

    private static final class DisabledButtonFilter
    extends RGBImageFilter {
        public static final RGBImageFilter INSTANCE_LIGHT = new DisabledButtonFilter(false);
        public static final RGBImageFilter INSTANCE_DARK = new DisabledButtonFilter(true);
        private final int baseGray;

        DisabledButtonFilter(boolean dark) {
            this.canFilterIndexColorModel = true;
            this.baseGray = dark ? 0x444444 : 0x888888;
        }

        @Override
        public int filterRGB(int x, int y, int argb) {
            return (argb & 0xFF000000) + this.baseGray + ((argb >> 16 & 0xFF) >> 2 << 16) + ((argb >> 8 & 0xFF) >> 2 << 8) + ((argb & 0xFF) >> 2);
        }

        @Override
        public void setProperties(Hashtable<?, ?> props) {
            this.consumer.setProperties((Hashtable)props.clone());
        }
    }

    private static final class CachedLookupLoader<T> {
        private final Class<T> clazz;
        private final AtomicBoolean noLoaderWarned = new AtomicBoolean(false);
        private volatile Optional<T> currentLoader;
        private Thread threadInProgress;
        private Lookup.Result<T> loaderQuery;

        public CachedLookupLoader(Class<T> clazz) {
            Parameters.notNull((CharSequence)"clazz", clazz);
            this.clazz = clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T getLoader() {
            Lookup.Result<T> useLoaderQuery;
            Optional<Object> toReturn = this.currentLoader;
            if (toReturn != null) {
                return toReturn.orElse(null);
            }
            CachedLookupLoader cachedLookupLoader = this;
            synchronized (cachedLookupLoader) {
                this.threadInProgress = Thread.currentThread();
                if (this.loaderQuery == null) {
                    this.loaderQuery = Lookup.getDefault().lookupResult(this.clazz);
                    this.loaderQuery.addLookupListener(new LookupListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void resultChanged(LookupEvent ev) {
                            LOGGER.log(Level.FINE, "Loader for {0} cleared", clazz);
                            CachedLookupLoader cachedLookupLoader = this;
                            synchronized (cachedLookupLoader) {
                                currentLoader = null;
                                threadInProgress = null;
                            }
                        }
                    });
                }
                useLoaderQuery = this.loaderQuery;
            }
            Iterator it = useLoaderQuery.allInstances().iterator();
            toReturn = Optional.ofNullable(it.hasNext() ? (Object)it.next() : null);
            if (!toReturn.isPresent()) {
                if (!this.noLoaderWarned.getAndSet(true)) {
                    LOGGER.log(Level.WARNING, "No {0} instance found in {1}", new Object[]{this.clazz, Lookup.getDefault()});
                }
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Loader computed for {0}: {1}", new Object[]{this.clazz, toReturn.orElse(null)});
            }
            CachedLookupLoader cachedLookupLoader2 = this;
            synchronized (cachedLookupLoader2) {
                if (this.threadInProgress == Thread.currentThread()) {
                    this.threadInProgress = null;
                    this.currentLoader = toReturn;
                }
            }
            return toReturn.orElse(null);
        }
    }

    private static final class MergedIcon
    extends CachedHiDPIIcon {
        private final Icon icon1;
        private final Icon icon2;
        private final int x;
        private final int y;

        public MergedIcon(Icon icon1, Icon icon2, int x, int y) {
            super(Math.max(icon1.getIconWidth(), x + icon2.getIconWidth()), Math.max(icon1.getIconHeight(), y + icon2.getIconHeight()));
            this.icon1 = icon1;
            this.icon2 = icon2;
            this.x = x;
            this.y = y;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Image createAndPaintImage(Component c, ColorModel colorModel, int deviceWidth, int deviceHeight, double scale) {
            BufferedImage ret = MergedIcon.createBufferedImage(colorModel, deviceWidth, deviceHeight);
            Graphics2D g = ret.createGraphics();
            try {
                g.clip(new Rectangle(0, 0, deviceWidth, deviceHeight));
                g.scale(scale, scale);
                this.icon1.paintIcon(c, g, 0, 0);
                this.icon2.paintIcon(c, g, this.x, this.y);
            }
            finally {
                g.dispose();
            }
            return ret;
        }
    }
}

