/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.java.hints.introduce.MemberSearchResult;

final class ReferenceTransformer
extends ErrorAwareTreePathScanner {
    private final ElementKind kind;
    private final String name;
    private final WorkingCopy copy;
    private final Element target;
    private Element shadowed;
    private Element shadowedGate;

    public ReferenceTransformer(WorkingCopy info, ElementKind kind, MemberSearchResult result, String name, Element target) {
        this.kind = kind;
        this.name = name;
        this.copy = info;
        this.target = target;
        if (result != null) {
            ElementHandle<? extends Element> s = result.getShadowed();
            if (s == null) {
                s = result.getOverriden();
            }
            if (s != null) {
                this.shadowed = s.resolve((CompilationInfo)info);
            }
            if ((s = result.getShadowedGate()) != null) {
                this.shadowedGate = result.getShadowedGate().resolve((CompilationInfo)info);
            }
        }
    }

    public Object scan(TreePath path, Object p) {
        if (this.shadowed == null || this.shadowedGate == null) {
            return null;
        }
        return super.scan(path, p);
    }

    public Object visitMemberSelect(MemberSelectTree node, Object p) {
        Object o = this.scan(node.getExpression(), p);
        if (o == Boolean.TRUE) {
            this.handleIdentifier(node, node.getIdentifier());
        }
        return null;
    }

    private void handleIdentifier(Tree node, Name id) {
        Element res;
        TreeMaker mk = this.copy.getTreeMaker();
        String nn = id.toString();
        if (nn.equals(this.name) && (res = this.copy.getTrees().getElement(this.getCurrentPath())) != null && res == this.shadowed) {
            if (res.getModifiers().contains((Object)Modifier.STATIC)) {
                this.copy.rewrite(node, (Tree)mk.MemberSelect((ExpressionTree)mk.Identifier(this.shadowedGate), (CharSequence)res.getSimpleName().toString()));
            } else if (this.shadowedGate == this.target) {
                this.copy.rewrite(node, (Tree)mk.MemberSelect((ExpressionTree)mk.MemberSelect((ExpressionTree)mk.Identifier(this.target), (CharSequence)"super"), (CharSequence)res.getSimpleName().toString()));
            } else {
                this.copy.rewrite(node, (Tree)mk.MemberSelect((ExpressionTree)mk.MemberSelect((ExpressionTree)mk.Identifier(this.shadowedGate), (CharSequence)"this"), (CharSequence)res.getSimpleName().toString()));
            }
        }
    }

    public Object visitIdentifier(IdentifierTree node, Object p) {
        String nn = node.getName().toString();
        if (nn.equals("this")) {
            return true;
        }
        this.handleIdentifier(node, node.getName());
        return null;
    }
}

