/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.modules.textmate.lexer.TextmateTokenId;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class HyperlinkProviderImpl
implements HyperlinkProviderExt {
    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
        return this.getHyperlinkSpan(doc, offset, type) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
        if (doc.getProperty(HyperlinkProviderImpl.class) != Boolean.TRUE) {
            return null;
        }
        BaseDocument document = (BaseDocument)doc;
        document.readLock();
        try {
            int[] ident = Utilities.getIdentifierBlock((BaseDocument)document, (int)offset);
            if (ident == null) {
                int[] nArray = null;
                return nArray;
            }
            TokenSequence ts = TokenHierarchy.get((Document)doc).tokenSequence();
            if (ts == null) {
                int[] nArray = ident;
                return nArray;
            }
            ts.move(offset);
            if (ts.moveNext() && ts.token().id() == TextmateTokenId.TEXTMATE) {
                int[] nArray = new int[]{ts.offset(), ts.offset() + ts.token().length()};
                return nArray;
            }
            int[] nArray = ident;
            return nArray;
        }
        catch (BadLocationException ex) {
            int[] nArray = null;
            return nArray;
        }
        finally {
            document.readUnlock();
        }
    }

    public void performClickAction(Document doc, int offset, HyperlinkType type) {
        FileObject file = NbEditorUtilities.getFileObject((Document)doc);
        if (file == null) {
            return;
        }
        LSPBindings server = LSPBindings.getBindings(file);
        if (server == null) {
            return;
        }
        String uri = Utils.toURI(file);
        try {
            DefinitionParams params = new DefinitionParams(new TextDocumentIdentifier(uri), Utils.createPosition(doc, offset));
            CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> def = server.getTextDocumentService().definition(params);
            ((CompletableFuture)def.handleAsync((locations, exception) -> {
                Range targetRange;
                String targetUri;
                if (exception != null) {
                    exception.printStackTrace();
                }
                if (locations == null) {
                    return null;
                }
                if (locations.isLeft() && ((List)locations.getLeft()).size() == 1) {
                    targetUri = ((Location)((List)locations.getLeft()).get(0)).getUri();
                    targetRange = ((Location)((List)locations.getLeft()).get(0)).getRange();
                } else if (locations.isRight() && ((List)locations.getRight()).size() == 1) {
                    targetUri = ((LocationLink)((List)locations.getRight()).get(0)).getTargetUri();
                    targetRange = ((LocationLink)((List)locations.getRight()).get(0)).getTargetRange();
                } else {
                    return null;
                }
                Utils.open(targetUri, targetRange);
                return null;
            })).get();
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        return null;
    }
}

