/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class ProfilingPointsDisplayer
extends JPanel
implements HelpCtx.Provider {
    private static final String HELP_CTX_KEY = "ProfilingPointsDisplayer.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ProfilingPointsDisplayer.HelpCtx");
    private static ProfilingPointsDisplayer defaultInstance;
    private DefaultListModel listModel;
    private JList list;

    private ProfilingPointsDisplayer() {
        this.initComponents();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public static void displayProfilingPoints(Lookup.Provider project, ProfilingSettings settings) {
        ProfilingPointsDisplayer ppd = ProfilingPointsDisplayer.getDefault();
        ppd.setupDisplay(project, settings);
        DialogDescriptor dd = new DialogDescriptor((Object)ppd, Bundle.ProfilingPointsDisplayer_PpActiveMsg(settings.getSettingsName()), true, new Object[]{DialogDescriptor.OK_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.pack();
        d.setVisible(true);
        ppd.cleanup();
    }

    private static ProfilingPointsDisplayer getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ProfilingPointsDisplayer();
        }
        return defaultInstance;
    }

    private void cleanup() {
        this.listModel.removeAllElements();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.getAccessibleContext().setAccessibleName(Bundle.ProfilingPointsDisplayer_ListAccessName());
        this.list.getSelectionModel().setSelectionMode(2);
        this.list.setVisibleRowCount(6);
        this.list.setCellRenderer(Utils.getPresenterListRenderer());
        JScrollPane listScroll = new JScrollPane(this.list, 20, 30);
        listScroll.setPreferredSize(new Dimension(405, listScroll.getPreferredSize().height));
        this.add((Component)listScroll, "Center");
    }

    private void setupDisplay(Lookup.Provider project, ProfilingSettings settings) {
        List<ProfilingPoint> compatibleProfilingPoints = ProfilingPointsManager.getDefault().getCompatibleProfilingPoints(project, settings, true);
        this.listModel.removeAllElements();
        if (compatibleProfilingPoints.size() == 0) {
            this.listModel.addElement(Bundle.ProfilingPointsDisplayer_NoActivePpsString());
        } else {
            for (ProfilingPoint profilingPoint : compatibleProfilingPoints) {
                this.listModel.addElement(profilingPoint);
            }
        }
    }
}

