/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.launcher;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.Util;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.apiimpl.VariablesImpl;
import com.install4j.runtime.launcher.LauncherVariables;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class Variables {
    private static Map<String, String> compilerVariables;
    private static Map<String, Object> installerVariables;

    private Variables() {
    }

    public static String getCompilerVariable(String variableName) throws IOException {
        if (compilerVariables == null) {
            InstallerConfig config = InstallerConfig.getConfigFromFile(InstallerUtil.getInstallerFile("i4jparams.conf"));
            compilerVariables = config.getCompilerVariables();
        }
        return compilerVariables.get(variableName);
    }

    public static synchronized Map<String, Object> getInstallerVariables() {
        Variables.ensureInstallerVariablesRead();
        return installerVariables;
    }

    public static synchronized Object getInstallerVariable(String variableName) {
        Variables.ensureInstallerVariablesRead();
        return installerVariables.get(variableName);
    }

    public static Map<String, Object> loadFromPreferenceStore(boolean userSpecific) throws IOException {
        return Variables.loadFromPreferenceStore(LauncherVariables.getApplicationId(), userSpecific);
    }

    public static Map<String, Object> loadFromPreferenceStore(String packageName, boolean userSpecific) throws IOException {
        return VariablesImpl.loadVariablesFromPreferenceStore(packageName, userSpecific);
    }

    public static void saveToPreferenceStore(Map<String, Object> variables, boolean userSpecific) throws IOException {
        Variables.saveToPreferenceStore(variables, LauncherVariables.getApplicationId(), userSpecific);
    }

    public static void saveToPreferenceStore(Map<String, Object> variables, String packageName, boolean userSpecific) throws IOException {
        VariablesImpl.saveVariablesToPreferenceStore(variables, packageName, userSpecific);
    }

    public static synchronized void clearInstallerVariablesCache() {
        installerVariables = null;
    }

    private static synchronized void ensureInstallerVariablesRead() {
        if (installerVariables == null) {
            installerVariables = VariablesImpl.readInstallerVariables(InstallerUtil.getInstallerFile("response.varfile"));
            Variables.addInstallationDir();
            if (System.getProperty("install4j.commIdentifier") == null) {
                InstallerVariables.initUserVars(installerVariables);
                InstallerVariables.initSystemVars(installerVariables);
            }
        }
    }

    private static void addInstallationDir() {
        String contentDirectory;
        String installationDirectory = contentDirectory = FileUtil.getCanonicalPath(new File(ResourceHelper.getRuntimeDir(), ".."));
        if (Util.isMacOS() && (contentDirectory.endsWith(".app/Contents/java/app") || contentDirectory.endsWith(".app/Contents/Resources/app"))) {
            installationDirectory = FileUtil.getCanonicalPath(new File(contentDirectory, "../../../.."));
        }
        installerVariables.put("sys.installationDir", installationDirectory);
        installerVariables.put("sys.contentDir", contentDirectory);
    }
}

