/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.zinternaltools;

import com.github.lgooddatepicker.zinternaltools.ExtraDateStrings;
import java.awt.Font;
import java.awt.FontMetrics;
import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javax.swing.JTextField;

public class CalculateMinimumDateFieldSize {
    public static int getFormattedDateWidthInPixels(DateTimeFormatter formatCE, Locale locale, Font fontValidDate, int numberOfExtraCharacters) {
        JTextField textField = new JTextField();
        FontMetrics fontMetrics = textField.getFontMetrics(fontValidDate);
        Month longestTextMonth = CalculateMinimumDateFieldSize.getLongestTextMonthInLocale(locale, fontMetrics);
        LocalDate longestTextDate = LocalDate.of(2000, longestTextMonth, 28);
        LocalDate longestNumericDate = LocalDate.of(2000, Month.DECEMBER, 28);
        String longestTextDateString = longestTextDate.format(formatCE);
        String longestNumericDateString = longestNumericDate.format(formatCE);
        int textDateWidth = fontMetrics.stringWidth(longestTextDateString);
        int numericDateWidth = fontMetrics.stringWidth(longestNumericDateString);
        int longestDateWidth = Math.max(textDateWidth, numericDateWidth);
        int singleNumericCharacterWidth = fontMetrics.stringWidth("8");
        longestDateWidth += 2 * singleNumericCharacterWidth;
        return longestDateWidth += numberOfExtraCharacters * singleNumericCharacterWidth;
    }

    private static Month getLongestTextMonthInLocale(Locale locale, FontMetrics fontMetrics) {
        String[] formattingMonthNames = ExtraDateStrings.getFormattingMonthNamesArray(locale, true, false);
        int longestMonthWidth = 0;
        Month longestMonth = Month.JANUARY;
        for (int i = 0; i < formattingMonthNames.length; ++i) {
            int currentMonthWidth = fontMetrics.stringWidth(formattingMonthNames[i]);
            if (currentMonthWidth < longestMonthWidth) continue;
            int oneBasedMonthIndex = i + 1;
            longestMonth = Month.of(oneBasedMonthIndex);
            longestMonthWidth = currentMonthWidth;
        }
        return longestMonth;
    }
}

