/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.spi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AssertionFailure;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LazyInitializationException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.SessionFactoryRegistry;
import org.hibernate.internal.util.MarkerObject;
import org.hibernate.internal.util.collections.IdentitySet;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.hibernate.type.BasicType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public abstract class AbstractPersistentCollection<E>
implements Serializable,
PersistentCollection<E> {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(AbstractPersistentCollection.class);
    private transient SharedSessionContractImplementor session;
    private boolean isTempSession = false;
    private boolean initialized;
    private transient boolean initializing;
    private transient List<DelayedOperation<E>> operationQueue;
    private transient boolean directlyAccessible;
    private @Nullable Object owner;
    private int cachedSize = -1;
    private @Nullable String role;
    private @Nullable Object key;
    private boolean dirty;
    protected boolean elementRemoved;
    private @Nullable Serializable storedSnapshot;
    private String sessionFactoryUuid;
    private boolean allowLoadOutsideTransaction;
    private transient int instanceId;
    protected static final Object UNKNOWN = new MarkerObject("UNKNOWN");

    public AbstractPersistentCollection() {
    }

    protected AbstractPersistentCollection(SharedSessionContractImplementor session) {
        this.session = session;
    }

    @Override
    public final @Nullable String getRole() {
        return this.role;
    }

    @Override
    public final @Nullable Object getKey() {
        return this.key;
    }

    @Override
    public final boolean isUnreferenced() {
        return this.role == null;
    }

    @Override
    public final boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isElementRemoved() {
        return this.elementRemoved;
    }

    @Override
    public final void clearDirty() {
        this.dirty = false;
        this.elementRemoved = false;
    }

    @Override
    public final void dirty() {
        this.dirty = true;
    }

    @Override
    public final @Nullable Serializable getStoredSnapshot() {
        return this.storedSnapshot;
    }

    @Override
    public abstract boolean empty();

    protected final void read() {
        this.initialize(false);
    }

    protected boolean readSize() {
        if (!this.initialized) {
            if (this.cachedSize != -1 && !this.hasQueuedOperations()) {
                return true;
            }
            return this.withTemporarySessionIfNeeded(() -> {
                CollectionEntry entry = this.session.getPersistenceContextInternal().getCollectionEntry(this);
                if (entry != null) {
                    CollectionPersister persister = entry.getLoadedPersister();
                    AbstractPersistentCollection.checkPersister(this, persister);
                    if (persister.isExtraLazy()) {
                        if (this.hasQueuedOperations()) {
                            this.session.flush();
                        }
                        this.cachedSize = persister.getSize(entry.getLoadedKey(), this.session);
                        return true;
                    }
                    this.read();
                } else {
                    this.throwLazyInitializationExceptionIfNotConnected();
                }
                return false;
            });
        }
        return false;
    }

    @Override
    public int getSize() {
        if (this.cachedSize >= 0) {
            return this.cachedSize;
        }
        CollectionEntry entry = this.session.getPersistenceContextInternal().getCollectionEntry(this);
        if (entry == null) {
            this.throwLazyInitializationExceptionIfNotConnected();
            this.throwLazyInitializationException("collection not associated with session");
            throw new AssertionFailure("impossible");
        }
        if (this.hasQueuedOperations()) {
            this.session.flush();
        }
        this.cachedSize = entry.getLoadedPersister().getSize(entry.getLoadedKey(), this.session);
        return this.cachedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withTemporarySessionIfNeeded(LazyInitializationWork<T> lazyInitializationWork) {
        SharedSessionContractImplementor tempSession = null;
        if (this.session == null) {
            if (this.allowLoadOutsideTransaction) {
                tempSession = this.openTemporarySessionForLoading();
            } else {
                this.throwLazyInitializationException("no session");
            }
        } else if (!this.session.isOpenOrWaitingForAutoClose()) {
            if (this.allowLoadOutsideTransaction) {
                tempSession = this.openTemporarySessionForLoading();
            } else {
                this.throwLazyInitializationException("the owning session was closed");
            }
        } else if (!this.session.isConnected()) {
            if (this.allowLoadOutsideTransaction) {
                tempSession = this.openTemporarySessionForLoading();
            } else {
                this.throwLazyInitializationException("the owning session is disconnected");
            }
        }
        SharedSessionContractImplementor originalSession = null;
        boolean isJTA = false;
        try {
            if (tempSession != null) {
                this.isTempSession = true;
                originalSession = this.session;
                this.session = tempSession;
                isJTA = this.session.getTransactionCoordinator().getTransactionCoordinatorBuilder().isJta();
                if (!isJTA) {
                    this.session.beginTransaction();
                }
                CollectionPersister collectionDescriptor = this.session.getSessionFactory().getMappingMetamodel().getCollectionDescriptor(this.getRole());
                this.session.getPersistenceContextInternal().addUninitializedDetachedCollection(collectionDescriptor, this);
            }
            T t = lazyInitializationWork.doWork();
            return t;
        }
        finally {
            if (tempSession != null) {
                this.isTempSession = false;
                this.session = originalSession;
                try {
                    if (!isJTA) {
                        tempSession.getTransaction().commit();
                    }
                    tempSession.close();
                }
                catch (Exception e) {
                    LOG.unableToCloseTemporarySession();
                }
            } else if (!this.session.isTransactionInProgress() && !this.unfinishedLoading()) {
                this.session.getJdbcCoordinator().afterTransaction();
            }
        }
    }

    private boolean unfinishedLoading() {
        PersistenceContext persistenceContext = this.session.getPersistenceContext();
        return persistenceContext.hasLoadContext() && !persistenceContext.getLoadContexts().isLoadingFinished();
    }

    private SharedSessionContractImplementor openTemporarySessionForLoading() {
        if (this.sessionFactoryUuid == null) {
            this.throwLazyInitializationException("SessionFactory UUID not known; cannot create temporary session for loading");
        }
        SessionImplementor session = SessionFactoryRegistry.INSTANCE.getSessionFactory(this.sessionFactoryUuid).openSession();
        session.getPersistenceContextInternal().setDefaultReadOnly(true);
        session.setHibernateFlushMode(FlushMode.MANUAL);
        return session;
    }

    protected Boolean readIndexExistence(Object index) {
        if (!this.initialized) {
            return this.withTemporarySessionIfNeeded(() -> {
                CollectionEntry entry = this.session.getPersistenceContextInternal().getCollectionEntry(this);
                CollectionPersister persister = entry.getLoadedPersister();
                AbstractPersistentCollection.checkPersister(this, persister);
                if (persister.isExtraLazy()) {
                    if (this.hasQueuedOperations()) {
                        this.session.flush();
                    }
                    return persister.indexExists(entry.getLoadedKey(), index, this.session);
                }
                this.read();
                return null;
            });
        }
        return null;
    }

    protected Boolean readElementExistence(Object element) {
        if (!this.initialized) {
            return this.withTemporarySessionIfNeeded(() -> {
                CollectionEntry entry = this.session.getPersistenceContextInternal().getCollectionEntry(this);
                CollectionPersister persister = entry.getLoadedPersister();
                AbstractPersistentCollection.checkPersister(this, persister);
                if (persister.isExtraLazy()) {
                    if (this.hasQueuedOperations()) {
                        this.session.flush();
                    }
                    return persister.elementExists(entry.getLoadedKey(), element, this.session);
                }
                this.read();
                return null;
            });
        }
        return null;
    }

    @Override
    public boolean elementExists(Object element) {
        CollectionEntry entry = this.session.getPersistenceContextInternal().getCollectionEntry(this);
        if (entry == null) {
            this.throwLazyInitializationExceptionIfNotConnected();
            this.throwLazyInitializationException("collection not associated with session");
            throw new AssertionFailure("impossible");
        }
        if (this.hasQueuedOperations()) {
            this.session.flush();
        }
        return entry.getLoadedPersister().elementExists(entry.getLoadedKey(), element, this.session);
    }

    protected Object readElementByIndex(final Object index) {
        if (!this.initialized) {
            class ExtraLazyElementByIndexReader
            implements LazyInitializationWork<Object> {
                private boolean isExtraLazy;
                private Object element;

                ExtraLazyElementByIndexReader() {
                }

                @Override
                public Object doWork() {
                    CollectionEntry entry = AbstractPersistentCollection.this.session.getPersistenceContextInternal().getCollectionEntry(AbstractPersistentCollection.this);
                    CollectionPersister persister = entry.getLoadedPersister();
                    AbstractPersistentCollection.checkPersister(AbstractPersistentCollection.this, persister);
                    this.isExtraLazy = persister.isExtraLazy();
                    if (this.isExtraLazy) {
                        if (AbstractPersistentCollection.this.hasQueuedOperations()) {
                            AbstractPersistentCollection.this.session.flush();
                        }
                        this.element = persister.getElementByIndex(entry.getLoadedKey(), index, AbstractPersistentCollection.this.session, AbstractPersistentCollection.this.owner);
                    } else {
                        AbstractPersistentCollection.this.read();
                    }
                    return null;
                }
            }
            ExtraLazyElementByIndexReader reader = new ExtraLazyElementByIndexReader();
            this.withTemporarySessionIfNeeded(reader);
            if (reader.isExtraLazy) {
                return reader.element;
            }
        }
        return UNKNOWN;
    }

    @Override
    public Object elementByIndex(Object index) {
        CollectionEntry entry = this.session.getPersistenceContextInternal().getCollectionEntry(this);
        if (entry == null) {
            this.throwLazyInitializationExceptionIfNotConnected();
            this.throwLazyInitializationException("collection not associated with session");
            throw new AssertionFailure("impossible");
        }
        if (this.hasQueuedOperations()) {
            this.session.flush();
        }
        return entry.getLoadedPersister().getElementByIndex(entry.getLoadedKey(), index, this.session, this.owner);
    }

    protected int getCachedSize() {
        return this.cachedSize;
    }

    protected boolean isConnectedToSession() {
        return this.session != null && this.session.isOpen() && this.session.getPersistenceContextInternal().containsCollection(this);
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected final void write() {
        this.initialize(true);
        this.dirty();
    }

    protected boolean isOperationQueueEnabled() {
        return !this.initialized && this.isConnectedToSession() && this.isInverseCollection();
    }

    protected boolean isPutQueueEnabled() {
        return !this.initialized && this.isConnectedToSession() && this.isInverseOneToManyOrNoOrphanDelete();
    }

    protected boolean isClearQueueEnabled() {
        return !this.initialized && this.isConnectedToSession() && this.isInverseCollectionNoOrphanDelete();
    }

    protected boolean isInverseCollection() {
        CollectionEntry ce = this.session.getPersistenceContextInternal().getCollectionEntry(this);
        return ce != null && ce.getLoadedPersister().isInverse();
    }

    protected boolean isInverseCollectionNoOrphanDelete() {
        CollectionEntry ce = this.session.getPersistenceContextInternal().getCollectionEntry(this);
        if (ce == null) {
            return false;
        }
        CollectionPersister loadedPersister = ce.getLoadedPersister();
        return loadedPersister.isInverse() && !loadedPersister.hasOrphanDelete();
    }

    protected boolean isInverseOneToManyOrNoOrphanDelete() {
        CollectionEntry ce = this.session.getPersistenceContextInternal().getCollectionEntry(this);
        if (ce == null) {
            return false;
        }
        CollectionPersister loadedPersister = ce.getLoadedPersister();
        return loadedPersister.isInverse() && (loadedPersister.isOneToMany() || !loadedPersister.hasOrphanDelete());
    }

    protected final void queueOperation(DelayedOperation<E> operation) {
        if (this.operationQueue == null) {
            this.operationQueue = new ArrayList<DelayedOperation<E>>(10);
        }
        this.operationQueue.add(operation);
        this.dirty = true;
    }

    public final void replaceQueuedOperationValues(CollectionPersister persister, Map<Object, Object> copyCache) {
        for (DelayedOperation<E> operation : this.operationQueue) {
            if (!(operation instanceof ValueDelayedOperation)) continue;
            ValueDelayedOperation valueDelayedOperation = (ValueDelayedOperation)operation;
            valueDelayedOperation.replace(persister, copyCache);
        }
    }

    protected final void performQueuedOperations() {
        for (DelayedOperation<E> operation : this.operationQueue) {
            operation.operate();
        }
        this.clearOperationQueue();
    }

    @Override
    public void setSnapshot(Object key, String role, Serializable snapshot) {
        this.key = key;
        this.role = role;
        this.storedSnapshot = snapshot;
    }

    @Override
    public void postAction() {
        this.clearOperationQueue();
        this.cachedSize = -1;
        this.clearDirty();
    }

    public final void clearOperationQueue() {
        this.operationQueue = null;
    }

    @Override
    public Object getValue() {
        return this;
    }

    @Override
    public void beginRead() {
        this.initializing = true;
    }

    @Override
    public boolean endRead() {
        return this.afterInitialize();
    }

    @Override
    public void beforeInitialize(CollectionPersister persister, int anticipatedSize) {
    }

    @Override
    public boolean afterInitialize() {
        this.setInitialized();
        if (this.hasQueuedOperations()) {
            this.performQueuedOperations();
            this.cachedSize = -1;
            return false;
        }
        return true;
    }

    protected final void initialize(boolean writing) {
        if (!this.initialized) {
            this.withTemporarySessionIfNeeded(() -> {
                this.session.initializeCollection(this, writing);
                return null;
            });
        }
    }

    private void throwLazyInitializationExceptionIfNotConnected() {
        if (!this.isConnectedToSession()) {
            this.throwLazyInitializationException("no session or session was closed");
        }
        if (!this.session.isConnected()) {
            this.throwLazyInitializationException("session is disconnected");
        }
    }

    private void throwLazyInitializationException(String message) {
        AbstractPersistentCollection.throwLazyInitializationException(this.role, message);
    }

    private static void throwLazyInitializationException(String role, String message) {
        throw new LazyInitializationException(String.format("Cannot lazily initialize collection%s (%s)", role == null ? "" : " of role '" + role + "'", message));
    }

    public static void checkPersister(PersistentCollection collection, CollectionPersister persister) {
        if (!collection.wasInitialized() && persister == null) {
            AbstractPersistentCollection.throwLazyInitializationException(null, "collection is being removed");
        }
    }

    protected final void setInitialized() {
        this.initializing = false;
        this.initialized = true;
    }

    @Override
    public boolean isInitializing() {
        return this.initializing;
    }

    protected final void setDirectlyAccessible(boolean directlyAccessible) {
        this.directlyAccessible = directlyAccessible;
    }

    @Override
    public boolean isDirectlyAccessible() {
        return this.directlyAccessible;
    }

    @Override
    public final boolean unsetSession(SharedSessionContractImplementor currentSession) {
        this.prepareForPossibleLoadingOutsideTransaction();
        if (currentSession == this.session) {
            if (!this.isTempSession) {
                if (this.hasQueuedOperations()) {
                    this.logDiscardedQueuedOperations();
                }
                if (this.allowLoadOutsideTransaction && !this.initialized && this.session.getLoadQueryInfluencers().hasEnabledFilters()) {
                    LOG.enabledFiltersWhenDetachFromSession(MessageHelper.collectionInfoString(this.getRole(), this.getKey()));
                }
                this.session = null;
            }
            return true;
        }
        if (this.session != null) {
            LOG.logCannotUnsetUnexpectedSessionInCollection(this.unexpectedSessionStateMessage(currentSession));
        }
        return false;
    }

    private void logDiscardedQueuedOperations() {
        try {
            if (this.wasTransactionRolledBack()) {
                if (LOG.isDebugEnabled()) {
                    LOG.queuedOperationWhenDetachFromSessionOnRollback(MessageHelper.collectionInfoString(this.getRole(), this.getKey()));
                }
            } else {
                LOG.queuedOperationWhenDetachFromSession(MessageHelper.collectionInfoString(this.getRole(), this.getKey()));
            }
        }
        catch (Exception e) {
            LOG.queuedOperationWhenDetachFromSession(MessageHelper.collectionInfoString(this.getRole(), this.getKey()));
        }
    }

    private boolean wasTransactionRolledBack() {
        TransactionStatus status = this.session.getTransactionCoordinator().getTransactionDriverControl().getStatus();
        return status.isOneOf(TransactionStatus.ROLLED_BACK, TransactionStatus.MARKED_ROLLBACK, TransactionStatus.FAILED_COMMIT, TransactionStatus.FAILED_ROLLBACK, TransactionStatus.ROLLING_BACK);
    }

    protected void prepareForPossibleLoadingOutsideTransaction() {
        if (this.session != null) {
            this.allowLoadOutsideTransaction = this.session.getFactory().getSessionFactoryOptions().isInitializeLazyStateOutsideTransactionsEnabled();
            if (this.allowLoadOutsideTransaction && this.sessionFactoryUuid == null) {
                this.sessionFactoryUuid = this.session.getFactory().getUuid();
            }
        }
    }

    @Override
    public final boolean setCurrentSession(SharedSessionContractImplementor session) throws HibernateException {
        if (session == this.session) {
            return false;
        }
        if (this.session != null) {
            String msg = this.unexpectedSessionStateMessage(session);
            if (this.isConnectedToSession()) {
                throw new HibernateException("Illegal attempt to associate a collection with two open sessions: " + msg);
            }
            LOG.logUnexpectedSessionInCollectionNotConnected(msg);
        }
        if (this.hasQueuedOperations()) {
            LOG.queuedOperationWhenAttachToSession(MessageHelper.collectionInfoString(this.getRole(), this.getKey()));
        }
        this.session = session;
        return true;
    }

    private String unexpectedSessionStateMessage(SharedSessionContractImplementor session) {
        String roleCurrent = this.role;
        Object keyCurrent = this.key;
        StringBuilder message = new StringBuilder("Collection : ");
        if (roleCurrent != null) {
            message.append(MessageHelper.collectionInfoString(roleCurrent, keyCurrent));
        } else {
            CollectionEntry ce = session.getPersistenceContextInternal().getCollectionEntry(this);
            if (ce != null) {
                message.append(MessageHelper.collectionInfoString(ce.getLoadedPersister(), this, ce.getLoadedKey(), session));
            } else {
                message.append("<unknown>");
            }
        }
        if (LOG.isDebugEnabled()) {
            String collectionContents = this.wasInitialized() ? this.toString() : "<uninitialized>";
            message.append("\nCollection contents: [").append(collectionContents).append("]");
        }
        return message.toString();
    }

    @Override
    public boolean needsRecreate(CollectionPersister persister) {
        CompositeType compositeType;
        Type whereType = persister.hasIndex() ? persister.getIndexType() : persister.getElementType();
        return whereType instanceof CompositeType && (compositeType = (CompositeType)whereType).hasNullProperty();
    }

    @Override
    public final void forceInitialization() throws HibernateException {
        if (!this.initialized) {
            if (this.initializing) {
                throw new AssertionFailure("force initializing collection loading");
            }
            this.initialize(false);
        }
    }

    protected final Serializable getSnapshot() {
        return this.session.getPersistenceContext().getSnapshot(this);
    }

    @Override
    public final boolean wasInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isRowUpdatePossible() {
        return true;
    }

    @Override
    public final boolean hasQueuedOperations() {
        return this.operationQueue != null;
    }

    @Override
    public final Iterator<?> queuedAdditionIterator() {
        if (this.hasQueuedOperations()) {
            return new Iterator<Object>(){
                private int index;

                @Override
                public Object next() {
                    return AbstractPersistentCollection.this.operationQueue.get(this.index++).getAddedEntry();
                }

                @Override
                public boolean hasNext() {
                    return this.index < AbstractPersistentCollection.this.operationQueue.size();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return Collections.emptyIterator();
    }

    @Override
    public final Collection<E> getQueuedOrphans(String entityName) {
        if (this.hasQueuedOperations()) {
            ArrayList<E> additions = new ArrayList<E>(this.operationQueue.size());
            ArrayList<E> removals = new ArrayList<E>(this.operationQueue.size());
            for (DelayedOperation<E> operation : this.operationQueue) {
                additions.add(operation.getAddedInstance());
                removals.add(operation.getOrphan());
            }
            return AbstractPersistentCollection.getOrphans(removals, additions, entityName, this.session);
        }
        return Collections.emptyList();
    }

    @Override
    public void preInsert(CollectionPersister persister) throws HibernateException {
    }

    @Override
    public void afterRowInsert(CollectionPersister persister, Object entry, int i) throws HibernateException {
    }

    @Override
    public abstract Collection<E> getOrphans(Serializable var1, String var2) throws HibernateException;

    @Override
    public final SharedSessionContractImplementor getSession() {
        return this.session;
    }

    protected static <E> Collection<E> getOrphans(Collection<E> oldElements, Collection<E> currentElements, String entityName, SharedSessionContractImplementor session) throws HibernateException {
        if (currentElements.isEmpty()) {
            return oldElements;
        }
        if (oldElements.isEmpty()) {
            return oldElements;
        }
        Type idType = session.getFactory().getMappingMetamodel().getEntityDescriptor(entityName).getIdentifierType();
        boolean useIdDirect = AbstractPersistentCollection.mayUseIdDirect(idType);
        ArrayList<E> res = new ArrayList<E>();
        HashSet<Object> currentIds = new HashSet<Object>();
        IdentitySet<E> currentSaving = new IdentitySet<E>();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        for (E current : currentElements) {
            if (current == null || !ForeignKeys.isNotTransient(entityName, current, null, session)) continue;
            EntityEntry ee = persistenceContext.getEntry(current);
            if (ee != null && ee.getStatus() == Status.SAVING) {
                currentSaving.add(current);
                continue;
            }
            Object currentId = ForeignKeys.getEntityIdentifierIfNotUnsaved(entityName, current, session);
            currentIds.add(useIdDirect ? currentId : new TypedValue(idType, currentId));
        }
        for (E old : oldElements) {
            Object oldId;
            if (currentSaving.contains(old) || (oldId = ForeignKeys.getEntityIdentifier(entityName, old, session)) == null || currentIds.contains(useIdDirect ? oldId : new TypedValue(idType, oldId))) continue;
            res.add(old);
        }
        return res;
    }

    private static boolean mayUseIdDirect(Type idType) {
        if (idType instanceof BasicType) {
            BasicType basicType = (BasicType)idType;
            Class javaType = basicType.getJavaType();
            return javaType == String.class || javaType == Integer.class || javaType == Long.class || javaType == UUID.class;
        }
        return false;
    }

    public static void identityRemove(Collection<?> list, Object entityInstance, String entityName, SharedSessionContractImplementor session) {
        if (entityInstance != null && ForeignKeys.isNotTransient(entityName, entityInstance, null, session)) {
            EntityIdentifierMapping identifierMapping = session.getFactory().getMappingMetamodel().getEntityDescriptor(entityName).getIdentifierMapping();
            Object idOfCurrent = ForeignKeys.getEntityIdentifierIfNotUnsaved(entityName, entityInstance, session);
            Iterator<?> itr = list.iterator();
            while (itr.hasNext()) {
                Object idOfOld = ForeignKeys.getEntityIdentifierIfNotUnsaved(entityName, itr.next(), session);
                if (!identifierMapping.areEqual(idOfCurrent, idOfOld, session)) continue;
                itr.remove();
                break;
            }
        }
    }

    @Override
    public Object getIdentifier(Object entry, int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable Object getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Object owner) {
        this.owner = owner;
    }

    @Override
    public int $$_hibernate_getInstanceId() {
        return this.instanceId;
    }

    @Override
    public void $$_hibernate_setInstanceId(int instanceId) {
        this.instanceId = instanceId;
    }

    public static interface LazyInitializationWork<T> {
        public T doWork();
    }

    protected static interface DelayedOperation<E> {
        public void operate();

        public E getAddedInstance();

        default public Object getAddedEntry() {
            return this.getAddedInstance();
        }

        public E getOrphan();
    }

    protected static interface ValueDelayedOperation<E>
    extends DelayedOperation<E> {
        public void replace(CollectionPersister var1, Map<Object, Object> var2);
    }

    protected abstract class AbstractValueDelayedOperation
    implements ValueDelayedOperation<E> {
        private E addedValue;
        private final E orphan;

        protected AbstractValueDelayedOperation(E addedValue, E orphan) {
            this.addedValue = addedValue;
            this.orphan = orphan;
        }

        @Override
        public void replace(CollectionPersister persister, Map<Object, Object> copyCache) {
            if (this.addedValue != null) {
                this.addedValue = this.getReplacement(persister.getElementType(), this.addedValue, copyCache);
            }
        }

        protected final E getReplacement(Type type, Object current, Map<Object, Object> copyCache) {
            return type.replace(current, null, AbstractPersistentCollection.this.session, AbstractPersistentCollection.this.owner, copyCache);
        }

        @Override
        public final E getAddedInstance() {
            return this.addedValue;
        }

        @Override
        public final E getOrphan() {
            return this.orphan;
        }
    }

    protected final class ListProxy
    implements List<E> {
        private final List<E> list;

        public ListProxy(List<E> list) {
            this.list = list;
        }

        @Override
        public void add(int index, E value) {
            AbstractPersistentCollection.this.write();
            this.list.add(index, value);
        }

        @Override
        public boolean add(E o) {
            AbstractPersistentCollection.this.write();
            return this.list.add(o);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            AbstractPersistentCollection.this.write();
            return this.list.addAll(c);
        }

        @Override
        public boolean addAll(int i, Collection<? extends E> c) {
            AbstractPersistentCollection.this.write();
            return this.list.addAll(i, c);
        }

        @Override
        public void clear() {
            AbstractPersistentCollection.this.write();
            this.list.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.list.containsAll(c);
        }

        @Override
        public E get(int i) {
            return this.list.get(i);
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return new IteratorProxy(this.list.iterator());
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public ListIterator<E> listIterator() {
            return new ListIteratorProxy(this.list.listIterator());
        }

        @Override
        public ListIterator<E> listIterator(int i) {
            return new ListIteratorProxy(this.list.listIterator(i));
        }

        @Override
        public E remove(int i) {
            AbstractPersistentCollection.this.write();
            return this.list.remove(i);
        }

        @Override
        public boolean remove(Object o) {
            AbstractPersistentCollection.this.write();
            return this.list.remove(o);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            AbstractPersistentCollection.this.write();
            return this.list.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            AbstractPersistentCollection.this.write();
            return this.list.retainAll(c);
        }

        @Override
        public E set(int i, E o) {
            AbstractPersistentCollection.this.write();
            return this.list.set(i, o);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public List<E> subList(int i, int j) {
            return this.list.subList(i, j);
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public <A> A[] toArray(A[] array) {
            return this.list.toArray(array);
        }

        @Override
        public final boolean equals(Object o) {
            return o == this || this.list.equals(o);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.list);
        }
    }

    protected class SetProxy<E>
    implements Set<E> {
        protected final Collection<E> set;

        public SetProxy(Collection<E> set) {
            this.set = set;
        }

        @Override
        public boolean add(E o) {
            AbstractPersistentCollection.this.write();
            return this.set.add(o);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            AbstractPersistentCollection.this.write();
            return this.set.addAll(c);
        }

        @Override
        public void clear() {
            AbstractPersistentCollection.this.write();
            this.set.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.set.containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return new IteratorProxy<E>(this.set.iterator());
        }

        @Override
        public boolean remove(Object o) {
            AbstractPersistentCollection.this.write();
            return this.set.remove(o);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            AbstractPersistentCollection.this.write();
            return this.set.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            AbstractPersistentCollection.this.write();
            return this.set.retainAll(c);
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public Object[] toArray() {
            return this.set.toArray();
        }

        @Override
        public <A> A[] toArray(A[] array) {
            return this.set.toArray(array);
        }

        @Override
        public final boolean equals(Object object) {
            Set that;
            return object == this || object instanceof Set && (that = (Set)object).size() == this.size() && this.containsAll(that);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.set);
        }
    }

    protected final class ListIteratorProxy
    implements ListIterator<E> {
        private final ListIterator<E> itr;

        public ListIteratorProxy(ListIterator<E> itr) {
            this.itr = itr;
        }

        @Override
        public void add(E o) {
            AbstractPersistentCollection.this.write();
            this.itr.add(o);
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.itr.hasPrevious();
        }

        @Override
        public E next() {
            return this.itr.next();
        }

        @Override
        public int nextIndex() {
            return this.itr.nextIndex();
        }

        @Override
        public E previous() {
            return this.itr.previous();
        }

        @Override
        public int previousIndex() {
            return this.itr.previousIndex();
        }

        @Override
        public void remove() {
            AbstractPersistentCollection.this.write();
            this.itr.remove();
        }

        @Override
        public void set(E o) {
            AbstractPersistentCollection.this.write();
            this.itr.set(o);
        }
    }

    protected final class IteratorProxy<E>
    implements Iterator<E> {
        private final Iterator<E> itr;

        public IteratorProxy(Iterator<E> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public E next() {
            return this.itr.next();
        }

        @Override
        public void remove() {
            AbstractPersistentCollection.this.write();
            this.itr.remove();
        }
    }
}

