/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamResponseListener
implements Response.Listener,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(InputStreamResponseListener.class);
    private static final ChunkCallback EOF = new ChunkCallback(Content.Chunk.EOF, () -> {}, x -> {});
    private final AutoLock.WithCondition lock = new AutoLock.WithCondition();
    private final CountDownLatch responseLatch = new CountDownLatch(1);
    private final CountDownLatch resultLatch = new CountDownLatch(1);
    private final Queue<ChunkCallback> chunkCallbacks = new ArrayDeque<ChunkCallback>();
    private InputStream stream;
    private Response response;
    private Result result;
    private Throwable failure;
    private boolean closed;

    @Override
    public void onHeaders(Response response) {
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            this.response = response;
            this.responseLatch.countDown();
        }
    }

    @Override
    public void onContent(Response response, Content.Chunk chunk, Runnable demander) {
        boolean closed;
        boolean hasContent = chunk.hasRemaining();
        try (AutoLock.WithCondition l = this.lock.lock();){
            closed = this.closed;
            if (!closed && hasContent) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Queueing chunk {}", (Object)chunk);
                }
                chunk.retain();
                this.chunkCallbacks.add(new ChunkCallback(chunk, demander, response::abort));
                l.signalAll();
                return;
            }
        }
        if (closed) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("InputStream closed, dropped chunk {}", (Object)chunk);
            }
            response.abort(new AsynchronousCloseException());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipped empty chunk {}", (Object)chunk);
            }
            demander.run();
        }
    }

    @Override
    public void onSuccess(Response response) {
        try (AutoLock.WithCondition l = this.lock.lock();){
            if (!this.closed) {
                this.chunkCallbacks.add(EOF);
            }
            l.signalAll();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("End of content");
        }
    }

    @Override
    public void onFailure(Response response, Throwable failure) {
        List<ChunkCallback> chunkCallbacks;
        try (AutoLock.WithCondition l = this.lock.lock();){
            if (this.failure != null) {
                return;
            }
            this.failure = failure;
            chunkCallbacks = this.drain();
            l.signalAll();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Content failure", failure);
        }
        chunkCallbacks.forEach(chunkCallback -> chunkCallback.releaseAndFail(failure));
    }

    @Override
    public void onComplete(Result result) {
        Throwable failure = result.getFailure();
        List<Object> chunkCallbacks = Collections.emptyList();
        try (AutoLock.WithCondition l = this.lock.lock();){
            this.result = result;
            if (result.isFailed() && this.failure == null) {
                this.failure = failure;
                chunkCallbacks = this.drain();
            }
            this.responseLatch.countDown();
            this.resultLatch.countDown();
            l.signalAll();
        }
        if (LOG.isDebugEnabled()) {
            if (failure == null) {
                LOG.debug("Result success");
            } else {
                LOG.debug("Result failure", failure);
            }
        }
        chunkCallbacks.forEach(t -> t.releaseAndFail(failure));
    }

    public Response get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        boolean expired;
        boolean bl = expired = !this.responseLatch.await(timeout, unit);
        if (expired) {
            throw new TimeoutException();
        }
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            if (this.response == null) {
                throw new ExecutionException(this.failure);
            }
            Response response = this.response;
            return response;
        }
    }

    public Result await(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        boolean expired;
        boolean bl = expired = !this.resultLatch.await(timeout, unit);
        if (expired) {
            throw new TimeoutException();
        }
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            Result result = this.result;
            return result;
        }
    }

    public InputStream getInputStream() {
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            if (this.stream == null && !this.closed) {
                this.stream = new Input();
                Input input = this.stream;
                return input;
            }
            InputStream result = InputStream.nullInputStream();
            IO.close((InputStream)result);
            InputStream inputStream = result;
            return inputStream;
        }
    }

    private List<ChunkCallback> drain() {
        ArrayList<ChunkCallback> failures = new ArrayList<ChunkCallback>();
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            ChunkCallback chunkCallback;
            while ((chunkCallback = this.chunkCallbacks.peek()) != null) {
                if (chunkCallback == EOF) {
                    break;
                }
                failures.add(chunkCallback);
                this.chunkCallbacks.poll();
            }
        }
        return failures;
    }

    @Override
    public void close() throws IOException {
        List<ChunkCallback> chunkCallbacks;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closing {}", (Object)this);
        }
        try (AutoLock.WithCondition l = this.lock.lock();){
            if (this.closed) {
                return;
            }
            this.closed = true;
            chunkCallbacks = this.drain();
            l.signalAll();
        }
        if (!chunkCallbacks.isEmpty()) {
            AsynchronousCloseException failure = new AsynchronousCloseException();
            chunkCallbacks.forEach(t -> t.releaseAndFail(failure));
        }
    }

    private record ChunkCallback(Content.Chunk chunk, Runnable success, Consumer<Throwable> throwableConsumer) {
        private void releaseAndSucceed() {
            this.chunk.release();
            this.success.run();
        }

        private void releaseAndFail(Throwable x) {
            this.chunk.release();
            this.throwableConsumer.accept(x);
        }
    }

    private class Input
    extends InputStream {
        private Input() {
        }

        @Override
        public int read() throws IOException {
            byte[] tmp = new byte[1];
            int read = this.read(tmp);
            if (read < 0) {
                return read;
            }
            return tmp[0] & 0xFF;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read(byte[] b, int offset, int length) throws IOException {
            try {
                int result;
                ChunkCallback chunkCallback;
                block16: {
                    try (AutoLock.WithCondition l = InputStreamResponseListener.this.lock.lock();){
                        block15: {
                            while (true) {
                                if ((chunkCallback = InputStreamResponseListener.this.chunkCallbacks.peek()) == EOF) {
                                    int n = -1;
                                    return n;
                                }
                                if (chunkCallback != null) {
                                    ByteBuffer buffer = chunkCallback.chunk().getByteBuffer();
                                    result = Math.min(buffer.remaining(), length);
                                    buffer.get(b, offset, result);
                                    if (!buffer.hasRemaining()) {
                                        break;
                                    }
                                    break block15;
                                }
                                if (InputStreamResponseListener.this.failure != null) {
                                    throw IO.rethrow((Throwable)InputStreamResponseListener.this.failure);
                                }
                                if (InputStreamResponseListener.this.closed) {
                                    throw new AsynchronousCloseException();
                                }
                                l.await();
                            }
                            InputStreamResponseListener.this.chunkCallbacks.poll();
                            break block16;
                        }
                        chunkCallback = null;
                    }
                }
                if (chunkCallback == null) return result;
                chunkCallback.releaseAndSucceed();
                return result;
            }
            catch (InterruptedException x) {
                throw new InterruptedIOException();
            }
        }

        @Override
        public void close() throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing {}", (Object)this);
            }
            InputStreamResponseListener.this.close();
            super.close();
        }
    }
}

