/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.exec;

import com.google.common.annotations.VisibleForTesting;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.util.NumberUtil;
import org.gradle.launcher.daemon.server.api.DaemonCommandAction;
import org.gradle.launcher.daemon.server.api.DaemonCommandExecution;
import org.gradle.launcher.daemon.server.health.DaemonHealthCheck;
import org.gradle.launcher.daemon.server.health.DaemonHealthStats;
import org.gradle.launcher.daemon.server.stats.DaemonRunningStats;

public class LogAndCheckHealth
implements DaemonCommandAction {
    public static final String HEALTH_MESSAGE_PROPERTY = "org.gradle.daemon.performance.logging";
    private final DaemonHealthStats stats;
    private final DaemonHealthCheck healthCheck;
    private final DaemonRunningStats runningStats;
    private final Logger logger;

    public LogAndCheckHealth(DaemonHealthStats stats, DaemonHealthCheck healthCheck, DaemonRunningStats runningStats) {
        this(stats, healthCheck, runningStats, Logging.getLogger(LogAndCheckHealth.class));
    }

    @VisibleForTesting
    LogAndCheckHealth(DaemonHealthStats stats, DaemonHealthCheck healthCheck, DaemonRunningStats runningStats, Logger logger) {
        this.stats = stats;
        this.healthCheck = healthCheck;
        this.runningStats = runningStats;
        this.logger = logger;
    }

    @Override
    public void execute(DaemonCommandExecution execution) {
        if (execution.isSingleUseDaemon()) {
            execution.proceed();
            return;
        }
        if (Boolean.getBoolean(HEALTH_MESSAGE_PROPERTY)) {
            this.logger.lifecycle(this.getStartBuildMessage());
        } else {
            this.logger.info(this.getStartBuildMessage());
        }
        execution.proceed();
        this.healthCheck.executeHealthCheck();
    }

    private String getStartBuildMessage() {
        int nextBuildNum = this.runningStats.getBuildCount() + 1;
        if (nextBuildNum == 1) {
            return String.format("Starting build in new daemon [memory: %s]", NumberUtil.formatBytes((Long)Runtime.getRuntime().maxMemory()));
        }
        return String.format("Starting %s build in daemon %s", NumberUtil.ordinal((int)nextBuildNum), this.stats.getHealthInfo());
    }
}

