/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ContainerCheckedTreeViewer
extends CheckboxTreeViewer {
    public ContainerCheckedTreeViewer(Composite parent) {
        super(parent);
        this.initViewer();
    }

    public ContainerCheckedTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.initViewer();
    }

    public ContainerCheckedTreeViewer(Tree tree) {
        super(tree);
        this.initViewer();
    }

    private void initViewer() {
        this.setUseHashlookup(true);
        this.addCheckStateListener(event -> this.doCheckStateChanged(event.getElement()));
        this.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Widget item = ContainerCheckedTreeViewer.this.findItem(event.getElement());
                if (item instanceof TreeItem) {
                    ContainerCheckedTreeViewer.this.initializeItem((TreeItem)item);
                }
            }
        });
    }

    protected void doCheckStateChanged(Object element) {
        Widget item = this.findItem(element);
        if (item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)item;
            treeItem.setGrayed(false);
            this.updateChildrenItems(treeItem);
            this.updateParentItems(treeItem.getParentItem());
        }
    }

    private void doCheckStateChanged(Object[] elements) {
        HashSet<TreeItem> parents = new HashSet<TreeItem>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            Widget item = this.findItem(element);
            if (item instanceof TreeItem) {
                TreeItem treeItem = (TreeItem)item;
                treeItem.setGrayed(false);
                this.updateChildrenItems(treeItem);
                TreeItem parentItem = treeItem.getParentItem();
                if (parentItem != null) {
                    parents.add(parentItem);
                }
            }
            ++n2;
        }
        for (TreeItem parent : parents) {
            this.updateParentItems(parent);
        }
    }

    private void initializeItem(TreeItem item) {
        if (item.getChecked() && !item.getGrayed()) {
            this.updateChildrenItems(item);
        }
    }

    private void updateChildrenItems(TreeItem parent) {
        Item[] children = this.getChildren((Widget)parent);
        boolean state = parent.getChecked();
        Item[] itemArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Item element = itemArray[n2];
            TreeItem curr = (TreeItem)element;
            if (curr.getData() != null && (curr.getChecked() != state || curr.getGrayed())) {
                curr.setChecked(state);
                curr.setGrayed(false);
                this.updateChildrenItems(curr);
            }
            ++n2;
        }
    }

    private void updateParentItems(TreeItem item) {
        if (item != null) {
            boolean newGrayed;
            Item[] children = this.getChildren((Widget)item);
            boolean containsChecked = false;
            boolean containsUnchecked = false;
            Item[] itemArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Item element = itemArray[n2];
                TreeItem curr = (TreeItem)element;
                boolean currChecked = curr.getChecked();
                containsChecked |= currChecked;
                if (!containsUnchecked) {
                    boolean bl = containsUnchecked = !currChecked || curr.getGrayed();
                }
                if (containsChecked && containsUnchecked) break;
                ++n2;
            }
            boolean updated = false;
            boolean checked = item.getChecked();
            if (checked != containsChecked) {
                item.setChecked(containsChecked);
                updated = true;
            }
            boolean grayed = item.getGrayed();
            boolean bl = newGrayed = containsChecked && containsUnchecked;
            if (grayed != newGrayed) {
                item.setGrayed(newGrayed);
                updated = true;
            }
            if (updated) {
                this.updateParentItems(item.getParentItem());
            }
        }
    }

    public boolean setChecked(Object element, boolean state) {
        if (super.setChecked(element, state)) {
            this.doCheckStateChanged(element);
            return true;
        }
        return false;
    }

    public void setCheckedElements(Object[] elements) {
        Object[] oldCheckedElements = this.getCheckedElements();
        super.setCheckedElements(elements);
        Control tree = this.getControl();
        try {
            tree.setRedraw(false);
            if (oldCheckedElements.length > 0) {
                HashSet<Object> changedElements = new HashSet<Object>(Arrays.asList(elements));
                Object[] objectArray = oldCheckedElements;
                int n = oldCheckedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    changedElements.remove(element);
                    ++n2;
                }
                this.doCheckStateChanged(changedElements.toArray());
            } else {
                this.doCheckStateChanged(elements);
            }
        }
        finally {
            tree.setRedraw(true);
        }
    }

    public boolean setSubtreeChecked(Object element, boolean state) {
        if (super.setSubtreeChecked(element, state)) {
            this.doCheckStateChanged(element);
            return true;
        }
        return false;
    }

    protected void setExpanded(Item item, boolean expand) {
        super.setExpanded(item, expand);
        if (expand && item instanceof TreeItem) {
            this.initializeItem((TreeItem)item);
        }
    }

    public Object[] getCheckedElements() {
        Object[] checked = super.getCheckedElements();
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] objectArray = checked;
        int n = checked.length;
        int n2 = 0;
        while (n2 < n) {
            Item[] children;
            Object curr = objectArray[n2];
            result.add(curr);
            Widget item = this.findItem(curr);
            if (item != null && (children = this.getChildren(item)).length == 1 && children[0].getData() == null) {
                this.collectChildren(curr, result);
            }
            ++n2;
        }
        return result.toArray();
    }

    private void collectChildren(Object element, ArrayList<Object> result) {
        Object[] filteredChildren;
        Object[] objectArray = filteredChildren = this.getFilteredChildren(element);
        int n = filteredChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Object curr = objectArray[n2];
            result.add(curr);
            this.collectChildren(curr, result);
            ++n2;
        }
    }
}

