/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.undo.snapshot.IResourceSnapshot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.ide.undo.AbstractResourcesOperation;

public class DeleteResourcesOperation
extends AbstractResourcesOperation {
    private boolean deleteContent = false;

    public DeleteResourcesOperation(IResource[] resources, String label, boolean deleteContent) {
        super(resources, label);
        this.deleteContent = deleteContent;
    }

    @Override
    protected void doExecute(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        this.delete(monitor, uiInfo, this.deleteContent);
    }

    @Override
    protected void doUndo(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        this.recreate(monitor, uiInfo);
    }

    @Override
    protected boolean updateResourceChangeDescriptionFactory(IResourceChangeDescriptionFactory factory, int operation) {
        boolean modified = false;
        if (operation == UNDO) {
            IResourceSnapshot[] iResourceSnapshotArray = this.resourceDescriptions;
            int n = this.resourceDescriptions.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceSnapshot resourceDescription = iResourceSnapshotArray[n2];
                if (resourceDescription != null) {
                    IResource resource = resourceDescription.createResourceHandle();
                    factory.create(resource);
                    modified = true;
                }
                ++n2;
            }
        } else {
            IResource[] iResourceArray = this.resources;
            int n = this.resources.length;
            int n3 = 0;
            while (n3 < n) {
                IResource resource = iResourceArray[n3];
                factory.delete(resource);
                modified = true;
                ++n3;
            }
        }
        return modified;
    }

    @Override
    protected ISchedulingRule getExecuteSchedulingRule() {
        return super.computeDeleteSchedulingRule();
    }

    @Override
    protected ISchedulingRule getUndoSchedulingRule() {
        return super.computeCreateSchedulingRule();
    }

    @Override
    public IStatus computeExecutionStatus(IProgressMonitor monitor) {
        IStatus status = super.computeExecutionStatus(monitor);
        if (status.isOK()) {
            status = this.computeDeleteStatus();
        }
        return status;
    }

    @Override
    public IStatus computeUndoableStatus(IProgressMonitor monitor) {
        IStatus status = super.computeUndoableStatus(monitor);
        if (status.isOK()) {
            status = this.computeCreateStatus(false);
        }
        return status;
    }

    @Override
    public IStatus computeRedoableStatus(IProgressMonitor monitor) {
        IStatus status = super.computeRedoableStatus(monitor);
        if (status.isOK()) {
            status = this.computeDeleteStatus();
        }
        return status;
    }

    @Override
    protected void appendDescriptiveText(StringBuffer text) {
        super.appendDescriptiveText(text);
        text.append(" deleteContent: ");
        text.append(this.deleteContent);
        text.append('\'');
    }

    @Override
    IStatus checkReadOnlyResources(IResource[] resourcesToCheck) {
        if (!this.deleteContent) {
            ArrayList<IResource> nonProjectResourcesToCheck = new ArrayList<IResource>();
            IResource[] iResourceArray = resourcesToCheck;
            int n = resourcesToCheck.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getType() != 4) {
                    nonProjectResourcesToCheck.add(resource);
                }
                ++n2;
            }
            if (nonProjectResourcesToCheck.isEmpty()) {
                return Status.OK_STATUS;
            }
            return super.checkReadOnlyResources(nonProjectResourcesToCheck.toArray(new IResource[nonProjectResourcesToCheck.size()]));
        }
        return super.checkReadOnlyResources(resourcesToCheck);
    }
}

