/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.undo.snapshot.IMarkerSnapshot;
import org.eclipse.core.resources.undo.snapshot.ResourceSnapshotFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.ui.ide.undo.AbstractWorkspaceOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.undo.UndoMessages;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;

abstract class AbstractMarkersOperation
extends AbstractWorkspaceOperation {
    IMarkerSnapshot[] markerDescriptions;
    IMarker[] markers;
    Map<String, Object>[] attributes;

    AbstractMarkersOperation(IMarker[] markers, IMarkerSnapshot[] markerDescriptions, Map<String, Object> attributes, String name) {
        super(name);
        Map<String, Object> typedAttributes = attributes;
        this.markers = markers;
        this.attributes = null;
        if (attributes != null && markers != null) {
            if (markers.length > 1) {
                this.attributes = new Map[markers.length];
                int i = 0;
                while (i < markers.length) {
                    HashMap<String, Object> copiedAttributes = new HashMap<String, Object>();
                    copiedAttributes.putAll(typedAttributes);
                    this.attributes[i] = copiedAttributes;
                    ++i;
                }
            } else {
                this.attributes = new Map[]{typedAttributes};
            }
        }
        this.setMarkerDescriptions(markerDescriptions);
    }

    protected void deleteMarkers(int work, IProgressMonitor monitor) throws CoreException {
        if (this.markers == null || this.markers.length == 0) {
            monitor.worked(work);
            return;
        }
        int markerWork = work / this.markers.length;
        this.markerDescriptions = new IMarkerSnapshot[this.markers.length];
        int i = 0;
        while (i < this.markers.length) {
            this.markerDescriptions[i] = ResourceSnapshotFactory.fromMarker((IMarker)this.markers[i]);
            this.markers[i].delete();
            monitor.worked(markerWork);
            ++i;
        }
        this.markers = new IMarker[0];
    }

    protected void createMarkers(int work, IProgressMonitor monitor) throws CoreException {
        if (this.markerDescriptions == null || this.markerDescriptions.length == 0) {
            monitor.worked(work);
            return;
        }
        int markerWork = work / this.markerDescriptions.length;
        this.markers = new IMarker[this.markerDescriptions.length];
        int i = 0;
        while (i < this.markerDescriptions.length) {
            this.markers[i] = this.markerDescriptions[i].createMarker();
            monitor.worked(markerWork);
            ++i;
        }
    }

    protected void updateMarkers(int work, IProgressMonitor monitor, boolean mergeAttributes) throws CoreException {
        if (this.attributes == null || this.markers == null || this.attributes.length != this.markers.length || this.markers.length == 0) {
            monitor.worked(work);
            return;
        }
        int markerWork = work / this.markers.length;
        int i = 0;
        while (i < this.markers.length) {
            if (mergeAttributes) {
                oldAttributes = this.markers[i].getAttributes();
                int increment = markerWork / this.attributes[i].size();
                HashMap<String, Object> replacedAttributes = new HashMap<String, Object>();
                for (String key : this.attributes[i].keySet()) {
                    Object val = this.attributes[i].get(key);
                    this.markers[i].setAttribute(key, val);
                    replacedAttributes.put(key, oldAttributes.get(key));
                    monitor.worked(increment);
                }
                this.attributes[i] = replacedAttributes;
            } else {
                oldAttributes = this.markers[i].getAttributes();
                this.markers[i].setAttributes(this.attributes[i]);
                this.attributes[i] = oldAttributes;
            }
            ++i;
        }
    }

    protected void setMarkerDescriptions(IMarkerSnapshot[] descriptions) {
        this.markerDescriptions = descriptions;
        this.addUndoContexts();
        this.updateTargetResources();
    }

    private void updateTargetResources() {
        IResource[] newResources = null;
        if (this.markers == null) {
            if (this.markerDescriptions != null) {
                newResources = new IResource[this.markerDescriptions.length];
                int i = 0;
                while (i < this.markerDescriptions.length) {
                    newResources[i] = this.markerDescriptions[i].getResource();
                    ++i;
                }
            }
        } else {
            newResources = new IResource[this.markers.length];
            int i = 0;
            while (i < this.markers.length) {
                newResources[i] = this.markers[i].getResource();
                ++i;
            }
        }
        this.setTargetResources(newResources);
    }

    private void addUndoContexts() {
        String[] types = null;
        if (this.markers == null) {
            if (this.markerDescriptions != null) {
                types = new String[this.markerDescriptions.length];
                i = 0;
                while (i < this.markerDescriptions.length) {
                    types[i] = this.markerDescriptions[i].getType();
                    ++i;
                }
            }
        } else {
            types = new String[this.markers.length];
            i = 0;
            while (i < this.markers.length) {
                try {
                    types[i] = this.markers[i].getType();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                ++i;
            }
        }
        if (types != null) {
            MarkerType bookmarkType = MarkerTypesModel.getInstance().getType("org.eclipse.core.resources.bookmark");
            MarkerType taskType = MarkerTypesModel.getInstance().getType("org.eclipse.core.resources.taskmarker");
            MarkerType problemType = MarkerTypesModel.getInstance().getType("org.eclipse.core.resources.problemmarker");
            String[] stringArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String currentType = stringArray[n2];
                if (currentType != null) {
                    MarkerType type = MarkerTypesModel.getInstance().getType(currentType);
                    if (type == null) {
                        this.addContext(WorkspaceUndoUtil.getWorkspaceUndoContext());
                    } else if (type.isSubtypeOf(bookmarkType)) {
                        this.addContext(WorkspaceUndoUtil.getBookmarksUndoContext());
                    } else if (type.isSubtypeOf(taskType)) {
                        this.addContext(WorkspaceUndoUtil.getTasksUndoContext());
                    } else if (type.isSubtypeOf(problemType)) {
                        this.addContext(WorkspaceUndoUtil.getProblemsUndoContext());
                    } else {
                        this.addContext(WorkspaceUndoUtil.getWorkspaceUndoContext());
                    }
                }
                ++n2;
            }
        }
    }

    public IMarker[] getMarkers() {
        return this.markers;
    }

    protected boolean markersExist() {
        if (this.markers == null || this.markers.length == 0) {
            return false;
        }
        IMarker[] iMarkerArray = this.markers;
        int n = this.markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (!marker.exists()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected abstract IStatus getBasicUndoStatus();

    protected abstract IStatus getBasicRedoStatus();

    @Override
    public IStatus computeExecutionStatus(IProgressMonitor monitor) {
        IStatus status = this.getBasicRedoStatus();
        if (status.isOK()) {
            return super.computeExecutionStatus(monitor);
        }
        if (status.getSeverity() == 4) {
            this.markInvalid();
        }
        return status;
    }

    @Override
    public IStatus computeUndoableStatus(IProgressMonitor monitor) {
        IStatus status = this.getBasicUndoStatus();
        if (status.isOK()) {
            return super.computeUndoableStatus(monitor);
        }
        if (status.getSeverity() == 4) {
            this.markInvalid();
        }
        return status;
    }

    @Override
    public IStatus computeRedoableStatus(IProgressMonitor monitor) {
        IStatus status = this.getBasicRedoStatus();
        if (status.isOK()) {
            return super.computeRedoableStatus(monitor);
        }
        if (status.getSeverity() == 4) {
            this.markInvalid();
        }
        return status;
    }

    protected IStatus getMarkerDeletionStatus() {
        if (this.markersExist()) {
            return Status.OK_STATUS;
        }
        return this.getErrorStatus(UndoMessages.MarkerOperation_MarkerDoesNotExist);
    }

    protected IStatus getMarkerCreationStatus() {
        if (!this.resourcesExist()) {
            return this.getErrorStatus(UndoMessages.MarkerOperation_ResourceDoesNotExist);
        }
        if (this.markerDescriptions == null) {
            return this.getErrorStatus(UndoMessages.MarkerOperation_NotEnoughInfo);
        }
        return Status.OK_STATUS;
    }

    protected IStatus getMarkerUpdateStatus() {
        if (!this.markersExist()) {
            return this.getErrorStatus(UndoMessages.MarkerOperation_MarkerDoesNotExist);
        }
        if (this.attributes == null) {
            return this.getErrorStatus(UndoMessages.MarkerOperation_NotEnoughInfo);
        }
        return Status.OK_STATUS;
    }

    @Override
    protected ISchedulingRule getExecuteSchedulingRule() {
        ISchedulingRule[] ruleArray = new ISchedulingRule[this.resources.length];
        int i = 0;
        while (i < this.resources.length) {
            ruleArray[i] = this.getWorkspaceRuleFactory().markerRule(this.resources[i]);
            ++i;
        }
        return MultiRule.combine((ISchedulingRule[])ruleArray);
    }

    @Override
    protected ISchedulingRule getUndoSchedulingRule() {
        return this.getExecuteSchedulingRule();
    }

    @Override
    protected void appendDescriptiveText(StringBuffer text) {
        super.appendDescriptiveText(text);
        text.append(" markers: ");
        text.append(this.markers);
        text.append('\'');
        text.append(" markerDescriptions: ");
        text.append(this.markerDescriptions);
        text.append('\'');
        text.append(" attributes: ");
        text.append(this.attributes);
        text.append('\'');
    }
}

