/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film.filter_selection;

import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import mediathek.tool.FilterConfiguration;
import mediathek.tool.FilterDTO;

public class FilterSelectionComboBoxModel
extends DefaultComboBoxModel<FilterDTO> {
    private final FilterConfiguration filterConfiguration = new FilterConfiguration();
    private final List<FilterDTO> availableFilters = new ArrayList<FilterDTO>();

    @Override
    public void setSelectedItem(Object anObject) {
        super.setSelectedItem(anObject);
        if (anObject != null) {
            this.filterConfiguration.setCurrentFilter((FilterDTO)anObject);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.filterConfiguration.getCurrentFilter();
    }

    public FilterSelectionComboBoxModel() {
        this.availableFilters.addAll(this.filterConfiguration.getAvailableFilters());
        FilterConfiguration.addAvailableFiltersObserver(() -> SwingUtilities.invokeLater(() -> {
            this.availableFilters.clear();
            this.availableFilters.addAll(this.filterConfiguration.getAvailableFilters());
            this.fireContentsChanged(this, 0, this.availableFilters.size());
        }));
        FilterConfiguration.addCurrentFiltersObserver(filterDTO -> SwingUtilities.invokeLater(() -> {
            if (this.getSelectedItem() != filterDTO) {
                this.fireContentsChanged(this, 0, this.availableFilters.size());
            }
        }));
    }

    @Override
    public int getSize() {
        return this.availableFilters.size();
    }

    @Override
    public FilterDTO getElementAt(int index) {
        return this.availableFilters.get(index);
    }
}

