/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.tasks.DefaultTaskReference;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.tasks.TaskReference;
import org.gradle.composite.internal.AbstractCompositeParticipantBuildState;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.util.Path;

public class DefaultIncludedBuild
extends AbstractCompositeParticipantBuildState
implements IncludedBuildState {
    private final Path identityPath;
    private final BuildDefinition buildDefinition;
    private final boolean isImplicit;

    public DefaultIncludedBuild(Path identityPath, BuildDefinition buildDefinition, boolean isImplicit, BuildState owner, BuildTreeState buildTree) {
        super(buildTree, buildDefinition.newInstance(), owner);
        assert (!identityPath.equals((Object)Path.ROOT)) : "An included build must not be located at the root path";
        this.identityPath = identityPath;
        this.buildDefinition = buildDefinition;
        this.isImplicit = isImplicit;
    }

    public BuildDefinition getBuildDefinition() {
        return this.buildDefinition;
    }

    public File getRootDirectory() {
        return this.buildDefinition.getBuildRootDir();
    }

    public Path getIdentityPath() {
        return this.identityPath;
    }

    public boolean isImplicitBuild() {
        return this.isImplicit;
    }

    public boolean isImportableBuild() {
        return !this.isImplicit;
    }

    public IncludedBuildInternal getModel() {
        TaskDependencyFactory taskDependencyFactory = (TaskDependencyFactory)this.getBuildServices().get(TaskDependencyFactory.class);
        return new IncludedBuildImpl(this, taskDependencyFactory);
    }

    public boolean isPluginBuild() {
        return this.buildDefinition.isPluginBuild();
    }

    File getProjectDir() {
        return this.buildDefinition.getBuildRootDir();
    }

    public String getName() {
        return this.identityPath.getName();
    }

    public void assertCanAdd(IncludedBuildSpec includedBuildSpec) {
        if (this.isImplicit) {
            super.assertCanAdd(includedBuildSpec);
        }
    }

    public File getBuildRootDir() {
        return this.buildDefinition.getBuildRootDir();
    }

    public Action<? super DependencySubstitutions> getRegisteredDependencySubstitutions() {
        return this.buildDefinition.getDependencySubstitutions();
    }

    public <T> T withState(Transformer<T, ? super GradleInternal> action) {
        return (T)action.transform((Object)this.getMutableModel());
    }

    public ExecutionResult<Void> finishBuild() {
        return this.getBuildController().finishBuild(null);
    }

    public static class IncludedBuildImpl
    implements IncludedBuildInternal {
        private final DefaultIncludedBuild buildState;
        private final TaskDependencyFactory taskDependencyFactory;

        public IncludedBuildImpl(DefaultIncludedBuild buildState, TaskDependencyFactory taskDependencyFactory) {
            this.buildState = buildState;
            this.taskDependencyFactory = taskDependencyFactory;
        }

        public String getName() {
            return this.buildState.getName();
        }

        public File getProjectDir() {
            return this.buildState.getProjectDir();
        }

        public TaskReference task(String pathStr) {
            return DefaultTaskReference.create((String)pathStr, (TaskDependencyFactory)this.taskDependencyFactory);
        }

        public BuildState getTarget() {
            return this.buildState;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IncludedBuildImpl that = (IncludedBuildImpl)o;
            return ((Object)((Object)this.buildState)).equals((Object)that.buildState);
        }

        public int hashCode() {
            return ((Object)((Object)this.buildState)).hashCode();
        }
    }
}

