﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudtrail/CloudTrail_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CloudTrail {
namespace Model {

/**
 * <p>A storage lake of event data against which you can run complex SQL-based
 * queries. An event data store can include events that you have logged on your
 * account. To select events for an event data store, use <a
 * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-concepts.html#adv-event-selectors">advanced
 * event selectors</a>.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/EventDataStore">AWS
 * API Reference</a></p>
 */
class EventDataStore {
 public:
  AWS_CLOUDTRAIL_API EventDataStore() = default;
  AWS_CLOUDTRAIL_API EventDataStore(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDTRAIL_API EventDataStore& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDTRAIL_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ARN of the event data store.</p>
   */
  inline const Aws::String& GetEventDataStoreArn() const { return m_eventDataStoreArn; }
  inline bool EventDataStoreArnHasBeenSet() const { return m_eventDataStoreArnHasBeenSet; }
  template <typename EventDataStoreArnT = Aws::String>
  void SetEventDataStoreArn(EventDataStoreArnT&& value) {
    m_eventDataStoreArnHasBeenSet = true;
    m_eventDataStoreArn = std::forward<EventDataStoreArnT>(value);
  }
  template <typename EventDataStoreArnT = Aws::String>
  EventDataStore& WithEventDataStoreArn(EventDataStoreArnT&& value) {
    SetEventDataStoreArn(std::forward<EventDataStoreArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the event data store.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  EventDataStore& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_eventDataStoreArn;

  Aws::String m_name;
  bool m_eventDataStoreArnHasBeenSet = false;
  bool m_nameHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudTrail
}  // namespace Aws
