/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

This filter calculates the Euclidean distance transform of a binary
image in linear time for arbitrary dimensions.


Inputs and Outputs
This is an image-to-image filter. The dimensionality is arbitrary. The
only dimensionality constraint is that the input and output images be
of the same dimensions and size. To maintain integer arithmetic within
the filter, the default output is the signed squared distance. This
implies that the input image should be of type "unsigned int" or
"int" whereas the output image is of type "int". Obviously, if the
user wishes to utilize the image spacing or to have a filter with the
Euclidean distance (as opposed to the squared distance), output image
types of float or double should be used.
 The inside is considered as having negative distances. Outside is
treated as having positive distances. To change the convention, use
the InsideIsPositive(bool) function.

Parameters
Set/GetBackgroundValue specifies the background of the value of the
input binary image. Normally this is zero and, as such, zero is the
default value. Other than that, the usage is completely analogous to
the itk::DanielssonDistanceImageFilter class except it does not return
the Voronoi map.
 Reference: C. R. Maurer, Jr., R. Qi, and V. Raghavan, "A Linear Time Algorithm for Computing Exact Euclidean Distance Transforms of Binary Images in
Arbitrary Dimensions", IEEE - Transactions on Pattern Analysis and
Machine Intelligence, 25(2): 265-270, 2003.
See:
 itk::simple::SignedMaurerDistanceMap for the procedural interface

 itk::SignedMaurerDistanceMapImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkSignedMaurerDistanceMapImageFilter.h
*/
public class SignedMaurerDistanceMapImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected SignedMaurerDistanceMapImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.SignedMaurerDistanceMapImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(SignedMaurerDistanceMapImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(SignedMaurerDistanceMapImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::SignedMaurerDistanceMapImageFilter::~SignedMaurerDistanceMapImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_SignedMaurerDistanceMapImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::SignedMaurerDistanceMapImageFilter::SignedMaurerDistanceMapImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  SignedMaurerDistanceMapImageFilter() {
    this(SimpleITKJNI.new_SignedMaurerDistanceMapImageFilter(), true);
  }

  /**
Self&amp; itk::simple::SignedMaurerDistanceMapImageFilter::SetInsideIsPositive(bool InsideIsPositive)

Set if the inside represents positive values in the signed distance
map. By convention ON pixels are treated as inside pixels.

*/
public  void setInsideIsPositive(boolean InsideIsPositive) {
    SimpleITKJNI.SignedMaurerDistanceMapImageFilter_setInsideIsPositive(swigCPtr, this, InsideIsPositive);
  }

  /**
Self&amp; itk::simple::SignedMaurerDistanceMapImageFilter::InsideIsPositiveOn()

Set the value of InsideIsPositive to true or false respectfully.

*/
public  void insideIsPositiveOn() {
    SimpleITKJNI.SignedMaurerDistanceMapImageFilter_insideIsPositiveOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SignedMaurerDistanceMapImageFilter::InsideIsPositiveOff()
*/
public  void insideIsPositiveOff() {
    SimpleITKJNI.SignedMaurerDistanceMapImageFilter_insideIsPositiveOff(swigCPtr, this);
  }

  /**
bool itk::simple::SignedMaurerDistanceMapImageFilter::GetInsideIsPositive() const

Get if the inside represents positive values in the signed distance
map.
See:
 GetInsideIsPositive()


*/
public  boolean getInsideIsPositive() {
    return SimpleITKJNI.SignedMaurerDistanceMapImageFilter_getInsideIsPositive(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SignedMaurerDistanceMapImageFilter::SetSquaredDistance(bool SquaredDistance)

Set if the distance should be squared.

*/
public  void setSquaredDistance(boolean SquaredDistance) {
    SimpleITKJNI.SignedMaurerDistanceMapImageFilter_setSquaredDistance(swigCPtr, this, SquaredDistance);
  }

  /**
Self&amp; itk::simple::SignedMaurerDistanceMapImageFilter::SquaredDistanceOn()

Set the value of SquaredDistance to true or false respectfully.

*/
public  void squaredDistanceOn() {
    SimpleITKJNI.SignedMaurerDistanceMapImageFilter_squaredDistanceOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SignedMaurerDistanceMapImageFilter::SquaredDistanceOff()
*/
public  void squaredDistanceOff() {
    SimpleITKJNI.SignedMaurerDistanceMapImageFilter_squaredDistanceOff(swigCPtr, this);
  }

  /**
bool itk::simple::SignedMaurerDistanceMapImageFilter::GetSquaredDistance() const

Get the distance squared.

*/
public  boolean getSquaredDistance() {
    return SimpleITKJNI.SignedMaurerDistanceMapImageFilter_getSquaredDistance(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SignedMaurerDistanceMapImageFilter::SetUseImageSpacing(bool UseImageSpacing)

Set if image spacing should be used in computing distances.

*/
public  void setUseImageSpacing(boolean UseImageSpacing) {
    SimpleITKJNI.SignedMaurerDistanceMapImageFilter_setUseImageSpacing(swigCPtr, this, UseImageSpacing);
  }

  /**
Self&amp; itk::simple::SignedMaurerDistanceMapImageFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public  void useImageSpacingOn() {
    SimpleITKJNI.SignedMaurerDistanceMapImageFilter_useImageSpacingOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SignedMaurerDistanceMapImageFilter::UseImageSpacingOff()
*/
public  void useImageSpacingOff() {
    SimpleITKJNI.SignedMaurerDistanceMapImageFilter_useImageSpacingOff(swigCPtr, this);
  }

  /**
bool itk::simple::SignedMaurerDistanceMapImageFilter::GetUseImageSpacing() const

Get whether spacing is used.

*/
public  boolean getUseImageSpacing() {
    return SimpleITKJNI.SignedMaurerDistanceMapImageFilter_getUseImageSpacing(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SignedMaurerDistanceMapImageFilter::SetBackgroundValue(double BackgroundValue)

Set the background value which defines the object. Usually this value
is = 0.

*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.SignedMaurerDistanceMapImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::SignedMaurerDistanceMapImageFilter::GetBackgroundValue() const

Set the background value which defines the object. Usually this value
is = 0.

*/
public  double getBackgroundValue() {
    return SimpleITKJNI.SignedMaurerDistanceMapImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
std::string itk::simple::SignedMaurerDistanceMapImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.SignedMaurerDistanceMapImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::SignedMaurerDistanceMapImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.SignedMaurerDistanceMapImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::SignedMaurerDistanceMapImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.SignedMaurerDistanceMapImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
