/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.util.string.Strings;

public abstract class StyleAttributeModifier
extends AttributeAppender {
    private static final Pattern STYLES_SPLITTER = Pattern.compile("\\s*;\\s*");
    private static final Pattern KEY_VALUE_SPLITTER = Pattern.compile("\\s*:\\s*");

    public StyleAttributeModifier() {
        super("style", null, ";");
    }

    @Override
    protected Serializable newValue(String currentValue, String appendValue) {
        String[] styles = Strings.isEmpty(currentValue) ? new String[]{} : STYLES_SPLITTER.split(currentValue.trim());
        LinkedHashMap<String, String> oldStyles = new LinkedHashMap<String, String>();
        for (String style : styles) {
            String[] keyValue = KEY_VALUE_SPLITTER.split(style, 2);
            oldStyles.put(keyValue[0], keyValue[1]);
        }
        Map<String, String> newStyles = this.update(oldStyles);
        String separator = this.getSeparator();
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : newStyles.entrySet()) {
            result.append(entry.getKey()).append(':').append(entry.getValue()).append(separator);
        }
        return result.length() > 0 ? result.toString() : VALUELESS_ATTRIBUTE_REMOVE;
    }

    protected abstract Map<String, String> update(Map<String, String> var1);
}

