/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.inspector;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.devutils.DevUtilsPage;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.NonCachingImage;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.PageableListView;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigator;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.RequestLogger;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.lang.Bytes;

public class RequestsPage
extends DevUtilsPage {
    private static final long serialVersionUID = 1L;
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd MMM hh:mm:ss.SSS");

    public RequestsPage(final IRequestLogger.SessionData sessionData) {
        this.add(new Component[]{new NonCachingImage("bug")});
        if (sessionData == null) {
            this.add(new Component[]{new Label("id").setVisible(false)});
            this.add(new Component[]{new Label("sessionInfo").setVisible(false)});
            this.add(new Component[]{new Label("startDate").setVisible(false)});
            this.add(new Component[]{new Label("lastRequestTime").setVisible(false)});
            this.add(new Component[]{new Label("numberOfRequests").setVisible(false)});
            this.add(new Component[]{new Label("totalTimeTaken").setVisible(false)});
            this.add(new Component[]{new Label("size").setVisible(false)});
            this.add(new Component[]{new WebMarkupContainer("sessionid")});
        } else {
            this.add(new Component[]{new Label("id", (IModel)new Model((Serializable)((Object)sessionData.getSessionId())))});
            this.add(new Component[]{new Label("sessionInfo", (IModel)new Model((Serializable)sessionData.getSessionInfo()))});
            this.add(new Component[]{new Label("startDate", (IModel)new Model((Serializable)((Object)this.sdf.format(sessionData.getStartDate()))))});
            this.add(new Component[]{new Label("lastRequestTime", (IModel)new Model((Serializable)((Object)this.sdf.format(sessionData.getLastActive()))))});
            this.add(new Component[]{new Label("numberOfRequests", (IModel)new Model((Serializable)Long.valueOf(sessionData.getNumberOfRequests())))});
            this.add(new Component[]{new Label("totalTimeTaken", (IModel)new Model((Serializable)Long.valueOf(sessionData.getTotalTimeTaken())))});
            this.add(new Component[]{new Label("size", (IModel)new Model((Serializable)Bytes.bytes((long)sessionData.getSessionSize())))});
            this.add(new Component[]{new WebMarkupContainer("sessionid").setVisible(false)});
        }
        IModel<List<IRequestLogger.RequestData>> requestsModel = new IModel<List<IRequestLogger.RequestData>>(){
            private static final long serialVersionUID = 1L;

            public ArrayList<IRequestLogger.RequestData> getObject() {
                List requests = RequestsPage.this.getRequestLogger().getRequests();
                if (sessionData != null) {
                    ArrayList<IRequestLogger.RequestData> returnValues = new ArrayList<IRequestLogger.RequestData>();
                    for (IRequestLogger.RequestData data : requests) {
                        if (!sessionData.getSessionId().equals(data.getSessionId())) continue;
                        returnValues.add(data);
                    }
                    return returnValues;
                }
                return new ArrayList<IRequestLogger.RequestData>(requests);
            }
        };
        PageableListView<IRequestLogger.RequestData> listView = new PageableListView<IRequestLogger.RequestData>("requests", (IModel)requestsModel, 50L){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<IRequestLogger.RequestData> item) {
                IRequestLogger.RequestData rd = (IRequestLogger.RequestData)item.getModelObject();
                item.add(new Component[]{new Label("id", (IModel)new Model((Serializable)((Object)rd.getSessionId()))).setVisible(sessionData == null)});
                item.add(new Component[]{new Label("startDate", (IModel)new Model((Serializable)((Object)RequestsPage.this.sdf.format(rd.getStartDate()))))});
                item.add(new Component[]{new Label("timeTaken", (IModel)new Model((Serializable)rd.getTimeTaken()))});
                String eventTarget = rd.getEventTarget() != null ? rd.getEventTarget().getClass().getName() : "";
                item.add(new Component[]{new Label("eventTarget", (IModel)new Model((Serializable)((Object)eventTarget)))});
                String responseTarget = rd.getResponseTarget() != null ? rd.getResponseTarget().getClass().getName() : "";
                item.add(new Component[]{new Label("responseTarget", (IModel)new Model((Serializable)((Object)responseTarget)))});
                item.add(new Component[]{new Label("alteredObjects", (IModel)new Model((Serializable)((Object)rd.getAlteredObjects()))).setEscapeModelStrings(false)});
                item.add(new Component[]{new Label("sessionSize", (IModel)new Model((Serializable)Bytes.bytes((long)rd.getSessionSize())))});
            }
        };
        this.add(new Component[]{listView});
        PagingNavigator navigator = new PagingNavigator("navigator", (IPageable)listView);
        this.add(new Component[]{navigator});
    }

    IRequestLogger getRequestLogger() {
        WebApplication webApplication = (WebApplication)Application.get();
        IRequestLogger requestLogger = webApplication.getRequestLogger();
        if (webApplication.getRequestLogger() == null) {
            requestLogger = new RequestLogger();
        }
        return requestLogger;
    }
}

