/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.ArrayList;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.ConditionalPageMasterReference;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.SubSequenceSpecifier;

public class RepeatablePageMasterAlternatives
extends FObj
implements SubSequenceSpecifier {
    private static final int INFINITE = -1;
    private PageSequenceMaster pageSequenceMaster;
    private int maximumRepeats;
    private int numberConsumed = 0;
    private ArrayList conditionalPageMasterRefs;

    public RepeatablePageMasterAlternatives(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
        if (!parent.getName().equals("fo:page-sequence-master")) {
            throw new FOPException("A fo:repeatable-page-master-alternativesmust be child of fo:page-sequence-master, not " + parent.getName(), systemId, line, column);
        }
        this.pageSequenceMaster = (PageSequenceMaster)parent;
        this.pageSequenceMaster.addSubsequenceSpecifier(this);
        String mr = this.getProperty("maximum-repeats").getString();
        if (mr.equals("no-limit")) {
            this.maximumRepeats = -1;
        } else {
            try {
                this.maximumRepeats = Integer.parseInt(mr);
                if (this.maximumRepeats < 0) {
                    this.log.debug("negative maximum-repeats: " + this.maximumRepeats);
                    this.maximumRepeats = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new FOPException("Invalid number for 'maximum-repeats' property", systemId, line, column);
            }
        }
        this.conditionalPageMasterRefs = new ArrayList();
    }

    public void addConditionalPageMasterReference(ConditionalPageMasterReference cpmr) {
        this.conditionalPageMasterRefs.add(cpmr);
    }

    public String getName() {
        return "fo:repeatable-page-master-alternatives";
    }

    public String getNextPageMasterName(boolean isOddPage, boolean isFirstPage, boolean isEmptyPage) {
        if (this.maximumRepeats != -1) {
            if (this.numberConsumed < this.maximumRepeats) {
                ++this.numberConsumed;
            } else {
                return null;
            }
        }
        int i = 0;
        while (i < this.conditionalPageMasterRefs.size()) {
            ConditionalPageMasterReference cpmr = (ConditionalPageMasterReference)this.conditionalPageMasterRefs.get(i);
            if (cpmr.isValid(isOddPage, isFirstPage, isEmptyPage)) {
                return cpmr.getMasterName();
            }
            ++i;
        }
        return null;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void reset() {
        this.numberConsumed = 0;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new RepeatablePageMasterAlternatives(parent, propertyList, systemId, line, column);
        }
    }
}

