/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceDeclarations;
import net.sf.saxon.om.NamespaceDeclarationsImpl;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.pull.PullFilter;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.trans.XPathException;

public class PullNamespaceReducer
extends PullFilter
implements NamespaceResolver {
    private int[] namestack = new int[50];
    int elementJustEnded = -1;
    private int[] allNamespaces = new int[50];
    private int allNamespacesSize = 0;
    private int[] namespaceCountStack = new int[50];
    private int depth = 0;
    private int[] localNamespaces;
    private int localNamespacesSize = 0;
    private int nameCode;
    private NamespaceDeclarations declaredNamespaces;
    private AttributeCollection attributeCollection;
    private int[] pendingUndeclarations = null;
    private int[] nsBuffer = new int[20];

    public PullNamespaceReducer(PullProvider pullProvider) {
        super(pullProvider);
    }

    public int next() throws XPathException {
        this.currentEvent = super.next();
        switch (this.currentEvent) {
            case 4: {
                this.startElement();
                break;
            }
            case 5: {
                this.endElement();
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                this.nameCode = super.getNameCode();
                break;
            }
            default: {
                this.nameCode = -1;
            }
        }
        return this.currentEvent;
    }

    private void startElement() throws XPathException {
        int n;
        Object object;
        this.namespaceCountStack[this.depth] = 0;
        if (++this.depth >= this.namespaceCountStack.length) {
            object = new int[this.depth * 2];
            System.arraycopy(this.namespaceCountStack, 0, object, 0, this.depth);
            this.namespaceCountStack = (int[])object;
            int[] nArray = new int[this.depth * 2];
            System.arraycopy(this.namestack, 0, nArray, 0, this.depth);
            this.namestack = nArray;
        }
        object = super.getNamespaceDeclarations();
        this.localNamespaces = object.getNamespaceCodes(this.nsBuffer);
        this.localNamespacesSize = 0;
        for (n = 0; n < this.localNamespaces.length && this.localNamespaces[n] != -1; ++n) {
            if (!this.isNeeded(this.localNamespaces[n])) continue;
            this.addGlobalNamespace(this.localNamespaces[n]);
            int n2 = this.depth - 1;
            this.namespaceCountStack[n2] = this.namespaceCountStack[n2] + 1;
            this.localNamespaces[this.localNamespacesSize++] = this.localNamespaces[n];
        }
        this.namestack[this.depth - 1] = this.nameCode = this.checkProposedPrefix(super.getNameCode(), 0);
        this.attributeCollection = super.getAttributes();
        n = 0;
        for (int i = 0; i < this.attributeCollection.getLength(); ++i) {
            int n3;
            int n4 = this.attributeCollection.getNameCode(i);
            if ((n4 & 0xFFF00000) == 0 || n4 == (n3 = this.checkProposedPrefix(n4, i + 1))) continue;
            if (n == 0) {
                this.attributeCollection = this.copyAttributeCollection(this.attributeCollection);
                n = 1;
            }
            ((AttributeCollectionImpl)this.attributeCollection).setAttribute(i, n3, this.attributeCollection.getTypeAnnotation(i), this.attributeCollection.getValue(i), this.attributeCollection.getLocationId(i), this.attributeCollection.getProperties(i));
        }
        if (this.localNamespacesSize < this.localNamespaces.length) {
            this.localNamespaces[this.localNamespacesSize] = -1;
        }
        this.declaredNamespaces = new NamespaceDeclarationsImpl(this.getNamePool(), this.localNamespaces);
        this.namespaceCountStack[this.depth - 1] = this.localNamespacesSize;
    }

    private void addLocalNamespace(int n) {
        if (this.localNamespacesSize < this.localNamespaces.length) {
            this.localNamespaces[this.localNamespacesSize++] = n;
        } else if (this.localNamespacesSize == 0) {
            this.localNamespaces = new int[10];
        } else {
            int[] nArray = new int[this.localNamespacesSize * 2];
            System.arraycopy(this.localNamespaces, 0, nArray, 0, this.localNamespacesSize);
            this.localNamespaces = nArray;
            this.localNamespaces[this.localNamespacesSize++] = n;
        }
        this.addGlobalNamespace(n);
    }

    private boolean isNeeded(int n) {
        int n2;
        if (n == 65537) {
            return false;
        }
        if (this.pendingUndeclarations != null) {
            for (n2 = 0; n2 < this.pendingUndeclarations.length; ++n2) {
                if (n >> 16 != this.pendingUndeclarations[n2] >> 16) continue;
                this.pendingUndeclarations[n2] = -1;
            }
        }
        for (n2 = this.allNamespacesSize - 1; n2 >= 0; --n2) {
            if (this.allNamespaces[n2] == n) {
                return false;
            }
            if (this.allNamespaces[n2] >> 16 != n >> 16) continue;
            return true;
        }
        return n != 0;
    }

    private int checkProposedPrefix(int n, int n2) {
        NamePool namePool = this.getNamePool();
        int n3 = namePool.getNamespaceCode(n);
        if (n3 == -1) {
            n3 = namePool.allocateNamespaceCode(n);
        }
        int n4 = n3 >> 16;
        for (int i = this.allNamespacesSize - 1; i >= 0; --i) {
            if (n4 != this.allNamespaces[i] >> 16) continue;
            if ((n3 & 0xFFFF) == (this.allNamespaces[i] & 0xFFFF)) {
                return n;
            }
            if (i + this.localNamespacesSize >= this.allNamespacesSize) {
                String string = this.getSubstitutePrefix(n3, n2);
                int n5 = namePool.allocate(string, namePool.getURI(n), namePool.getLocalName(n));
                int n6 = namePool.allocateNamespaceCode(n5);
                this.addLocalNamespace(n6);
                return n5;
            }
            this.addLocalNamespace(n3);
            return n;
        }
        if (n3 != 0) {
            this.addLocalNamespace(n3);
        }
        return n;
    }

    private String getSubstitutePrefix(int n, int n2) {
        String string = this.getNamePool().getPrefixFromNamespaceCode(n);
        return string + '_' + n2;
    }

    private void addGlobalNamespace(int n) {
        if (this.allNamespacesSize + 1 >= this.allNamespaces.length) {
            int[] nArray = new int[this.allNamespacesSize * 2];
            System.arraycopy(this.allNamespaces, 0, nArray, 0, this.allNamespacesSize);
            this.allNamespaces = nArray;
        }
        this.allNamespaces[this.allNamespacesSize++] = n;
    }

    public int getNameCode() {
        if (this.currentEvent == 5) {
            return this.elementJustEnded;
        }
        return this.nameCode;
    }

    public AttributeCollection getAttributes() throws XPathException {
        return this.attributeCollection;
    }

    private AttributeCollectionImpl copyAttributeCollection(AttributeCollection attributeCollection) {
        AttributeCollectionImpl attributeCollectionImpl = new AttributeCollectionImpl(this.getNamePool());
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            attributeCollectionImpl.addAttribute(attributeCollection.getNameCode(i), attributeCollection.getTypeAnnotation(i), attributeCollection.getValue(i), attributeCollection.getLocationId(i), attributeCollection.getProperties(i));
        }
        return attributeCollectionImpl;
    }

    public NamespaceDeclarations getNamespaceDeclarations() throws XPathException {
        if (this.currentEvent == 5) {
            int n = this.namespaceCountStack[this.depth];
            int[] nArray = new int[n];
            System.arraycopy(this.allNamespaces, this.allNamespacesSize, nArray, 0, n);
            return new NamespaceDeclarationsImpl(this.getNamePool(), nArray);
        }
        return this.declaredNamespaces;
    }

    public void endElement() throws XPathException {
        if (this.depth-- == 0) {
            throw new IllegalStateException("Attempt to output end tag with no matching start tag");
        }
        this.elementJustEnded = this.namestack[this.depth];
        int n = this.namespaceCountStack[this.depth];
        this.allNamespacesSize -= n;
    }

    protected short getURICode(short s) {
        for (int i = this.allNamespacesSize - 1; i >= 0; --i) {
            if (this.allNamespaces[i] >> 16 != s) continue;
            return (short)(this.allNamespaces[i] & 0xFFFF);
        }
        if (s == 0) {
            return 0;
        }
        return -1;
    }

    public String getURIForPrefix(String string, boolean bl) {
        NamePool namePool = this.getNamePool();
        if (!(string != null && string.length() != 0 || bl)) {
            return "";
        }
        if ("xml".equals(string)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        short s = namePool.getCodeForPrefix(string);
        short s2 = this.getURICode(s);
        if (s2 == -1) {
            return null;
        }
        return namePool.getURIFromURICode(s2);
    }

    public Iterator iteratePrefixes() {
        NamePool namePool = this.getNamePool();
        ArrayList<String> arrayList = new ArrayList<String>(this.allNamespacesSize);
        for (int i = this.allNamespacesSize - 1; i >= 0; --i) {
            String string = namePool.getPrefixFromNamespaceCode(this.allNamespaces[i]);
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        arrayList.add("xml");
        return arrayList.iterator();
    }
}

