# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
"""Unittests for tvm.script.ir_builder.ir"""
import pytest
import tvm.testing
from tvm.script.ir_builder import IRBuilder
from tvm.script.ir_builder import ir as I
from tvm import ir
from tvm.ir.base import assert_structural_equal


def test_ir_builder_irmodule():
    with IRBuilder() as ib:  # pylint: disable=invalid-name
        with I.ir_module():
            pass

    # the ir_module generated by IRBuilder
    ir_module_actual = ib.get()

    # the expected prim_func
    ir_module_expected = ir.IRModule(None, None)

    assert_structural_equal(ir_module_actual, ir_module_expected, map_free_vars=True)


if __name__ == "__main__":
    tvm.testing.main()
