/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import jakarta.servlet.FilterConfig;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.catalina.util.RateLimiter;
import org.apache.catalina.util.TimeBucketCounterBase;

public abstract class RateLimiterBase
implements RateLimiter {
    private static final AtomicInteger index = new AtomicInteger();
    TimeBucketCounterBase bucketCounter;
    int requests;
    int actualRequests;
    int duration;
    int actualDuration;
    private String policyName = null;
    private ScheduledThreadPoolExecutor internalExecutorService = null;

    protected abstract String getDefaultPolicyName();

    @Override
    public String getPolicyName() {
        if (this.policyName == null) {
            this.policyName = this.getDefaultPolicyName() + "-" + index.incrementAndGet();
        }
        return this.policyName;
    }

    @Override
    public void setPolicyName(String name) {
        Objects.requireNonNull(name);
        this.policyName = name;
    }

    @Override
    public int getDuration() {
        return this.actualDuration;
    }

    @Override
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public int getRequests() {
        return this.actualRequests;
    }

    @Override
    public void setRequests(int requests) {
        this.requests = requests;
    }

    @Override
    public int increment(String identifier) {
        return this.bucketCounter.increment(identifier);
    }

    @Override
    public void destroy() {
        this.bucketCounter.destroy();
        if (this.internalExecutorService != null) {
            try {
                this.internalExecutorService.shutdown();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    protected abstract TimeBucketCounterBase newCounterInstance(int var1, ScheduledExecutorService var2);

    @Override
    public void setFilterConfig(FilterConfig filterConfig) {
        ScheduledExecutorService executorService = (ScheduledExecutorService)filterConfig.getServletContext().getAttribute(ScheduledThreadPoolExecutor.class.getName());
        if (executorService == null) {
            this.internalExecutorService = new ScheduledThreadPoolExecutor(1);
            executorService = this.internalExecutorService;
        }
        this.bucketCounter = this.newCounterInstance(this.duration, executorService);
        this.actualDuration = this.bucketCounter.getBucketDuration();
        this.actualRequests = (int)Math.round(this.bucketCounter.getRatio() * (double)this.requests);
    }

    public TimeBucketCounterBase getBucketCounter() {
        return this.bucketCounter;
    }
}

