/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.common.Preconditions;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TaskLocationHint {
    private Set<String> hosts;
    private Set<String> racks;
    private TaskBasedLocationAffinity affinitizedTask;

    private TaskLocationHint(String vertexName, int taskIndex) {
        Objects.requireNonNull(vertexName);
        Preconditions.checkArgument(taskIndex >= 0);
        this.affinitizedTask = new TaskBasedLocationAffinity(vertexName, taskIndex);
    }

    private TaskLocationHint(Set<String> hosts, Set<String> racks) {
        this.hosts = hosts != null ? Collections.unmodifiableSet(hosts) : null;
        this.racks = racks != null ? Collections.unmodifiableSet(racks) : null;
    }

    public static TaskLocationHint createTaskLocationHint(String vertexName, int taskIndex) {
        return new TaskLocationHint(vertexName, taskIndex);
    }

    public static TaskLocationHint createTaskLocationHint(Set<String> hosts, Set<String> racks) {
        return new TaskLocationHint(hosts, racks);
    }

    public TaskBasedLocationAffinity getAffinitizedTask() {
        return this.affinitizedTask;
    }

    public Set<String> getHosts() {
        return this.hosts;
    }

    public Set<String> getRacks() {
        return this.racks;
    }

    public int hashCode() {
        int prime = 9397;
        int result = 1;
        result = this.hosts != null ? 9397 * result + this.hosts.hashCode() : result + 9397;
        int n = result = this.racks != null ? 9397 * result + this.racks.hashCode() : result + 9397;
        if (this.affinitizedTask != null) {
            result = 9397 * result + this.affinitizedTask.getVertexName().hashCode() + this.affinitizedTask.getTaskIndex();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskLocationHint other = (TaskLocationHint)obj;
        if (this.hosts != null ? !this.hosts.equals(other.hosts) : other.hosts != null) {
            return false;
        }
        if (this.racks != null ? !this.racks.equals(other.racks) : other.racks != null) {
            return false;
        }
        if (this.affinitizedTask != null) {
            if (other.affinitizedTask == null) {
                return false;
            }
            if (this.affinitizedTask.getTaskIndex() != other.affinitizedTask.getTaskIndex()) {
                return false;
            }
            if (!this.affinitizedTask.getVertexName().equals(other.affinitizedTask.getVertexName())) {
                return false;
            }
        } else if (other.affinitizedTask != null) {
            return false;
        }
        return true;
    }

    @InterfaceStability.Unstable
    public static class TaskBasedLocationAffinity {
        private String vertexName;
        private int taskIndex;

        public TaskBasedLocationAffinity(String vertexName, int taskIndex) {
            this.vertexName = vertexName;
            this.taskIndex = taskIndex;
        }

        public String getVertexName() {
            return this.vertexName;
        }

        public int getTaskIndex() {
            return this.taskIndex;
        }

        public String toString() {
            return "[Vertex: " + this.vertexName + ", TaskIndex: " + this.taskIndex + "]";
        }
    }
}

