/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.analyzer.plugins;

import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.analyzer.Analyzer;
import org.apache.tez.analyzer.CSVResult;
import org.apache.tez.analyzer.Result;
import org.apache.tez.analyzer.plugins.TezAnalyzerBase;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.Event;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.apache.tez.history.parser.datamodel.TaskInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;

public class DagOverviewAnalyzer
extends TezAnalyzerBase
implements Analyzer {
    private final String[] headers = new String[]{"name", "id", "event_type", "status", "event_time", "event_time_str", "vertex_task_stats", "diagnostics"};
    private final CSVResult csvResult = new CSVResult(this.headers);
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public DagOverviewAnalyzer(Configuration config) {
        super(config);
    }

    @Override
    public void analyze(DagInfo dagInfo) throws TezException {
        for (Event event : dagInfo.getEvents()) {
            this.csvResult.addRecord(new String[]{dagInfo.getDagId(), dagInfo.getDagId(), event.getType(), dagInfo.getStatus(), Long.toString(event.getTime()), DagOverviewAnalyzer.toDateStr(event.getTime()), "", ""});
        }
        for (VertexInfo vertex : dagInfo.getVertices()) {
            for (Event event : vertex.getEvents()) {
                String vertexFailureInfoIfAny = "";
                for (TaskAttemptInfo attempt : vertex.getTaskAttempts()) {
                    if (!attempt.getStatus().contains("FAILED")) continue;
                    vertexFailureInfoIfAny = attempt.getTaskAttemptId() + ": " + attempt.getDiagnostics().replaceAll(",", " ").replaceAll("\n", " ");
                    break;
                }
                this.csvResult.addRecord(new String[]{vertex.getVertexName(), vertex.getVertexId(), event.getType(), vertex.getStatus(), Long.toString(event.getTime()), DagOverviewAnalyzer.toDateStr(event.getTime()), this.getTaskStats(vertex), vertexFailureInfoIfAny});
            }
            for (TaskInfo failedTask : vertex.getFailedTasks()) {
                for (Event failedTaskEvent : failedTask.getEvents()) {
                    if (!failedTaskEvent.getType().equalsIgnoreCase("TASK_FINISHED")) continue;
                    this.csvResult.addRecord(new String[]{vertex.getVertexName(), failedTask.getTaskId(), failedTaskEvent.getType(), failedTask.getStatus(), Long.toString(failedTaskEvent.getTime()), DagOverviewAnalyzer.toDateStr(failedTaskEvent.getTime()), this.getTaskStats(vertex), failedTask.getDiagnostics().replaceAll(",", " ").replaceAll("\n", " ")});
                }
                for (TaskAttemptInfo failedAttempt : failedTask.getFailedTaskAttempts()) {
                    for (Event failedTaskAttemptEvent : failedAttempt.getEvents()) {
                        if (!failedTaskAttemptEvent.getType().equalsIgnoreCase("TASK_ATTEMPT_FINISHED")) continue;
                        this.csvResult.addRecord(new String[]{vertex.getVertexName(), failedAttempt.getTaskAttemptId(), failedTaskAttemptEvent.getType(), failedAttempt.getStatus(), Long.toString(failedTaskAttemptEvent.getTime()), DagOverviewAnalyzer.toDateStr(failedTaskAttemptEvent.getTime()), this.getTaskStats(vertex), failedAttempt.getDiagnostics().replaceAll(",", " ").replaceAll("\n", " ")});
                    }
                }
            }
        }
        this.csvResult.sort(new Comparator<String[]>(){

            @Override
            public int compare(String[] first, String[] second) {
                return (int)(Long.parseLong(first[4]) - Long.parseLong(second[4]));
            }
        });
    }

    private String getTaskStats(VertexInfo vertex) {
        return String.format("numTasks: %d failedTasks: %d completedTasks: %d", vertex.getNumTasks(), vertex.getFailedTasksCount(), vertex.getCompletedTasksCount());
    }

    private static synchronized String toDateStr(long time) {
        return FORMAT.format(new Date(time));
    }

    @Override
    public Result getResult() throws TezException {
        return this.csvResult;
    }

    @Override
    public String getName() {
        return "Dag overview analyzer";
    }

    @Override
    public String getDescription() {
        return "High level dag events overview (dag, vertex event summary). Helps understand the overall progress of a dag by simply listing the dag/vertex related events";
    }

    public static void main(String[] args) throws Exception {
        Configuration config = new Configuration();
        DagOverviewAnalyzer analyzer = new DagOverviewAnalyzer(config);
        int res = ToolRunner.run((Configuration)config, (Tool)analyzer, (String[])args);
        analyzer.printResults();
        System.exit(res);
    }
}

