/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.common.resources;

import java.util.Objects;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class InitialMemoryRequestContext {
    private long requestedSize;
    private String componentClassName;
    private ComponentType componentType;
    private String componentVertexName;

    public InitialMemoryRequestContext(long requestedSize, String componentClassName, ComponentType componentType, String componentVertexName) {
        Objects.requireNonNull(componentClassName, "componentClassName is null");
        Objects.requireNonNull(componentType, "componentType is null");
        Objects.requireNonNull(componentVertexName, "componentVertexName is null");
        this.requestedSize = requestedSize;
        this.componentClassName = componentClassName;
        this.componentType = componentType;
        this.componentVertexName = componentVertexName;
    }

    public long getRequestedSize() {
        return this.requestedSize;
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public String getComponentVertexName() {
        return this.componentVertexName;
    }

    public static enum ComponentType {
        INPUT,
        OUTPUT,
        PROCESSOR;

    }
}

