/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.examples;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.client.TezClient;
import org.apache.tez.common.Preconditions;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.library.vertexmanager.ShuffleVertexManager;
import org.apache.tez.examples.HashJoinExample;
import org.apache.tez.examples.TezExampleBase;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.mapreduce.processor.SimpleMRProcessor;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.api.Reader;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.apache.tez.runtime.library.api.KeyValuesReader;
import org.apache.tez.runtime.library.conf.OrderedPartitionedKVEdgeConfig;
import org.apache.tez.runtime.library.partitioner.HashPartitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortMergeJoinExample
extends TezExampleBase {
    private static final Logger LOG = LoggerFactory.getLogger(SortMergeJoinExample.class);
    private static final String input1 = "input1";
    private static final String input2 = "input2";
    private static final String inputFile = "inputFile";
    private static final String joiner = "joiner";
    private static final String joinOutput = "joinOutput";

    public static void main(String[] args) throws Exception {
        SortMergeJoinExample job = new SortMergeJoinExample();
        int status = ToolRunner.run((Configuration)new Configuration(), (Tool)job, (String[])args);
        System.exit(status);
    }

    @Override
    protected void printUsage() {
        System.err.println("Usage: sortmergejoin <file1> <file2> <numPartitions> <outPath>");
    }

    @Override
    protected int runJob(String[] args, TezConfiguration tezConf, TezClient tezClient) throws Exception {
        String inputDir1 = args[0];
        String inputDir2 = args[1];
        int numPartitions = Integer.parseInt(args[2]);
        String outputDir = args[3];
        Path inputPath1 = new Path(inputDir1);
        Path inputPath2 = new Path(inputDir2);
        Path outputPath = new Path(outputDir);
        FileSystem fs = outputPath.getFileSystem((Configuration)tezConf);
        if (fs.exists(outputPath = fs.makeQualified(outputPath))) {
            System.err.println("Output directory: " + outputDir + " already exists");
            return 3;
        }
        if (numPartitions <= 0) {
            System.err.println("NumPartitions must be > 0");
            return 4;
        }
        DAG dag = this.createDag(tezConf, inputPath1, inputPath2, outputPath, numPartitions);
        LOG.info("Running SortMergeJoinExample");
        return this.runDag(dag, this.isCountersLog(), LOG);
    }

    @Override
    protected int validateArgs(String[] otherArgs) {
        if (otherArgs.length != 4) {
            return 2;
        }
        return 0;
    }

    private DAG createDag(TezConfiguration tezConf, Path inputPath1, Path inputPath2, Path outPath, int numPartitions) throws IOException {
        DAG dag = DAG.create((String)"SortMergeJoinExample");
        Vertex inputVertex1 = Vertex.create((String)input1, (ProcessorDescriptor)ProcessorDescriptor.create((String)HashJoinExample.ForwardingProcessor.class.getName())).addDataSource(inputFile, MRInput.createConfigBuilder((Configuration)new Configuration((Configuration)tezConf), TextInputFormat.class, (String)inputPath1.toUri().toString()).groupSplits(!this.isDisableSplitGrouping()).generateSplitsInAM(!this.isGenerateSplitInClient()).build());
        Vertex inputVertex2 = Vertex.create((String)input2, (ProcessorDescriptor)ProcessorDescriptor.create((String)HashJoinExample.ForwardingProcessor.class.getName())).addDataSource(inputFile, MRInput.createConfigBuilder((Configuration)new Configuration((Configuration)tezConf), TextInputFormat.class, (String)inputPath2.toUri().toString()).groupSplits(!this.isDisableSplitGrouping()).generateSplitsInAM(!this.isGenerateSplitInClient()).build());
        Vertex joinVertex = Vertex.create((String)joiner, (ProcessorDescriptor)ProcessorDescriptor.create((String)SortMergeJoinProcessor.class.getName()), (int)numPartitions).setVertexManagerPlugin(ShuffleVertexManager.createConfigBuilder((Configuration)tezConf).setAutoReduceParallelism(true).build()).addDataSink(joinOutput, MROutput.createConfigBuilder((Configuration)new Configuration((Configuration)tezConf), TextOutputFormat.class, (String)outPath.toUri().toString()).build());
        OrderedPartitionedKVEdgeConfig edgeConf = OrderedPartitionedKVEdgeConfig.newBuilder((String)Text.class.getName(), (String)NullWritable.class.getName(), (String)HashPartitioner.class.getName()).setFromConfiguration((Configuration)tezConf).build();
        Edge e1 = Edge.create((Vertex)inputVertex1, (Vertex)joinVertex, (EdgeProperty)edgeConf.createDefaultEdgeProperty());
        Edge e2 = Edge.create((Vertex)inputVertex2, (Vertex)joinVertex, (EdgeProperty)edgeConf.createDefaultEdgeProperty());
        dag.addVertex(inputVertex1).addVertex(inputVertex2).addVertex(joinVertex).addEdge(e1).addEdge(e2);
        return dag;
    }

    public static class SortMergeJoinProcessor
    extends SimpleMRProcessor {
        public SortMergeJoinProcessor(ProcessorContext context) {
            super(context);
        }

        public void run() throws Exception {
            Preconditions.checkState((this.getInputs().size() == 2 ? 1 : 0) != 0);
            Preconditions.checkState((this.getOutputs().size() == 1 ? 1 : 0) != 0);
            LogicalInput logicalInput1 = (LogicalInput)this.getInputs().get(SortMergeJoinExample.input1);
            LogicalInput logicalInput2 = (LogicalInput)this.getInputs().get(SortMergeJoinExample.input2);
            Reader inputReader1 = logicalInput1.getReader();
            Reader inputReader2 = logicalInput2.getReader();
            Preconditions.checkState((boolean)(inputReader1 instanceof KeyValuesReader));
            Preconditions.checkState((boolean)(inputReader2 instanceof KeyValuesReader));
            LogicalOutput lo = (LogicalOutput)this.getOutputs().get(SortMergeJoinExample.joinOutput);
            Preconditions.checkState((boolean)(lo.getWriter() instanceof KeyValueWriter));
            KeyValueWriter writer = (KeyValueWriter)lo.getWriter();
            this.join((KeyValuesReader)inputReader1, (KeyValuesReader)inputReader2, writer);
        }

        private void join(KeyValuesReader inputReader1, KeyValuesReader inputReader2, KeyValueWriter writer) throws IOException {
            while (inputReader1.next() && inputReader2.next()) {
                Text value1 = (Text)inputReader1.getCurrentKey();
                Text value2 = (Text)inputReader2.getCurrentKey();
                boolean reachEnd = false;
                while (value1.compareTo((BinaryComparable)value2) != 0) {
                    if (value1.compareTo((BinaryComparable)value2) > 0) {
                        if (inputReader2.next()) {
                            value2 = (Text)inputReader2.getCurrentKey();
                            continue;
                        }
                        reachEnd = true;
                        break;
                    }
                    if (inputReader1.next()) {
                        value1 = (Text)inputReader1.getCurrentKey();
                        continue;
                    }
                    reachEnd = true;
                    break;
                }
                if (reachEnd) break;
                writer.write((Object)value1, (Object)NullWritable.get());
            }
        }
    }
}

